'use strict'

const getMarkers = () => {
  // Get the transport markers
  const transportEntity = entities['0']
  const entityDef = entityRegistry['system']['transport']
  let {
    markers,
  } = { ...calculateStaticConfig(transportEntity.config, entityDef.staticConfig)}
  markers.sort((a, b) => a-b)
  return markers
}
const getPreviousMarker = (markers, time) => {
  for (let i = markers.length - 1; i >= 0; i--) {
    if (time >= markers[i]) {
      return [i, time === markers[i]]
    }
  }
  return [-1, false]
}

class TransportMp3 {
  constructor (audioElement) {
    this._audio = audioElement
    this._audio.loop = false
    this._playHeadPosition = 0
    this._playMode = 'play'

    /*
    this._audio.addEventListener('canplay', (event) => console.log('canplay'))
    this._audio.addEventListener('canplaythrough', (event) => console.log('canplaythrough'))
    this._audio.addEventListener('stalled', (event) => console.log('stalled'))
    this._audio.addEventListener('waiting', (event) => console.log('waiting'))
    */
  }
  seekRelativeBar (direction) {
    const time = this.getCurrentTime()
    const barLength = 60 / bpm
    const barStartTime = time - time % barLength
    if (direction < 0) {
      const mod = (time === barStartTime) ? barLength : 0
      transport.seekExact(barStartTime - mod)
    } else {
      transport.seekExact(barStartTime + barLength)
    }
  }
  seekRelativeMarker (direction) {
    const markers = getMarkers()
    const [previousMarker, atMarker] = getPreviousMarker(markers, this.getCurrentTime() / 60 * bpm)
    if (direction < 0) {
      if (previousMarker >= 0) {
        if (atMarker) {
          this.seekExact(markers[previousMarker - 1] * 60 / bpm)
        } else {
          this.seekExact(markers[previousMarker] * 60 / bpm)
        }
      } else {
        this.seekExact(0)
      }
    } else if (previousMarker >= 0 && previousMarker < markers.length-1) {
      this.seekExact(markers[previousMarker + 1] * 60 / bpm)
    }
  }
  seekExact (time) {
    this._playHeadPosition = time
    this._audio.currentTime = time
  }
  seekDelta(time) {
    this._playHeadPosition = this._playHeadPosition + time
    this._audio.currentTime = this._playHeadPosition
  }
  update () {
    if (this.getIsPlaying()) {
      const preUpdateFrameTime = this.getCurrentTime() / 60 * bpm
      this._playHeadPosition = this._audio.currentTime
      const postUpdateFrameTime = this.getCurrentTime() / 60 * bpm

      if (this._playMode === 'loop') {
        const markers = getMarkers()
        const [preUpdateMarker, preAtMarker] = getPreviousMarker(markers, preUpdateFrameTime)
        const [postUpdateMarker, postAtMarker] = getPreviousMarker(markers, postUpdateFrameTime)

        if (preUpdateMarker >= 0 && preUpdateMarker !== postUpdateMarker) {
          this.seekExact(markers[preUpdateMarker] * 60 / bpm)
        }
      }
    }
  }
  getPlayMode () {
    return this._playMode
  }
  getIsPlaying () {
    return !this._audio.paused
  }
  setIsPlaying(isPlaying, looping = true) {
    if (isPlaying) {
      this._audio.play()
      this._playMode = looping ? 'loop' : 'play'
    } else {
      this._audio.pause()
      this._playMode = 'stop'
    }
  }
  getCurrentTime () {
    return this._playHeadPosition
  }
}
