#version 330 core
out vec4 FragColor;

uniform sampler2D mainImage;
uniform sampler2D drawnLogo;

uniform float act;
uniform vec3 fade;
uniform vec3 mutual;
uniform float time;

in vec2 texPosition;

vec3 blur(sampler2D t, vec2 uv, int n) {
	vec3 c = vec3(0.0);
	float rf = 1.0, gf = 1.0, bf = 1.0;
	float dist = 1.0 - smoothstep(0.0, 1.5, length(uv));
	for(int i = 0; i < n; i++){
		c.r += texture(t, 0.5 + 0.5 * (uv * rf)).r;
		c.g += texture(t, 0.5 + 0.5 * (uv * gf)).g;
		c.b += texture(t, 0.5 + 0.5 * (uv * bf)).b;
		
		rf *= 0.9982;
		gf *= 0.992;
        bf *= 0.9982;
		
	}
	c *= dist;
	return c / n;
}

void main(void) {
	vec2 pos = texPosition * 2.0 - 1.0;
	vec4 mainPixel = vec4(blur(mainImage, pos, 15), 1.0);
	mainPixel *= mod(gl_FragCoord.x, 3.0) + mod(gl_FragCoord.y, 3.0);	

	if (act == 5) {
		vec2 logoUV = texPosition;
		logoUV.y = (logoUV.y - 1.0) * -1.0;
		float logoAspect = 1349.0 / 441.0;
		logoUV *= vec2(1.0, logoAspect);

		logoUV.y *= sin(logoUV.x * 2.0 + 0.5);
		logoUV.x += sin(mutual.x * 1.0);
		vec4 logoPixel = texture(drawnLogo, logoUV);
		vec4 logoColor = vec4(0.3, 0.8, 0.9, 1.0);
		logoPixel *= logoColor;

		mainPixel = mix(mainPixel, logoPixel, logoPixel.a);
	}

	mainPixel = pow(mainPixel, vec4(1.0 / 1.2));

	gl_FragColor = mainPixel * vec4(fade, 1.0);
}