#version 330 core


uniform float time = 1.0;
uniform vec3 lightSource = vec3(0.0,0.0,0.0);
uniform vec4 frontLight = vec4(1.0,1.0,1.0,1.0);
uniform vec3 N;
uniform vec3 v;

in vec2 texCoord;
in vec4 vertexFragColor;
out vec4 fragColor;
uniform sampler2D texture0;

void main() 
{
   
	vec2 xy=texCoord;
   vec3 L = normalize(lightSource*2.0 - v);   
   vec4 Idiff = frontLight * max(dot(N,L), 0.0);  
   Idiff = clamp(Idiff, 0.0, 1.0); 
   
   	//vec2 coord = texture(texture0,xy);

	
	vec4 color= texture(texture0,xy);

	vec4 newColor=(color+.05*Idiff*sin(25*time));
    newColor*=color.a;
	newColor.a=1.0;
	fragColor = newColor;
}