(function (window, document) {
if (!window.XMPlayer) {
  window.XMPlayer = {};
}
var XMPlayer = window.XMPlayer;
if (!window.XMView) {
  window.XMView = {};
}
var XMView = window.XMView;

function loadXMAndInit(xmdata) {
  if (!XMPlayer.load(xmdata)) {
    return;
  }

  XMView.init();

  var playbutton = document.getElementById("playpause");
  playbutton.onclick = function() {
    if (XMPlayer.playing) {
      XMPlayer.pause();
      playbutton.innerHTML='Play';
    } else {
      XMPlayer.play();
      playbutton.style.display = 'none';
      playbutton.style.opacity = 0.3;
      playbutton.innerHTML='Pause';

      // play vidoe
      var video = document.getElementById("video");
      video.play();
    }
  };
  playbutton.disabled = false;

  return XMPlayer.xm;
}

function downloadXM(uri) {
  var xmReq = new XMLHttpRequest();
  xmReq.open("GET", uri, true);
  xmReq.responseType = "arraybuffer";
  xmReq.onload = function (xmEvent) {
    var arrayBuffer = xmReq.response;
    if (arrayBuffer) {
      loadXMAndInit(arrayBuffer);
    } else {
      console.log("unable to load", uri);
    }
  };
  xmReq.send(null);
}

window.onload = function() {
  XMPlayer.init();

  var uri = location.hash.substr(1);
  console.log(uri)
  if (uri === "") {
    uri = "song.xm";
  }
  // if (!uri.startsWith("http")) {
    // uri = baseuri + uri;
  // }
  downloadXM(uri);
};

})(window, document);
