// modified from https://github.com/anissen/ld34/blob/master/web/assets/shaders/blur.glsl

#version 130

precision mediump float;

uniform sampler2D currentTexture;
uniform float blur;
uniform vec2 dir;

void main() {
	vec4 sum = vec4(0.0);

	// gaussian
	sum += texture2D(currentTexture, vec2(gl_TexCoord[0].x - 4.0*blur*dir.x, gl_TexCoord[0].y - 4.0*blur*dir.y)) * 0.0162162162;
	sum += texture2D(currentTexture, vec2(gl_TexCoord[0].x - 3.0*blur*dir.x, gl_TexCoord[0].y - 3.0*blur*dir.y)) * 0.0540540541;
	sum += texture2D(currentTexture, vec2(gl_TexCoord[0].x - 2.0*blur*dir.x, gl_TexCoord[0].y - 2.0*blur*dir.y)) * 0.1216216216;
	sum += texture2D(currentTexture, vec2(gl_TexCoord[0].x - 1.0*blur*dir.x, gl_TexCoord[0].y - 1.0*blur*dir.y)) * 0.1945945946;

	sum += texture2D(currentTexture, vec2(gl_TexCoord[0].x, gl_TexCoord[0].y)) * 0.2270270270;

	sum += texture2D(currentTexture, vec2(gl_TexCoord[0].x + 1.0*blur*dir.x, gl_TexCoord[0].y + 1.0*blur*dir.y)) * 0.1945945946;
	sum += texture2D(currentTexture, vec2(gl_TexCoord[0].x + 2.0*blur*dir.x, gl_TexCoord[0].y + 2.0*blur*dir.y)) * 0.1216216216;
	sum += texture2D(currentTexture, vec2(gl_TexCoord[0].x + 3.0*blur*dir.x, gl_TexCoord[0].y + 3.0*blur*dir.y)) * 0.0540540541;
	sum += texture2D(currentTexture, vec2(gl_TexCoord[0].x + 4.0*blur*dir.x, gl_TexCoord[0].y + 4.0*blur*dir.y)) * 0.0162162162;

	gl_FragColor = sum;
}
