#version 130

uniform float iTime = 0;
uniform float voroniTiles = 32.;
uniform float minVoroniDist; // = 0.7; //0.7;

vec2 random( vec2 p ) {
    return fract(sin(vec2(dot(p,vec2(127.1,311.7)),dot(p,vec2(269.5,183.3))))*43758.5453);
}

void main()
{
    vec2 uv = gl_TexCoord[0].xy; // / vec2(1920,1080).xy; // iResolution.xy;
    uv.x *= 1920/1080; // iResolution.x / iResolution.y;
    
    uv *= voroniTiles;
    
    vec3 col = vec3(0.);
    
    vec2 tile = floor(uv);
    vec2 tileCoord = fract(uv);
    
    float minDist = 10000.;
    
    for(int y = -1; y <= 1; y++)
    {
        for(int x = -1; x <= 1; x++)
        {
            vec2 n = vec2(x,y);
            vec2 p = random(tile + n);
            
            p = sin(iTime * p) / 2. + 0.5;
            
            float dist = length(p + n - tileCoord);
            
            minDist = min(minDist, dist);
        }
    }
    
    minDist = max(minDist, minVoroniDist);
    col = vec3(length(minDist));
    
    gl_FragColor = vec4(col,1.0);
}