	DEVICE	ZXSPECTRUM48

	org	#7081		;28801
begin:
	di
	ld	hl,#5780
	ld	sp,hl
	push	hl
;	ld	hl,finish-1
	ld	h,#71		; high finish-1
	ld	de,#6900

; -----------------------------------------------------------------------------
; ZX2 decoder by Einar Saukas
; "Nano" version (48-55 bytes) - BACKWARDS VARIANT
; -----------------------------------------------------------------------------
; Parameters:
;   HL: last source address (compressed data)
;   DE: last destination address (decompressing)
; -----------------------------------------------------------------------------

dzx2_nano_back:

;IF DEFINED ZX2_Z_IGNORE_DEFAULT
;        ld      b, 0                    ; allocate default offset
	ld	b,e	;!!!

;ELSE
;        ld      bc, 1                   ; preserve default offset 1
;ENDIF

        push    bc
;        ld      a, $80
	ld	a,l     ;!!!
dzx2nb_literals:
        call    dzx2nb_elias            ; obtain length
        lddr                            ; copy literals
        add     a, a                    ; copy from last offset or new offset?
        jr      c, dzx2nb_new_offset
dzx2nb_reuse:
        call    dzx2nb_elias            ; obtain length
dzx2nb_copy:
        ex      (sp), hl                ; preserve source, restore offset
        push    hl                      ; preserve offset
        add     hl, de                  ; calculate destination - offset
        lddr                            ; copy from offset
        pop     hl                      ; restore offset
        ex      (sp), hl                ; preserve offset, restore source
        add     a, a                    ; copy from literals or new offset?
        jr      nc, dzx2nb_literals
dzx2nb_new_offset:
        pop     bc                      ; discard last offset
        ld      c, (hl)                 ; obtain offset LSB
        dec     hl
        inc     c
        ret     z                       ; check end marker
        push    bc                      ; preserve new offset

;IF DEFINED ZX2_X_SKIP_INCREMENT
        jr      dzx2nb_reuse
;ELSE
;        call    dzx2nb_elias            ; obtain length
;        inc     bc
;        jr      dzx2nb_copy
;ENDIF

dzx2nb_elias:
        ld      c, 1                    ; interlaced Elias gamma coding
dzx2nb_elias_loop:
        add     a, a
        jr      nz, dzx2nb_elias_skip
        ld      a, (hl)                 ; load another group of 8 bits
        dec     hl
        rla
dzx2nb_elias_skip:
        ret     nc
        add     a, a
        rl      c

;IF DEFINED ZX2_Y_LIMIT_LENGTH
;ELSE
        rl      b
;ENDIF

        jr      dzx2nb_elias_loop

packed:
	INCBIN	"unpacked.bin.zx2"
;------------------------------------------
finish:	
	SAVESNA	"urold.sna", begin
	SAVEBIN	"urold", begin, finish-begin
;	EMPTYTRD "urold.trd","uROLd"
	SAVETRD	"urold.trd","urold.C",begin,finish-begin

;----BASIC---------------------------------

;BAS2TAP -c -a1 -cm urold.txt -s"uROLd" urold.tap
;tapmaker.exe "urold" urold.tap 28801

;0001 rem -----------------------
;0002 rem .       uROLd
;0003 rem .256 byte intro by .ded
;0004 rem .       =RMDA=
;0005 rem .     18.09.2023
;0006 rem -----------------------
;0007 rem
;0008 rem . Some 50fps fullscreen
;0009 rem .    action for ye olde
;0010 rem .       ZX Spectrum 16K
;0011 rem .
;0012 rem .Expect some raindrops!
;0013 rem -----------------------
;0014 rem
;0015 load "urold" code 28801
;0016 clear
;0017 list
;0018 pause 13*37
;0019 randomize usr 28801
