#version 450

layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

layout (set = 0, binding = 0) uniform Context {
    float g_simulation_step_seconds;
    float g_app_time;

#include "sdf_params.glsl"
};

#include "particles.glsl"

layout (set = 0, binding = 1) buffer ParticlesCurrent {
    Particle buf[];
} particles_current;

layout (set = 0, binding = 2) buffer writeonly ParticlesNext {
    Particle buf[];
} particles_next;

const vec3 GRAVITY = vec3(0, -10.0, 0);
const float BOUNCE_VELOCITY_LOSS = 0.01;
const float BOUNCE_HARDNESS = 0.3;
const float MAX_OUTWARD_MOVEMENT = 1000;
const float MIN_OUTWARD_MOVEMENT = 1;
const float PARTICLE_GROWTH = 4;
const float MAX_VELOCITY = 10.0;

const float FIELD_1_STRENGTH = 10.1;
const float FIELD_2_STRENGTH = 10.1;

#include "sdf_function.glsl"
#include "sdf_utils.glsl"


float field_3(vec3 pos) {
    return
    sin(pos.x * pos.y * 1.1) +
    sin(pos.y * pos.z * 2.1) +
    sin(pos.z * pos.x * 3.1);
}

vec3 calculate_field_3_force(vec3 pos) {
    float eps = 0.0001;
    vec3 x = vec3(eps, 0, 0);
    vec3 y = vec3(0, eps, 0);
    vec3 z = vec3(0, 0, eps);
    return normalize(vec3(
    field_3(pos + x) - field_3(pos - x),
    field_3(pos + y) - field_3(pos - y),
    field_3(pos + z) - field_3(pos - z)
    ));
}

float field_2(vec3 pos) {
    float l = length(pos.yz);
    float b = 1 / (l+1.0);
    return -pos.x * b;
}

vec3 calculate_field_2_force(vec3 pos) {
    float l = length(pos.yz);
    float b = 1 / (l+10.0);
    vec3 r = vec3(sin(pos.x * pos.y * 1.1),
    sin(pos.y * pos.z * 2.1),
    sin(pos.z * pos.x * 3.1));
    return (vec3(1, 0, 0) + r * 2) * b;
}

float field_1(vec3 pos) {
    return -sqrt(length(pos.yz));
}

vec3 calculate_field_1_force(vec3 pos) {
    float eps = 0.0001;
    vec3 x = vec3(eps, 0, 0);
    vec3 y = vec3(0, eps, 0);
    vec3 z = vec3(0, 0, eps);
    return normalize(vec3(
    field_1(pos + x) - field_1(pos - x),
    field_1(pos + y) - field_1(pos - y),
    field_1(pos + z) - field_1(pos - z)
    ));
}

void sim_step(inout vec3 pos, inout vec3 vel) {

    //Lorenz Attractor
    vec4 params = object_1_params;
    vec3 force = vec3(
        params.x * (pos.y - pos.x),
        pos.x * (params.y - pos.z) - pos.y,
        pos.x * pos.y - params.z * pos.z
    );

    pos += force * g_simulation_step_seconds * 0.08 ;

    vec3 pos_pollen = object_1_pos;
    float dist = length(pos - pos_pollen);
    float pollen_strength = min(10000000000.0 / pow(dist + 0.01,7), object_1_params.w * 100);
    vec3 force_pollen = normalize(pos - pos_pollen) * pollen_strength;
    pos += force_pollen * g_simulation_step_seconds;

    //    vel += calculate_field_1_force(pos) * 10;
    //    vel += calculate_field_2_force(pos) * 100;
    ////    pos += calculate_field_3_force(pos) * 0.1;
    //
    //    float l = length(vel);
    //    if (l > MAX_VELOCITY) {
    //        vel = vel / l * MAX_VELOCITY;
    //    }
    //
    //    pos += vel * g_simulation_step_seconds;
}


void main() {
    uint num_particles = particles_current.buf.length();

    // Calculate the new position and velocity of the particle.
    uint index = gl_GlobalInvocationID.x;
    if (index >= num_particles) {
        return;
    }

    vec3 pos = particles_current.buf[index].pos;
    vec3 vel = particles_current.buf[index].vel;
    float size = particles_current.buf[index].size;
    float pad = particles_current.buf[index]._pad;

    // Apply gravity.
    vec3 next_vel = vel;
    vec3 next_pos = pos;

    // Simulate collisions.
    sim_step(next_pos, next_vel);

    // Grow the particle.
    size = clamp(size + PARTICLE_GROWTH * g_simulation_step_seconds, 0, 1);

    // Reset if particle falls too deep
    if (next_pos.y < -100) {
        //        next_pos = vec3(sin(float(index+g_app_time*100+1) * 0.1122), sin(index+g_app_time*10) *1.2 + 2.25, sin(float(index) * 1.3122));
        //        next_vel = vec3(sin(float(index*1.212+g_app_time*100+1) * 0.0004122), sin(index+g_app_time*130) *0.0002, sin(float(index*3.21) * 0.003122)) * 0.1;
        //        size = 0;
        //        particles_current.buf[index] = Particle(next_pos, next_vel, size, pad);
        Particle p = init_particle(index);
        particles_current.buf[index] = p;
        particles_next.buf[index] = p;
    }

    particles_next.buf[index] = Particle(next_pos, next_vel, size, pad);
}


