layout (location = 0) in vec2 v_depth_map_uv;
layout (location = 1) in vec3 v_ray_eye;
layout (location = 2) in vec3 v_ray_direction;

layout (location = 0) out vec4 f_color;

layout (set = 1, binding = 1) uniform sampler2D noise;

layout (set = 1, binding = 0) uniform Uniforms {
    float g_app_time;
    vec4 args;
    vec4 args2;
    vec3 col1;
    vec3 col2;
};

void main() {
    vec3 color = vec3(0,0,0);
//    vec2 uv = v_depth_map_uv;
    for (float i=0; i<20; i+=1.0) {
        vec2 uv = v_ray_direction.xy * (i*args2.y+args2.z) * args.z + args.xy * g_app_time + i * args.w;
        vec4 samp = texture(noise, uv);
        samp = texture(noise, uv + samp.yx + g_app_time * args2.w);
        vec3 c = mix(col1, col2, samp.r);
        float alpha = args2.x * samp.g;
        color = color * (1.0 - alpha) + c * alpha;
    }

    f_color = vec4(color, 1);
}
