; btw - By The Way
;
; This program animates the unscrambling of a Burrows-Wheeler Transform (BWT).
; BWT is an algorithm that can reduce the entropy of non-random text, making it
; compress better. It performs best with large amounts of text.
;
; Original paper: https://www.hpl.hp.com/techreports/Compaq-DEC/SRC-RR-124.pdf
;
; Alas, there is no compression payoff for a 256 byte entry. The break-even
; point requires repeated substrings in the original data.
;
; Any decent qualities in the below code are purely accidental.
;
; -Kneebiter

org 0x100
bits 16

    call set_video_mode
    inc ah
    mov cx, 0x2706
    int 0x10                ; hide mouse cursor

    push 0xb800             ; text memory address
    pop es

    mov ah, 06h
    xor di, di
    mov dx, 2
write_loop_1
    mov si, $text_string
    mov cx, $end_of_text_string - $text_string
write_loop:
    lodsb
    stosw
    loop write_loop
    dec dx
    jnz write_loop_1

    mov ax, 0x0000
    mov cx, $end_of_text_string - $text_string
index_loop:
    stosw                      ; display on screen is arbitrary. Could be done off screen.
    inc ax
    inc ax
    loop index_loop

    mov bx, $end_of_text_string - $text_string - 1
sort:
    mov cx, bx
    mov si, 160
sort_loop:
    mov dx, 4
    call timer_delay

    mov ax, word es:[si]
    cmp ax, word es:[si+2]
    jle  sort_loop_end
    xchg ax, word es:[si+2]
    mov word es:[si], ax

    mov ax, word es:[si+160]
    xchg ax, word es:[si+162]
    mov word es:[si+160], ax
sort_loop_end:
    inc si
    inc si
    loop sort_loop
    dec bx
    jnz sort

;   unscramble BWT
    mov di, 640
    mov bx, 38
    mov bp, 1600
unscramble_loop:
    mov bl, byte es:[bx+320]
    mov ax, es:[bx]

    mov byte es:[bx+1], 0xAC
    mov byte es:[bx+161], 0xC2
    mov word es:[di], ax
    mov dx, bp
    call timer_delay

    mov byte es:[bx+1], 0x0F
    mov byte es:[bx+161], 0x00
    stosw

    sub bp, 20
    cmp al, 'A'
    jne unscramble_loop

;   poll for esc key
wait_for_esc:
    in   al, 60h
    dec  al
    jnz  wait_for_esc

set_video_mode:
    mov ax, 0x0003
    int 0x10
    ret

timer_delay:
    pusha
delay_loop_2:
    mov cx, 0xffff
delay_loop:
    nop
    loop delay_loop
    dec dx
    jnz delay_loop_2
    popa
    ret

text_string:
  db 'v?.,,heesd4h3s -eS A  U  elsace ahtndsDr cirsgtrlMPpdeeiemmNse uttetsaoio nptibo'
end_of_text_string: