function granulate(grain) {
  loadPixels();
  let maxDistance = dist(0, 0, width / 2, height / 2);
  let editR = random() > 0.3;
  let editG = random() > 0.3;
  let editB = random() > 0.3;
  let maxRad = random(30, 80);
  for (let y = 0; y < height; y++) {
    for (let x = 0; x < width; x++) {
      let index = (x + y * width) * 4;
      let distance = dist(x, y, width / 2, height / 2) * 2;
      let colorOffset = map(distance, 0, maxDistance, maxRad, 0);
      let offset = map(random(), 0, 1, -grain, grain);
      if (editR) {
        pixels[index] = pixels[index] + colorOffset + offset;
      }
      if (editG) {
        pixels[index + 1] = pixels[index + 1] + colorOffset + offset;
      }
      if (editB) {
        pixels[index + 2] = pixels[index + 2] + colorOffset + offset;
      }
    }
  }
  updatePixels();
}

function pulsarMap(r) {
  push();
  translate(width / 2, height / 2);
  let steps = random(0.0005, 0.05);
  let baseColor = color(random(200, 255));
  let fixedAngle = random() > 0.5;
  rotate(random(TWO_PI));
  if (fixedAngle) {
    push();
    let starColor = color(random(colors));
    starColor.setAlpha(50);
    fill(starColor);
    blendMode(SCREEN);
    for (let i = 0; i < 100; i++) {
      circle(random(-0.5, 0.5), random(-0.5, 0.5), 2 + random(-10));
    }
    pop();
  }

  let rx2 = random(-200, 200);
  let ry2 = random(-200, 200);
  let rx3 = random(-200, 200);
  let ry3 = random(-200, 200);
  let bezierColor = random(colors);
  let bezierMag = random(250);
  let randomDev = random(-150, 150);
  for (let i = 0; i < TWO_PI; i += steps) {
    stroke(255, random(150, 255));
    let noiseX = random(-r / 4, r / 4);
    let noiseY = random(-r / 4, r / 4);
    let v = createVector(sin(i) * r + noiseX, cos(i) * r + noiseY);
    if (f.useFixedAngle) {
      let maxFixedAngle = random(-0.6, 0.6);
      v.setHeading(
        random([
          -HALF_PI + maxFixedAngle,
          HALF_PI + maxFixedAngle,
          QUARTER_PI + maxFixedAngle,
        ])
      );
    }
    strokeWeight(random(2));
    drawingContext.filter = `blur(${random(-5, 5)}px)`;
    baseColor.setAlpha(random(50, 180));
    stroke(baseColor);
    drawingContext.setLineDash([random(50), random(50)]);
    line(0, 0, v.x, v.y);
    if (f.useBezier) {
      strokeWeight(random(5));
      let color1 = color(bezierColor);
      color1.setAlpha(random(50, 100));
      noFill();
      bezier(
        0,
        0,
        v.x + bezierMag,
        v.y + bezierMag + randomDev,
        v.x - bezierMag + randomDev,
        v.y + bezierMag + randomDev,
        v.x,
        v.y
      );
    }
  }
  // fill(0)
  // circle(0,0, random(50,200))
  pop();
}

function drawStars(max = 1000) {
  push();
  background(round(random(3, 6)));
  for (let i = 0; i < max; i++) {
    let x = random(width);
    let y = random(height);
    let weight = random(1.5);
    fill(255);
    stroke(random(100, 255));
    strokeWeight(weight);
    point(x, y);
  }
  pop();
}

let baseRotation = 0;
function drawShape(type, size, canRotate = true, incRotation = QUARTER_PI / 2) {
  push();
  translate(width / 2, height / 2);
  if (canRotate) {
    rotate(baseRotation);
    baseRotation += incRotation;
  }
  if (Number(type) === 0) {
    rectMode(CENTER);
    rect(0, 0, size);
  }
  if (Number(type) === 1) {
    circle(0, 0, size);
  }
  if (Number(type) === 2) {
    rectMode(CENTER);
    rect(0, 0, size / 3);
    circle(0, 0, size);
  }
  pop();
}

function backgroundShapes(
  shapeColor,
  alpha = 5,
  shape = null,
  minVal = 5,
  maxVal = 10,
  steps = 5,
  offSetInc = 1,
  canRotate = true,
  incRotation = QUARTER_PI
) {
  push();
  noFill();
  let maxCircles = random(20, 40);
  const hasShape = Number(shape) >= 0;
  let shapeType = hasShape ? shape : floor(random(3));
  let alphaVal = alpha;
  let offSetSize = 0;
  drawingContext.filter = `blur(${random(2, 20)}px)`; // TODO: this might be inside the loop
  for (let i = 0; i < maxCircles; i += steps) {
    const backgroundShape = floor(random(5, 80));
    strokeWeight(backgroundShape);
    let currColor = color(shapeColor);

    currColor.setAlpha(alphaVal);
    alphaVal += random(-5, 5);
    stroke(currColor);
    let size = map(i, 0, maxCircles, minVal, maxVal);

    drawShape(shapeType, size + offSetSize, canRotate, incRotation);
    offSetSize += offSetInc;
  }
  pop();
}

function clouds(canvas, inc = 0.002, alpha = 40) {
  let randomColor = color(random(colors));
  let randomR = randomColor.levels[0];
  let randomG = randomColor.levels[1];
  let randomB = randomColor.levels[2];
  canvas.background(255, alpha);
  canvas.push();
  let yoff = 0;
  canvas.loadPixels();
  for (let y = 0; y < height; y++) {
    let xoff = 0;
    for (let x = 0; x < width; x++) {
      let index = (x + y * width) * 4;
      // let r = random(255);
      let r = noise(xoff, yoff) * randomR;
      let g = noise(xoff, yoff) * randomG;
      let b = noise(xoff, yoff) * randomB;
      canvas.pixels[index + 0] = r;
      canvas.pixels[index + 1] = g;
      canvas.pixels[index + 2] = b;
      pixels[index + 3] = 255;

      xoff += inc;
    }
    yoff += inc;
  }
  canvas.updatePixels();
  canvas.pop();
}

let noiseCanvas, noiseCanvas2, noisecanvas3;
function setup() {
  // randomSeed(2)
  // noiseSeed(2)
  pixelDensity(1);
  createCanvas(windowWidth, windowHeight);
  noiseCanvas1 = createGraphics(windowWidth, windowHeight);
  noiseCanvas2 = createGraphics(windowWidth, windowHeight);
  noiseCanvas3 = createGraphics(windowWidth, windowHeight);

  let starsCount = random(4000, 5000);
  drawStars(starsCount);

  blendMode(HARD_LIGHT);
  clouds(noiseCanvas2, 0.005, 60);
  image(noiseCanvas2, 0, 0, width, height);

  blendMode(SOFT_LIGHT);
  let pulsarMapR = random(200, width * 0.6);
  pulsarMap(pulsarMapR);

  // INNER 0
  let iner0Alpha = random(40, 140);
  let shape = 0;
  let min = 30;
  let max = min;
  let steps0 = random([4, 5, 6, 7]);
  let inc0 = random() > 0.6 ? 0 : random(1, 50);
  let canRotate0 = boolean(random());
  let rotAmount = random([QUARTER_PI, HALF_PI, QUARTER_PI / 2]);
  backgroundShapes(
    255,
    iner0Alpha,
    shape,
    min,
    max,
    steps0,
    inc0,
    canRotate0,
    rotAmount
  );

  // INNER 1
  drawingContext.filter = `blur(100px)`;
  let min1 = floor(random(width * 0.2, width * 0.4));
  let max1 = min1 + 30;
  let inner1Alpha = 255;
  let shape1 = random([0, 1]);
  let steps1 = random(5, 15);
  let inc1 = 0;
  let canRotate1 = true;
  backgroundShapes(
    random(colors),
    inner1Alpha,
    shape1,
    min1,
    max1,
    steps1,
    inc1,
    canRotate1,
    random([QUARTER_PI, HALF_PI, QUARTER_PI / 2])
  );

  // INNER 2
  drawingContext.filter = `blur(${random(10, 15)}px)`;
  let min2 = floor(random(width * 0.5, width * 0.65));
  let max2 = min2 + 20;
  let inner2Alpha = random(150, 250);
  let shape2 = random([0, 1]);
  let steps2 = random(4, 20);
  let inc2 = random() > 0.5 ? 0 : random(2);
  let canRotate2 = boolean(random());
  backgroundShapes(
    random(colors),
    inner2Alpha,
    shape2,
    min2,
    max2,
    steps2,
    inc2,
    canRotate2
  );

  clouds(noiseCanvas1, 0.08, 60);
  image(noiseCanvas1, 0, 0, width, height);

  push();
  blendMode(random([DIFFERENCE, ADD]));
  let clouds3Noise = 0.04;
  let clouds3Alpha = random(40, 60);
  clouds(noiseCanvas3, clouds3Noise, clouds3Alpha);
  image(noiseCanvas3, 0, 0, width, height);
  pop();

  //   push()
  //   blendMode(BLEND)
  //   noFill();
  //   stroke(255);
  //   strokeWeight(5);
  //   rect(0, 0, width, height);
  //   pop()

  granulate(f.noise);
}

function draw() {}
