; The "better than nothing" transprent circles 
; Presented in TrueColor SVGA
; A 256-byte intro by Blacky/Exact
; Works on FreeDos (preferred) and DosBox 0.74-3 (slower)
; Compile with "nasm.exe circles.asm -fbin -o circles.com"

org 100h

	push 0a000h 
	pop es

	mov ax,4f02h
	mov bx,112h ; 640x480xTrueColor
	int 10h
	
clearBackground: ; the whole screen could be cleared with a big enough circle drawn first, but I ran out of time.. :/
	xor dx, dx ; SVGA page number
clearNextPage:
	call setSVGApage
	xor cx, cx
	dec cx
	
	push cx ; or we can just use the return value in al as clear color, but that's a lot darker
	pop ax
	
	rep stosb
	stosb

	inc dx
	cmp dx, 19
	jne clearNextPage

redraw:
	call random ; dx is ruined, but that's ok
	bswap eax ; different result than "shl eax, 16" but 1 byte shorter. It's a random number anyway.
	call random
	mov [si], eax ; si points to 100h

	xor dx, dx ; SVGA page number

nextPage:
	call setSVGApage
	xor di,di
	xor cx, cx
	dec cx

nextPixel:
	push dx
	push cx

	call calcCircle ; moving this to a function enables all the jumps at the end to be short jumps, so overall it saves 3 bytes

	cmp eax, ebx
	ja maybeDrawBorder
	
	mov cx, 4
	
	push si
	xor ax, ax
	lodsb
	and al, 0111b ; use 8 colors
	mov si, 108h ; start of palette
	shl ax, 2
	add si, ax

blend_rgba:
	xor bx, bx
	mov al, es:[di]
	mov bl, 3 ; weight the existing color 3x to make circles more transparent
	mul bl
	xchg ax, bx
	lodsb
	add ax, bx
	shr ax, 2
	
	stosb
	loop blend_rgba
	
	pop si
	
	jmp afterDraw
maybeDrawBorder:
	push ebx
	fild dword[esp]
	pop ebx
	fild word[077h] ; found 20h 00h in the PSP, which is good enough for border width
	fmulp
	fsqrt
	fistp dword[bp] ; bp points to 91ch, should be fine to write there
	add ebx, dword[bp]
	
	cmp eax, ebx
	ja doNotDraw
	mov al, 040h
	mov cx, 4
	rep stosb
	jmp afterDraw
doNotDraw:
	add di, 4
afterDraw:		
	pop cx
	pop dx

	loop nextPixel

	inc dx
end:
	cmp dx, 19
	jne nextPage
	
	in al, 60h ; check keyboard
	dec al
	jnz redraw

	;mov ax,03h ; remove in case of emergency
	;int 10h

	ret ; exit program

; random function based on xorshift
; returns random number in ax
; ruins dx
; 16 bit version from https://codebase64.org/doku.php?id=base:16bit_xorshift_random_generator
random: 
	mov ax, 433ch ; store the random seed IN the code and update the constant at the end
	mov dx, ax
	shl ax, 7
	xor ax, dx
	mov dx, ax
	shr ax, 9
	xor ax, dx
	mov dx, ax
	shl ax, 8
	xor ax, dx
	mov cs:[random+1], ax ; update random seed in the parameter of the mov ax instruction

	ret

setSVGApage:
	mov ax, 4f05h
	xor bx, bx
	int 10h
	
	ret

calcCircle:
	xor eax, eax
	push dx
	xor edx, edx
	pop dx

	mov ax, di
	mov bx, 640*4
	div bx ; ax = Y coord, dx = X coord*4
	shr dx, 2 ; ax = Y coord, dx = X coord
	
	mov ebx, [si]

	movzx ecx, bl
	shl cx, 1
	sub eax, ecx
	imul eax, eax

	movzx ecx, bh
	shl cx, 1
	sub edx, ecx
	sub edx, 64 ; offset with (640-512)/2
	imul edx, edx
	
	add eax, edx

	shr ebx, 18
	
	ret

;borderWidth dw 20 ; can we find this constant in memory? Yes, we can find a close enough number

;buffer: ; use si=100h as a buffer for storing data instead - we won't need the startup code after startup anyway

;colors db 255, 0, 0, 0 ; we don't need to store colors, rather find a nice palette in the code with FindPaletteInTheCode.cpp 
