; Escape - 256b intro by LBi/Bitbandit - 2023.08.26
; compile: nasm escape.asm -o escape.com

	org 0x100

	; first 10 bytes are data, be careful since this will be executed by the CPU
	dw 75				; dec bx
i16:	dw 16				; add [bx+si],dl
halfpi:
i32:	dw 32				; add [bx+si],ah (ax is zero, no harm)
cinc:	dw 0x3fc9			; ~PI/2
	dw 0x3ca8			; ~0.02

	mov ax, 0x13			; 320x200 256 color
	int 10h
i104 equ $
	push 0xa000			; VGA segment
	pop es

	mov dx, 0x0331			; MIDI control port
	mov ax, 0x223f			; "UART" mode + drum instrument
	out dx, al
	dec dx				; MIDI data port

	xor bx, bx
	fldz				; [cnt]

	push bx

main:
	hlt
	pop bx				; bx holds the anim variation counter
quit equ $
	inc bx
	push bx

	and bl, 0x7f			; change animation after every 128th update
	jnz .3

	add word [byte si+cinc+2], 90	; increment speed at every change

	push si
	mov si, pistol			; play the gunshot sound
i5 equ $+1
	mov cx, 5
	rep outsb
	pop si

.3:	and bh, 0x02			; quit after 3 anim change
	jz .2

	fild word [byte si+i104]	; high Y value -> show the floor
	mov byte [byte si+quit], 0xc3	; [quit] becomes ret
	jmp draw			; draw screen once more

.2:
	; increment animation counter
	fadd dword [byte si+cinc]	; [cnt+cinc]

	; calculate head movement (jumping)
	fldpi				; [pi] [cnt]
	fmul st0			; [pi*pi] [cnt]
	fmul st0, st1			; [pi*cnt] [cnt]
	fsin				; [sin] [cnt]
	fabs				; [abs(sin)] [cnt]
	fimul word [byte si+i5]		; [j=5*abs(sin)] [cnt]

	; find local minimum
	fld dword [bp+si+4]		; [pj] [j] [cnt]
	fld dword [bp+si+8]		; [ppj] [pj] [j] [cnt]
	fucomip st1			; [pj] [j] [cnt]
	jc .1				; jump if pj>ppj
	fucomi st1			; [pj] [j] [cnt]
	jnc .1				; jump if j<pj

	; foot step noise
	mov al, 0x99			; drum channel
	out dx, al
	xor ah, 1			; alternate drums
	mov al, ah
	inc al
	out dx, al
	mov al, 127			; max volume
	out dx, al

.1:	fstp dword [bp+si+8]		; [j] [cnt]
	fst dword [bp+si+4]		; [j] [cnt]

draw:	mov di, 32*320			; to speed up dosbox only 136 rows calculated (wide screen :)

	mov bx, 136			; Y
yloop:	mov word [bp+si], bx
	fild word [bp+si]		; [Y] [j] [cnt]
	fisub word [si]			; [Y-75] [j] [cnt]
	fsub st0, st1 			; [py=py-j] [j] [cnt]
	mov cx, 320			; X
xloop:	mov word [bp+si], cx
	fild word [bp+si]		; [X] [py] [j] [cnt]
	fisub word [si]			; [px=X-75] [py] [j] [cnt]
	fld st0				; [px] [px] [py] [j] [cnt]
	fabs				; [d=|px|] [px] [py] [j] [cnt]
	fmul dword [byte si+halfpi]	; [d=d*PI/2] [px] [py] [j] [cnt]
	fld st2				; [py] [d] [px] [py] [j] [cnt]
	fabs				; [|py|] [d] [px] [py] [j] [cnt]
	fucomi st1			; [|py|] [d] [px] [py] [j] [cnt]
	jc .1				; jump if d>|py|
	fxch				; [d] [|py|] [px] [py] [j] [cnt]
.1:	fstp st0			; [d] [px] [py] [j] [cnt]
	fld st2				; [py] [d] [px] [py] [j] [cnt]
	fadd st1			; [d2=d+py] [d] [px] [py] [j] [cnt]
	fld st2				; [px] [d2] [d] [px] [py] [j] [cnt]
	fmul st0			; [px2] [d2] [d] [px] [py] [j] [cnt]
	fld st4				; [py] [px2] [d2] [d] [px] [py] [j] [cnt]
	fmul st0			; [py2] [px2] [d2] [d] [px] [py] [j] [cnt]
	faddp st1			; [px2+py2] [d2] [d] [px] [py] [j] [cnt]
	fucomi st1			; [r] [d2] [d] [px] [py] [j] [cnt]
	jnc .2				; jump if d2<r
	fxch				; [d2] [r] [d] [px] [py] [j] [cnt]
.2:	fstp st0			; [d2] [d] [px] [py] [j] [cnt]
	fucomi st1			; [d2] [d] [px] [py] [j] [cnt]
	jc .3				; jump if d>d2
	fxch				; [d] [d2] [px] [py] [j] [cnt]
.3:	fstp st0			; [d] [px] [py] [j] [cnt]
	fild word [byte si+i32]		; [32] [d] [px] [py] [j] [cnt]
	fucomip st1			; [d] [px] [py] [j] [cnt]
	jc .4				; jump if d<32
	mov al, 0
	fstp st0			; [px] [py] [j] [cnt]
	fstp st0			; [py] [j] [cnt]
	jmp .5
.4:	fidivr word [byte si+i104]	; [v=104/d] [px] [py] [j] [cnt]
	fadd st4			; [v+=cnt] [px] [py] [j] [cnt]
	fimul word [byte si+i32]	; [v*=32] [px] [py] [j] [cnt]
	fistp word [bp+si]		; [px] [py] [j] [cnt]
	mov al, [bp+si]
	fld st1				; [py] [px] [py] [j] [cnt]
	fpatan				; [u=atan(px,py)] [py] [j] [cnt]
	fimul word [byte si+i16]	; [u*=16] [py] [j] [cnt]
	fdiv dword [byte si+halfpi]	; [u/=PI/2] [py] [j] [cnt]
	fistp word [bp+si]		; [py] [j] [cnt]
	xor al, [bp+si]			; xor pattern
	and al, 0x1e			; select colors
	add al, al
	add al, 2
.5:	stosb

	loop xloop

	fstp st0			; [j] [cnt]
	dec bx
	jnz yloop

	fstp st0			; [cnt]

	jmp main

pistol:	db 0xc0, 0x7f, 0x90, 0x3c, 0x7f	; pistol "note"
