layout (location = 0) in vec2 v_uv;
layout (location = 1) in vec3 v_normal;
layout (location = 2) in vec3 v_model_pos;
layout (location = 3) in vec3 v_tangent;
layout (location = 4) in vec3 v_light_dir;
layout (location = 5) in vec3 v_world_normal;
layout (location = 6) in vec3 v_world_pos;
layout (location = 7) in vec3 v_world_eye;
layout (location = 8) in vec3 v_world_tangent;
layout (location = 9) in vec3 v_camera_pos;

layout (set = 1, binding = 0) uniform Uniforms {
    mat4 g_light_projection_from_world;
    mat4 g_camera_from_world;
    mat4 g_projection_from_camera;
    vec4 color;
    float g_chart_time;
    float bias;
    float ambient;
    float normal_factor;

    vec3 specular_color;
    float g_app_time;
    vec4 foo;
    float cut_scale;
    float tex_scale;

    float obj_sphere_radius;
    vec3 obj_center;
    vec3 obj_rotate;
    float obj_transition;
};

void setup_sdf() {
    mat4 world_from_sdf_model = translate(-obj_center) * rotate(obj_rotate);
    mat4 camera_from_sdf_model = g_camera_from_world * world_from_sdf_model;
    sdf_model_from_camera = inverse(camera_from_sdf_model);
    l_obj_sphere_radius = obj_sphere_radius;
    l_obj_transition = obj_transition;
    if (sd(v_camera_pos) < 0) discard;
}

void main() {
    setup_sdf();
}
