layout (location = 0) in vec2 v_uv;
layout (location = 1) in vec3 v_normal;
layout (location = 2) in vec3 v_model_pos;
layout (location = 3) in vec3 v_tangent;
layout (location = 4) in vec3 v_light_dir;
layout (location = 5) in vec3 v_world_normal;
layout (location = 6) in vec3 v_world_pos;
layout (location = 7) in vec3 v_world_eye;
layout (location = 8) in vec3 v_world_tangent;
layout (location = 9) in vec3 v_camera_pos;

layout (location = 10) in vec3 v_cut_plane_center_1_c;
layout (location = 11) in vec3 v_cut_plane_normal_1_c;
layout (location = 12) in vec3 v_cut_plane_center_2_c;
layout (location = 13) in vec3 v_cut_plane_normal_2_c;


layout (set = 1, binding = 0) uniform Uniforms {
    mat4 g_light_projection_from_world;
    mat4 g_camera_from_world;
    mat4 g_projection_from_camera;
    vec4 color;
    float g_chart_time;
    float bias;
    float ambient;
    float normal_factor;

    vec3 specular_color;
    float g_app_time;
    vec4 foo;
    float cut_scale;
    float tex_scale;

    vec3 circle_plane_normal;
    vec3 circle_center;
    vec4 circle_args;
    vec4 circle_color;
    vec4 circle_args2;
};


bool is_above_cut_plane(vec3 pos, vec3 plane_center, vec3 plane_normal) {
    return dot(pos - plane_center, plane_normal) > 0;
}

bool is_below_visible_cut_plane(vec3 pos_c, vec3 plane_center_c, vec3 plane_normal_c) {
    return dot(plane_center_c, plane_normal_c) < 0 && is_above_cut_plane(pos_c, plane_center_c, plane_normal_c);
}

void main() {
    if (is_above_cut_plane(v_camera_pos, v_cut_plane_center_1_c, v_cut_plane_normal_1_c) ||
        is_above_cut_plane(v_camera_pos, v_cut_plane_center_2_c, v_cut_plane_normal_2_c)) {
        discard;
    }
}
