layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec2 v_uv;
layout (location = 1) out vec3 v_normal;
layout (location = 2) out vec3 v_model_pos;
layout (location = 3) out vec3 v_tangent;
layout (location = 4) out vec3 v_light_dir;
layout (location = 5) out vec3 v_world_normal;
layout (location = 6) out vec3 v_world_pos;
layout (location = 7) out vec3 v_world_eye;
layout (location = 8) out vec3 v_world_tangent;
layout (location = 9) out vec3 v_camera_pos;


layout (location = 10) out vec3 v_cut_plane_center_1_c;
layout (location = 11) out vec3 v_cut_plane_normal_1_cn;
layout (location = 12) out vec3 v_cut_plane_center_2_c;
layout (location = 13) out vec3 v_cut_plane_normal_2_cn;


layout (set = 0, binding = 0) uniform Context {
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    mat4 g_camera_from_world;
    mat4 g_world_from_model;
    float g_app_time;
    float extrude;
    vec3 g_light_dir;
    float g_instance_count;

    vec3 instance_move;

    vec3 cut_center_w;
    vec3 cut_normal_w;
    float cut_region_thickness;
    float cut_instance_dist;

    vec4 inst_rot;
    vec4 inst_rot_time;
};

void main() {
    float id = gl_InstanceIndex - (g_instance_count - 1) * 0.5;

    vec3 move = instance_move * id;
    vec3 rot = vec3(inst_rot.xyz * id + inst_rot_time.xyz * g_app_time);
//    rot *= 0.0;
    mat4 tr_mat = translate(move*3);
    mat4 rot_mat = rotate(rot);

    vec3 pos = a_position;
    vec4 new_pos = tr_mat * rot_mat * vec4(pos, 1.0);
    vec3 new_normal = mat3(tr_mat) * mat3(rot_mat) * a_normal;
    vec3 new_tangent = mat3(tr_mat) * mat3(rot_mat) * a_tangent;

    // vec4 new_pos = vec4(pos, 1.0);

    gl_Position = g_projection_from_model * new_pos;
    v_uv = a_uv;

    v_normal = mat3(g_camera_from_model) * new_normal;
    v_tangent = mat3(g_camera_from_model) * new_tangent;
    // v_tangent = a_tangent;
    v_model_pos = new_pos.xyz;

    v_light_dir = mat3(g_camera_from_world) * g_light_dir;

    mat3 inverse_camera_from_model = mat3(g_camera_from_world);
    v_world_eye = inverse_camera_from_model * -g_camera_from_world[3].xyz;
    v_world_pos = (g_world_from_model * new_pos).xyz;
    v_world_normal = mat3(g_world_from_model) * new_normal;
    v_world_tangent = mat3(g_world_from_model) * new_tangent;
    v_camera_pos = (g_camera_from_model * new_pos).xyz;

    vec3 cut_normal_wn =  normalize(cut_normal_w);
    vec3 cut_instance_center_w = cut_center_w + cut_normal_wn * cut_instance_dist * id;

    vec3 cut_normal_cn = mat3(g_camera_from_world) * cut_normal_wn;
    vec3 v_cut_plane_center_1_w = cut_instance_center_w + cut_normal_wn * cut_region_thickness * 0.5;
    vec3 v_cut_plane_center_2_w = cut_instance_center_w - cut_normal_wn * cut_region_thickness * 0.5;
    v_cut_plane_center_1_c = (g_camera_from_world * vec4(v_cut_plane_center_1_w, 1.0)).xyz;
    v_cut_plane_center_2_c = (g_camera_from_world * vec4(v_cut_plane_center_2_w, 1.0)).xyz;
    v_cut_plane_normal_1_cn = cut_normal_cn;
    v_cut_plane_normal_2_cn = -cut_normal_cn;
}