layout (location = 0) in vec2 v_uv;
layout (location = 0) out vec4 f_color;

layout (set = 1, binding = 1) uniform sampler2D original;

layout (set = 1, binding = 0) uniform Uniforms {
    vec2 g_pixel_size;
    float do_clamp;
};

//const float gauss_extrude = 1.0;
//const int gauss_kernel_size = 20;
//float gauss_weight[gauss_kernel_size * 2 + 1] = float[]
//(0.0003,	0.0004,	0.0007,	0.0012,	0.0019,	0.0029,	0.0044,	0.0064,	0.0090,	0.0124,	0.0166,	0.0216,	0.0274,	0.0337,	0.0404,	0.0470,	0.0532,	0.0587,	0.0629,	0.0655,	0.0665,	0.0655,	0.0629,	0.0587,	0.0532,	0.0470,	0.0404,	0.0337,	0.0274,	0.0216,	0.0166,	0.0124,	0.0090,	0.0064,	0.0044,	0.0029,	0.0019,	0.0012,	0.0007,	0.0004,	0.0003);


void main() {
    float uvstep = g_pixel_size.x * gauss_extrude;
    vec3 result = vec3(0.0, 0.0, 0.0);
    vec2 d = v_uv - vec2(uvstep * gauss_kernel_size, 0.0);
    for (int i = 0; i < gauss_kernel_size * 2 + 1; ++i)
    {
        result += clamp(texture(original, d).rgb - 1, 0, 10) * gauss_weight[i];
        d.x += uvstep;
    }
    f_color = vec4(result, 1.0);
}
