import moonlander.library.*;
import ddf.minim.*;

Moonlander moonlander;

PShader shade1;
PShader shade2;
PShader shade3;
PFont font;
PFont subFont;

PImage img;
    
void setup() {
  frameRate(60);
  size(960, 540, P3D);
  font = createFont("Courier", 32, false);
  subFont = createFont("Courier", 32, false);

  img = loadImage("data/bg1.png");      
  shade1 = loadShader("data/neon.glsl");
  shade3 = loadShader("data/lightfrag.glsl", "data/lightvert.glsl");
  shade3.set("fraction", 1.0);
  
  moonlander = Moonlander.initWithSoundtrack(this, "data/music.wav", 140, 4);
  moonlander.start("localhost", 1338, "data/syncdata.rocket");
}

void draw() {
  if (millis() * 0.001 > 40) {
    exit();
  }
  
  
  moonlander.update();
  background(0);
  setShaderParameters();
  shader(shade1);
  
  image(img, 0, 0);
  
  float rot = millis() * 0.001;
  float rot2 = (float) moonlander.getValue("value3");

  shader(shade3);

  directionalLight(204, 204, 204, -0.2, -0, -4);
  
  float y = (float) moonlander.getValue("value2");
  
  
  pushMatrix();
  
  translate(width/2, height/2 - y, 100);
  rotateY(rot);
  rotateX(rot2);
  stroke(#ff0000, 0);
  box(100);
  fill(#aa00ff);
  
  popMatrix();
  
  resetShader();
  textFont(font, 32);
  
  textBold("Be quick, Be Saturday away...", 50, 200, #aa22aa, #ffeeff);
}

void textBold(String msg, float x, float y, color bg, color fg) {
  fill(bg);
  for (int o = -2; o < 4; o++) {
    text(msg, x+o, y);
    text(msg, x, y+o);
  }
  fill(fg);
  text(msg, x, y);
}

void setShaderParameters() {
  float value1 = (float) moonlander.getValue("value1");
  shade1.set("time", (float) millis()/1000.0);
  shade1.set("brt", map(value1, 0, 100, 0, 0.5));
  shade1.set("rad", (int) map(450, 0, height, 0, 3));
  shade1.set("texOffset", 1.0, 1.0);
}
