#version 410 core

uniform float fGlobalTime; // in seconds
uniform vec2 v2Resolution; // viewport resolution (in pixels)
uniform float fFrameTime; // duration of the last frame, in seconds

uniform sampler1D texFFT; // towards 0.0 is bass / lower freq, towards 1.0 is higher / treble freq
uniform sampler1D texFFTSmoothed; // this one has longer falloff and less harsh transients
uniform sampler1D texFFTIntegrated; // this is continually increasing
uniform sampler2D texPreviousFrame; // screenshot of the previous frame
uniform sampler2D texChecker;
uniform sampler2D texNoise;
uniform sampler2D texTex1;
uniform sampler2D texTex2;
uniform sampler2D texTex3;
uniform sampler2D texTex4;

layout(location = 0) out vec4 out_color; // out_color must be written in order to see anything

vec4 plas( vec2 v, float time )
{
	float c = 0.5 + sin( v.x * 10.0 ) + cos( sin( time + v.y ) * 20.0 );
	return vec4( sin(c * 0.2 + cos(time)), c * 0.15, cos( c * 0.1 + time / .4 ) * .25, 1.0 );
}
void main(void)
{
	vec2 uv = vec2(gl_FragCoord.x / v2Resolution.x, gl_FragCoord.y / v2Resolution.y);
	uv -= vec2(0.5+sin(fGlobalTime*1.2)*.2,0.5+sin(fGlobalTime*1.5)*.2);
	uv /= vec2(v2Resolution.y / v2Resolution.x, 1);

  float f=sin(fGlobalTime);
  float d=pow(length(uv), 5+sin(fGlobalTime*.1)*4.5);
  float a=atan(uv.x,uv.y);
  float r=sin(d*20+a-fGlobalTime*3);
  float g=sin(d*12+a+fGlobalTime*7);
  float b=sin(d*15+a-fGlobalTime*8);
  r=(g+b)/d;
  g=(b+r)/(d+sin(fGlobalTime));
  b=(r+g)/f;
  out_color=vec4(r,g,b,0);
}