-- 'e': ELLI xc,yc w,h c
-- 'r': RECT xc,yc w,h c
-- 't': TRI xc,yc x1,y1 x2,y2 x3,y3 c

-- t:type
-- c:
--	m:mouth (0-1)
function getPrimsActor(t,c)
	if t=='katie' then
		return getPrimsKatie(c)
	elseif t=='mick' then
		return getPrimsMick(c)
	elseif t=='scientist' then
		return getPrimsScientist(c)
	elseif t=='ps' then
		return getPrimsPS(c)
	end
end

function getIrisPrim(xc,yc,w,h,a,d)
	return {'e', xc+cos(a)*d*w,yc+sin(a)*d*h, 2,2, 0}
end

-- Katie O'Tic (TV Presenter)
function getPrimsKatie(c)
	local headY=-7+c.m*2
	local bunY=headY-19
	local eyeY=headY-3
	local mouthY=headY+9+cos(c.m/19)*2
	return {
		{'t', 0,25, -20,-20, 20,-20, 0,50, 5},	-- dress
		{'e', 0,headY, 20,17, 4},			-- face
		{'e', -7,eyeY, 4,6, 12},	-- left eyeball
		getIrisPrim(-7,eyeY,3,4,c.ela,c.eld), -- left iris
		{'e', 7,eyeY, 4,6, 12},	-- right eyeball
		getIrisPrim(7,eyeY,3,4,c.era,c.erd), -- right iris
		{'e', sin(c.m/26)*2,mouthY, 1+c.m*3,1+c.m*3, 2}, -- mouth
		{'e', 8,bunY, 5,5, 0},	-- hair bun
	}
end

-- Mick McAtee (Also a TV Presenter)
function getPrimsMick(c)
	local headY=-15+c.m*2
	local hairY=headY-28+c.m*2
	local eyeY=headY-5
	local mouthY=0
	return {
		{'r', 0,37, 38,60, 8},		-- jacket
		{'r', 0,headY, 30,50, 4},	-- face
		{'e', -7,eyeY, 6,3, 12},	-- left eyeball
		getIrisPrim(-7,eyeY,4,1,c.ela,c.eld), -- left iris
		{'e', 7,eyeY, 6,3, 12},	-- right eyeball
		getIrisPrim(7,eyeY,4,1,c.era,c.erd), -- right iris
		{'t', 0,hairY, -20,0, -5,0, -20,10, 0},		-- left hair
		{'t', 0,hairY, -5,0, 20,0, 20,10, 0},		-- right hair
		{'r',0,mouthY,30,1+c.m*4,1},		-- mouth
	}
end

-- A Scienticst (Resident Hexpert)
-- m=0-1
function getPrimsScientist(c)
	local headY=-15+c.m*2
	local eyeY=headY-1
	local mouthY=headY+15
	local fluffY=headY-11
	local prims={
		{'e',0,40,30,60,12},	-- labcoat
		{'e',0,headY,18,25,4},	-- head
		{'e',-8,eyeY,5,5,12},	-- left eyeball
		getIrisPrim(-8,eyeY,3,3,c.ela,c.eld), -- left iris
		{'e',8,eyeY,5,5,12},	-- right eyeball
		getIrisPrim(8,eyeY,3,3,c.era,c.erd), -- right iris
		{'e',-16,fluffY,2,6,12},	-- left fluff
		{'e',16,fluffY,2,6,12},	-- right fluff
		{'e',0,mouthY,1+6*c.m,1+3*c.m,0},		-- mouth
	}
	return prims
end

function getPrimsPS(c)
	local headY=-c.m*1.5
	return {
		{'r',0,headY+45, 35,50, 0},	-- shirt
		{'e',0,headY-5, 15,25, 0},	-- hair
		{'r',0,headY+20, 28,30, 0},	-- hair
		{'e',0,headY, 14,20,4},		-- face
		{'r',-14,headY-2, 5,10, 4},	-- left ear
		{'r',14,headY-2, 5,10, 4},	-- right ear
		{'r',0,headY-8, 32,2, 0},	-- glasses top
		{'r',-7,headY-5, 10,9, 0}, -- glasses rim left
		{'r',7,headY-5, 10,9, 0}, -- glasses rim right
		{'r',-7,headY-4, 7,5, 4}, -- glasses hole left
		{'r',7,headY-4, 7,5, 4}, -- glasses hole right
		{'e',-7,headY-4, 3,2, 12}, -- eyeball left
		{'e',7,headY-4, 3,2, 12}, -- eyeball right
		{'e',-7,headY-4, 1,1, 0}, -- iris left
		{'e',7,headY-4, 1,1, 0}, -- iris right
		{'e',-2,headY+6, 1,1, 3}, -- nostril left
		{'e',2,headY+6, 1,1, 3}, -- nostril right
		{'r',0,12, 10,2+c.m, 1}, -- mouth
		{'t',-6,headY-18, 0,0, 10,-8, 18,8, 4},  -- fringe
		{'t',0,headY+20, -10,0, 10,0, 0,10, 4},	-- neck
	}
end

function getPrimsTree()
	return {
		{'t',0,0, 0,-50,30,50,0,50, 5},
		{'t',0,0, 0,-50,-30,50,0,50, 6},
	}
end

function getPrimsTreeBaubles()
	return {
		{'e',-7,0, 3,3,2},
		{'e',-4,-20, 3,3,3},
		{'e',10,13, 3,3,4},
		{'e',6,-9, 3,3,7},
		{'e',14,37, 3,3,8},
		{'e',-11,27, 3,3,9},
		{'e',0,-50,2,1,4}, -- 'star'
	}
end

function getPrimsFireplace()
	return {
		{'r',0,30,30,30,15}, --hearth

		{'r',-20,25,10,40,13},--side
		{'r',20,25,10,40,13}, --side
		{'r',0,10,60,10,14}, --mantle

		{'t',0,10, 0,10,-10,34,10,34, 4}, --flame
		{'t',0,10, 0,20,-10,34,10,34, 3}, --flame

	}
end

function getPrimsCandleBridge() 
	return {
		{'r',0,-5,2,10,4}, --candle 1
		{'r',10,0,2,10,4}, --candle 2
		{'r',-10,0,2,10,4}, --candle 2
		{'r',20,2,2,8,4}, --candle 3
		{'r',-20,2,2,8,4}, --candle 3
		{'t',0,-29, 0,25,-20,34,20,34, 14}, --candle bridge
	}
end

function getPrimsLeftStocking()
	return {
		--lstocking
		{'r',-18,13,15,5,12}, --stocking trim
		{'r',-18,22,10,15,2}, --stocking calf?
		{'e',-14,28,8,5,2}, --stocking toe?
	}
end

function getPrimsRightStocking()
	return {
		--rstocking
		{'r',18,13,15,5,12}, --stocking trim
		{'r',18,22,10,15,2}, --stocking calf?
		{'e',14,28,8,5,2}, --stocking toe?
	}
end

-- s is scale (default: 1)
function drawPrims(prims,pScrO)
	for i=1,#prims do
		local p=prims[i]
		if p[1] == 'e' then
			local x=p[2]
			local y=p[3]
			local w=p[4]
			local h=p[5]
			local c=p[6]
			dElliF(dPAddS(pScrO,x,y),dPMakeS(w,h),c)
		elseif p[1] == 'r' then
			local pC=dPAddS(pScrO,p[2],p[3])
			local w=p[4]
			local h=p[5]
			local c=p[6]
			dRectF(dPAddS(pC,-w/2,-h/2),dPMakeS(w,h),c)
		elseif p[1] == 't' then
			local pC=dPAddS(pScrO,p[2],p[3])
			local c=p[10]
			dTriF(dPAddS(pC,p[4],p[5]),dPAddS(pC,p[6],p[7]),dPAddS(pC,p[8],p[9]),c)
		end
	end
end
