StageIdent = {}
StageIdent.__index = StageIdent

function StageIdent:new()
    local o = {}
    setmetatable(o, StageIdent)
    o.time = 0
    o.zoomTime = 200
    o.maxTime = 310
    o.mlTitleText=MLText:new("FANTASY\nCONSOLE\nNEWS", MINSCRW*.7, 3)
    return o
end

function StageIdent:update()
    if self.time == 0 and not SKIP_STAGE_IDENT then
        dMusic()
    end

    self.time = self.time + 1
    return SKIP_STAGE_IDENT or self.time > self.maxTime
end

function StageIdent:draw()
    dCls(1)
    local nStripes=6
    local stripeH=SCRH/nStripes
    for i=0,6 do
        local c=i%2==0 and 4 or 11
        dRectF(dPMake(0,i*stripeH),dPMake(SCRW,stripeH),c)
    end

    local pTitleText=dPMake(SCRWH, SCRHH-self.mlTitleText:getH()/2)
    local m=min(self.time/self.zoomTime,1)
    local x,y,s=SCRWH,SCRHH,10+m*50
    dElliF(dPMake(x,y),dPMake(s,s),15)
    local c={2,5,8}
    for i=1,3 do
        local a=self.time/100+i/3
        local d=40+m*10
        local x,y,s=SCRWH+cos(a)*d,SCRHH+sin(a*.7)*d,4
        dElliF(dPMake(x,y),dPMake(s,s),c[i])
    end
    self.mlTitleText:print(dPAdd(pTitleText,1,1),0, 0)
    self.mlTitleText:print(pTitleText,12,0)
end
