//glsl version 4.5
#version 450

layout (location = 0) in vec3 inColor;
layout (location = 1) in vec2 inUv;
layout (location = 2) in vec3 inNormal;

layout(set = 0, binding = 1) uniform  SceneData{
	float time; // w is for exponent
	float flowTime;
	vec4 sunlightDirection; //w for sun power
} sceneData;


//push constants block
layout( push_constant ) uniform constants
{
	vec4 data;
	mat4 render_matrix;
	float colorMul;
	float flowTime;	
} PushConstants;

layout(set = 1, binding = 0) uniform sampler2D tex1;
layout(set = 1, binding = 1) uniform sampler2D tex2;


//output write
layout (location = 0) out vec4 outFragColor;

void main()
{

	vec2 uv = inUv;

	vec3 tex2Col = texture(tex2,uv).xyz;
	float t = PushConstants.flowTime*0.05;
	vec2 uv1 = tex2Col.xy*fract(t);
	vec2 uv2 = tex2Col.xy*fract(t+0.5);

	vec3 col1 = texture(tex1,uv+uv1).xyz;
	vec3 col2 = texture(tex1,uv+uv2).xyz;


	float alternate = abs((fract(t)-0.5f) * 2.0f);

	vec3 color = mix(col1, col2, alternate)*dot(vec3(0.7f, 0.8f, 1.0f), inNormal);

//	vec3 color = texture(tex2,uv).xyz;
	outFragColor = vec4(color, 1.0f)*PushConstants.colorMul;
}