//glsl version 4.5
#version 450

layout (location = 0) in vec3 inColor;
layout (location = 1) in vec2 inUv;
layout (location = 2) in vec3 inNormal;

layout(set = 0, binding = 1) uniform  SceneData{
    float time; // w is for exponent
	vec4 fogDistances; //x for min, y for max, zw unused.
	vec4 ambientColor;
	vec4 sunlightDirection; //w for sun power
	vec4 sunlightColor;
} sceneData;

layout(set = 1, binding = 0) uniform sampler2D tex1;
layout(set = 1, binding = 1) uniform sampler2D tex2;


//output write
layout (location = 0) out vec4 outFragColor;

void main()
{
	float time = sceneData.time;
	vec2 uv = inUv;

	vec3 color = texture(tex1,uv).xyz;
	float frameU = floor(fract(time*24)*16.0f)/16.0f;
//	vec2 frameUV = vec2(*frameU/16+frameU*, uv.y);
	vec2 frameUV = vec2(uv.x/16+frameU, uv.y);
	color = color*texture(tex2,frameUV).xyz;


	outFragColor = vec4(color, 1.0f);
}