/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;

public class VertexBuffer {
    protected static final int INIT_VERTEX_BUFFER_SIZE = 256;
    protected static final int INIT_INDEX_BUFFER_SIZE = 512;
    public int glId;
    int target;
    int elementSize;
    int ncoords;
    boolean index;
    protected PGL pgl;
    protected int context;
    private PGraphicsOpenGL.GLResourceVertexBuffer glres;

    VertexBuffer(PGraphicsOpenGL pg, int target, int ncoords, int esize, int usage) {
        this(pg, target, ncoords, esize, usage, false);
    }

    VertexBuffer(PGraphicsOpenGL pg, int target, int ncoords, int esize, int usage, boolean index) {
        this.pgl = pg.pgl;
        this.context = this.pgl.createEmptyContext();
        this.target = target;
        this.ncoords = ncoords;
        this.elementSize = esize;
        this.index = index;
        this.create();
        this.init(usage);
    }

    protected void create() {
        this.context = this.pgl.getCurrentContext();
        this.glres = new PGraphicsOpenGL.GLResourceVertexBuffer(this);
    }

    protected void init(int usage) {
        int size = this.index ? this.ncoords * 512 * this.elementSize : this.ncoords * 256 * this.elementSize;
        this.pgl.bindBuffer(this.target, this.glId);
        this.pgl.bufferData(this.target, size, null, usage);
    }

    protected void dispose() {
        if (this.glres != null) {
            this.glres.dispose();
            this.glId = 0;
            this.glres = null;
        }
    }

    protected boolean contextIsOutdated() {
        boolean outdated;
        boolean bl = outdated = !this.pgl.contextIsCurrent(this.context);
        if (outdated) {
            this.dispose();
        }
        return outdated;
    }
}

