/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioSignal;
import ddf.minim.AudioSource;
import ddf.minim.NoteManager;
import ddf.minim.Polyphonic;
import ddf.minim.SignalChain;
import ddf.minim.spi.AudioOut;
import ddf.minim.ugens.DefaultInstrument;
import ddf.minim.ugens.Frequency;
import ddf.minim.ugens.Instrument;
import ddf.minim.ugens.Summer;

public class AudioOutput
extends AudioSource
implements Polyphonic {
    private AudioOut synth;
    private SignalChain signals;
    private NoteManager noteManager;
    Summer bus;

    public AudioOutput(AudioOut out) {
        super(out);
        this.synth = out;
        this.signals = new SignalChain();
        this.noteManager = new NoteManager(this.getFormat().getSampleRate());
        this.bus = new Summer();
        this.bus.setSampleRate(this.getFormat().getSampleRate());
        this.bus.setChannelCount(this.getFormat().getChannels());
        this.synth.setAudioSignal(new SampleGenerator());
    }

    @Override
    public void addSignal(AudioSignal signal) {
        this.signals.add(signal);
    }

    @Override
    public AudioSignal getSignal(int i) {
        return this.signals.get(i);
    }

    @Override
    public void removeSignal(AudioSignal signal) {
        this.signals.remove(signal);
    }

    @Override
    public AudioSignal removeSignal(int i) {
        return this.signals.remove(i);
    }

    @Override
    public void clearSignals() {
        this.signals.clear();
    }

    @Override
    public void disableSignal(int i) {
        this.signals.disable(i);
    }

    @Override
    public void disableSignal(AudioSignal signal) {
        this.signals.disable(signal);
    }

    @Override
    public void enableSignal(int i) {
        this.signals.enable(i);
    }

    @Override
    public void enableSignal(AudioSignal signal) {
        this.signals.enable(signal);
    }

    @Override
    public boolean isEnabled(AudioSignal signal) {
        return this.signals.isEnabled(signal);
    }

    @Override
    public boolean isSounding() {
        for (int i = 1; i < this.signals.size(); ++i) {
            if (!this.signals.isEnabled(this.signals.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void noSound() {
        for (int i = 1; i < this.signals.size(); ++i) {
            this.signals.disable(i);
        }
    }

    @Override
    public int signalCount() {
        return this.signals.size();
    }

    @Override
    public void sound() {
        for (int i = 1; i < this.signals.size(); ++i) {
            this.signals.enable(i);
        }
    }

    @Override
    public boolean hasSignal(AudioSignal signal) {
        return this.signals.contains(signal);
    }

    public void playNote(float startTime, float duration, Instrument instrument) {
        this.noteManager.addEvent(startTime, duration, instrument);
    }

    public void playNote(float startTime, float duration, float hz) {
        this.noteManager.addEvent(startTime, duration, new DefaultInstrument(hz, this));
    }

    public void playNote(float startTime, float duration, String pitchName) {
        this.noteManager.addEvent(startTime, duration, new DefaultInstrument(Frequency.ofPitch(pitchName).asHz(), this));
    }

    public void playNote(float startTime, float hz) {
        this.noteManager.addEvent(startTime, 1.0f, new DefaultInstrument(hz, this));
    }

    public void playNote(float startTime, String pitchName) {
        this.noteManager.addEvent(startTime, 1.0f, new DefaultInstrument(Frequency.ofPitch(pitchName).asHz(), this));
    }

    public void playNote(float hz) {
        this.noteManager.addEvent(0.0f, 1.0f, new DefaultInstrument(hz, this));
    }

    public void playNote(String pitchName) {
        this.noteManager.addEvent(0.0f, 1.0f, new DefaultInstrument(Frequency.ofPitch(pitchName).asHz(), this));
    }

    public void playNote() {
        this.noteManager.addEvent(0.0f, 1.0f, new DefaultInstrument(Frequency.ofPitch("").asHz(), this));
    }

    public void setTempo(float tempo) {
        this.noteManager.setTempo(tempo);
    }

    public float getTempo() {
        return this.noteManager.getTempo();
    }

    public void setNoteOffset(float noteOffset) {
        this.noteManager.setNoteOffset(noteOffset);
    }

    public float getNoteOffset() {
        return this.noteManager.getNoteOffset();
    }

    public void setDurationFactor(float durationFactor) {
        this.noteManager.setDurationFactor(durationFactor);
    }

    public float getDurationFactor() {
        return this.noteManager.getDurationFactor();
    }

    public void pauseNotes() {
        this.noteManager.pause();
    }

    public void resumeNotes() {
        this.noteManager.resume();
    }

    private class SampleGenerator
    implements AudioSignal {
        private SampleGenerator() {
        }

        @Override
        public void generate(float[] signal) {
            if (AudioOutput.this.signals.size() > 0) {
                AudioOutput.this.signals.generate(signal);
            }
            float[] tick = new float[1];
            int i = 0;
            while (i < signal.length) {
                AudioOutput.this.noteManager.tick();
                AudioOutput.this.bus.tick(tick);
                int n = i++;
                signal[n] = signal[n] + tick[0];
            }
        }

        @Override
        public void generate(float[] left, float[] right) {
            if (AudioOutput.this.signals.size() > 0) {
                AudioOutput.this.signals.generate(left, right);
            }
            float[] tick = new float[2];
            int i = 0;
            while (i < left.length) {
                AudioOutput.this.noteManager.tick();
                AudioOutput.this.bus.tick(tick);
                int n = i;
                left[n] = left[n] + tick[0];
                int n2 = i++;
                right[n2] = right[n2] + tick[1];
            }
        }
    }
}

