var Menu = function() {
    this.input = new Input();
    this.edited = false;

    this.mute = {"v":Settings.audio.mute};
    this.fullscreen = {"v":Settings.window.fullscreen};
    this.displayModeSelect = void null;

    this.displayModes = getDisplayModes();

    this.displayModeList = "";
    for (var i in this.displayModes) {
        var dm = this.displayModes[i];
        this.displayModeList += dm.width + "x" + dm.height + "\0";

        if (dm.width == Settings.demo.graphics.canvasWidth && dm.height == Settings.demo.graphics.canvasHeight) {
            this.displayModeSelect = {"v": i};
        }
    }

    if (this.displayModeSelect === void null) {
        this.displayModeSelect = {"v": 0};
    }

    this.displayModeList += "\0";

}
Menu.prototype.setQuit = function(quit) {
    menuSetQuit(quit);
}
Menu.prototype.getWidth = function() {
    return menuGetWidth();
}
Menu.prototype.getHeight = function() {
    return menuGetHeight();
}
Menu.prototype.stringListRandomPick = function(strList) {
    var max = Math.max(0, strList.split("\0").length - 2);
    return Math.floor(Math.random() * max);
}
Menu.prototype.getFileName = function(prefix, suffix, dropDown) {
    var dropDownList = dropDown.list;
    var selectIndex = dropDown.select.v;
    var shortName = dropDownList.split("\0")[selectIndex];

    return prefix + shortName + suffix;
}
Menu.prototype.processCustomSetup = function() {
    var custom = Settings.demo.custom;

    custom.background = this.getFileName("background/background_", ".png", custom.farjan.background);
    custom.foreground = this.getFileName("foreground/foreground_", ".png", custom.farjan.foreground);
    custom.sun = this.getFileName("sun/", ".png", custom.farjan.sun);
    custom.audio = this.getFileName("audio/farjan_", ".ogg", custom.farjan.audio);
    custom.ferry = this.getFileName("ferry/boat_", ".png", custom.farjan.ferry);
    custom.font = this.getFileName("font/", ".ttf", custom.farjan.font);

    Settings.demo.song = custom.audio;
    Settings.demo.length = parseInt(custom.farjan.length.v);

    settingsLoadSettingsFromString(JSON.stringify(Settings, null, 2));
    settingsDemoLoadDemoSettingsFromString(JSON.stringify(Settings.demo, null, 2));
    settingsDemoSaveDemoSettings();
}
Menu.prototype.render = function() {
    ImGui.SetNextWindowPos({"x":0, "y":0}, ImGui.SetCond.Always);
    ImGui.SetNextWindowSize({"x":this.getWidth(), "y":this.getHeight()}, ImGui.SetCond.Always);

    ImGui.PushStyleVar(ImGui.StyleVar.WindowRounding, 0);
    ImGui.Begin("", {"v":true},
      ImGui.WindowFlags.NoSavedSettings
      | ImGui.WindowFlags.NoTitleBar
      | ImGui.WindowFlags.NoResize
      | ImGui.WindowFlags.NoMove
      | ImGui.WindowFlags.NoCollapse);
    var flags = ImGui.WindowFlags.NoResize;

    var farjan = Settings.demo.custom.farjan;
    if (!farjan) {
        loggerInfo(JSON.stringify(Settings.demo,null,2));
        farjan = {
            "release":{"v":false},
            "advanced":{"v":false},
            "length":{"v":"60", "size":4},
            "scroller":{"v":"FINLANDSFÄRJAN", "size":4096},
            "font":{
                "color":{"v":'{"r":0,"g":0,"b":0,"a":200}',"size":512},
                "scale":{"v":'{"x":20,"y":20}',"size":512},
                "angle":{"v":"","size":512},
                "position":{"v":'{"x":"{return Settings.demo.custom.farjan.scroller.v.length*200+getScreenWidth();}","y":"{ return getScreenHeight()/2;}"},{"duration":60,"x":"{return -(Settings.demo.custom.farjan.scroller.v.length*200+getScreenWidth());}","y":"{ return getScreenHeight()/2-400;}"}',"size":512},
                "select":{"v":1},
                "list":
                      "arial_bold\0"
                    + "comic_sans_bold\0"
                    + "\0"
            },
            "background":{
                "scale":{"v":"","size":512},
                "position":{"v":"","size":512},
                "angle":{"v":"","size":512},
                "select":{"v":2},
                "list":
                      "none\0"
                    + "ground\0"
                    + "pixel\0"
                    + "waves\0"
                    + "sunset\0"
                    + "party\0"
                    + "sky\0"
                    + "seagul\0"
                    + "diagram\0"
                    + "hull\0"
                    + "ship\0"
                    + "\0"
            },
            "foreground":{
                "scale":{"v":"","size":512},
                "position":{"v":"","size":512},
                "angle":{"v":"","size":512},
                "select":{"v":1},
                "list":
                      "none\0"
                    + "waves\0"
                    + "land\0"
                    + "party\0"
                    + "\0"
            },
            "sun":{
                "shadow":{"v":true},
                "select":{"v":1},
                "list":
                      "sun\0"
                    + "sun_toon\0"
                    + "sun_pixel\0"
                    + "\0"
            },
            "audio":{
                "select":{"v":0},
                "list":
                      "2006_original\0"
                    + "2018_remake\0"
                    + "acapella_01\0"
                    + "bells_01\0"
                    + "metal_01\0"
                    + "metal_02\0"
                    + "piano_01\0"
                    + "piano_02\0"
                    + "synth_01\0"
                    + "synth_02\0"
                    + "synth_03\0"
                    + "synth_04\0"
                    + "synth_05\0"
                    + "\0"
            },
            "ferry":{
                "scale":{"v":"","size":512},
                "position":{"v":'{"x":-300,"y":600},{"duration":60, "x":2500,"y":600}',"size":512},
                "angle":{"v":'{"degreesZ":"{return Math.sin(getSceneTimeFromStart())*5-10;}"}',"size":512},
                "select":{"v":0},
                "list":
                      "gabriella\0"
                    + "mariella\0"
                    + "seppo\0"
                    + "nir\0"
                    + "pixel\0"
                    + "airplane\0"
                    + "toy\0"
                    + "ascii\0"
                    + "bus\0"
                    + "surreal\0"
                    + "\0"
            },
        };
        Settings.demo.custom.farjan = farjan;
    }

    ImGui.SetWindowFontScale(!farjan.release.v ? 1.0 : 3.0);

    ImGui.Combo("", this.displayModeSelect, this.displayModeList);

    ImGui.Checkbox("fullscreen", this.fullscreen);
    ImGui.SameLine();
    ImGui.Checkbox("mute", this.mute);


    if (!farjan.release.v) {
        this.edited = true;
        ImGui.Checkbox("release", farjan.release);
        ImGui.SameLine();
        ImGui.Checkbox("advanced", farjan.advanced);
        ImGui.SameLine();
        if (ImGui.Button("I'm feeling lucky")) {
            farjan.background.select.v = this.stringListRandomPick(farjan.background.list);
            farjan.foreground.select.v = this.stringListRandomPick(farjan.foreground.list);
            farjan.sun.select.v = this.stringListRandomPick(farjan.sun.list);
            farjan.audio.select.v = this.stringListRandomPick(farjan.audio.list);
            farjan.ferry.select.v = this.stringListRandomPick(farjan.ferry.list);
            farjan.sun.shadow.v = true;
            farjan.length.v = 60 + (Math.floor(Math.random()*7)*10);
        }
        ImGui.SameLine();
        ImGui.PushItemWidth(100);
        ImGui.InputText("length", farjan.length);
        ImGui.PopItemWidth();

        ImGui.Combo("audio", farjan.audio.select, farjan.audio.list);

        ImGui.Separator();
        ImGui.InputText("scroller", farjan.scroller);
        if (!!farjan.advanced.v) {
            ImGui.PushItemWidth(200);
            ImGui.Combo("font", farjan.font.select, farjan.font.list);
            ImGui.SameLine();
            ImGui.InputText("color##font", farjan.font.color);

            ImGui.InputText("scale##font", farjan.font.scale);
            ImGui.SameLine();
            ImGui.InputText("angle##font", farjan.font.angle);
            ImGui.SameLine();
            ImGui.InputText("position##font", farjan.font.position);
            ImGui.PopItemWidth();
        }


        ImGui.Separator();
        ImGui.Combo("background", farjan.background.select, farjan.background.list);
        if (!!farjan.advanced.v) {
            ImGui.PushItemWidth(200);
            ImGui.InputText("scale##background", farjan.background.scale);
            ImGui.SameLine();
            ImGui.InputText("angle##background", farjan.background.angle);
            ImGui.SameLine();
            ImGui.InputText("position##background", farjan.background.position);
            ImGui.PopItemWidth();
        }

        ImGui.Separator();
        ImGui.Combo("foreground", farjan.foreground.select, farjan.foreground.list);
        if (!!farjan.advanced.v) {
            ImGui.PushItemWidth(200);
            ImGui.InputText("scale##foreground", farjan.foreground.scale);
            ImGui.SameLine();
            ImGui.InputText("angle##foreground", farjan.foreground.angle);
            ImGui.SameLine();
            ImGui.InputText("position##foreground", farjan.foreground.position);
            ImGui.PopItemWidth();
        }

        ImGui.Separator();
        ImGui.Combo("ferry", farjan.ferry.select, farjan.ferry.list);
        if (!!farjan.advanced.v) {
            ImGui.PushItemWidth(200);
            ImGui.InputText("scale##ferry", farjan.ferry.scale);
            ImGui.SameLine();
            ImGui.InputText("angle##ferry", farjan.ferry.angle);
            ImGui.SameLine();
            ImGui.InputText("position##ferry", farjan.ferry.position);
            ImGui.PopItemWidth();
        }

        ImGui.Separator();
        ImGui.Combo("sun", farjan.sun.select, farjan.sun.list);
        if (!!farjan.advanced.v) {
            ImGui.SameLine();
            ImGui.Checkbox("shadow", farjan.sun.shadow);
        }


/*
length
scroller

background dropdown
foreground dropdown

sun dropdown
sun shadow

vehicle
vehicle rotation
vehicle shit
*/

    }

    if ((ImGui.Button("Start") || ImGui.IsKeyPressed(ImGui.GetKeyIndex(ImGui.Key.Enter), true))) {
        var displayMode = this.displayModes[this.displayModeSelect.v];

        Settings.audio.mute = this.mute.v;
        Settings.window.fullscreen = this.fullscreen.v;

        // Send Settings modified in JS to backend
        settingsLoadSettingsFromString(JSON.stringify(Settings, null, 2));
        settingsDemoLoadDemoSettingsFromString(JSON.stringify(Settings.demo, null, 2));

        settingsWindowSetWindowDimensions(displayMode.width, displayMode.height);

        this.setQuit(false); // i.e. let's continue and show the demo
        this.input.setUserExit(true);

        if (this.edited) {
            this.processCustomSetup();
        }
    }
    ImGui.SameLine();
    if (ImGui.Button("Exit")) {
        if (this.edited) {
            this.processCustomSetup();
        }
        this.input.setUserExit(true);
    }

    ImGui.End();
    ImGui.PopStyleVar();

    ImGui.Render();
}
