#version 330 core

#define float2 vec2
#define float3 vec3
#define float4 vec4

in float2 texCoord;
in float4 vertexFragColor;
out float4 fragColor;
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform float4 color = float4(0,0,0,1);
uniform float time = 1.0;


	  
void main()
{


	
vec4 outColor = vec4(0);

	float2 fftuv=texCoord;
	float x = texCoord.x;
	float y = texCoord.y*5.25+time;




	vec4 fftColor = texture(texture1,vec2(y,x));

	vec4 dv = texture(texture1, vec2(y,x));

	float distAmount=sin(sin(1.15*fftColor.r*fftColor.r*fftColor.r))*2.5;
	
	float2 uv=texCoord;

	uv.x=uv.x*(1.0-distAmount);
	vec4 distColor = texture(texture0, uv);
	
	float2 uv2=texCoord;
	uv2.x=uv2.x*(1.0+distAmount);
	vec4 distColor2 = texture(texture0, uv2);

	vec4 color = texture(texture0, texCoord);
	
    fragColor = color*.66+.25*distColor+.25*distColor2;

}
