
var colorScheme = [
    [0x67,0x84,0x41], // green
    [0xe4,0x1f,0x25], // red
    [0xc6,0x26,0x26], // darker red
    [0xff,0xd0,0x2b], // yellow
    [0xdb,0x84,0x3a], // brown
    [0xd5,0xe2,0xdf], // whiteish
];


var start      = 0;
var end        = 143;
var duration   = end;
var layer      = 0;

Demo.prototype.sceneIntro = function(start, duration)
{
    this.loader.addAnimation({
        "start": start, "duration": duration
       ,"layer": layer
       ,"image": "intro_jumalauta.png"
       ,"scale": [{"uniform2d":1.0}]
       ,"color":[{"a":0},{"duration":5,"a":255},{"duration":1},{"duration":5,"a":0}]
   });
   this.loader.addAnimation({
        "start": start+5, "duration": duration
        ,"layer": layer
        ,"image": "intro_title.png"
        ,"scale": [{"uniform2d":1.0}]
        ,"color":[{"a":0},{"duration":1},{"duration":5,"a":255},{"duration":1},{"duration":2,"a":0}]
    });
}

Demo.prototype.sceneSledge = function(start, duration)
{
    this.loader.addAnimation([
    { 
        "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"sceneSledgeFbo","action":"begin","storeDepth":false}
    }]);
    
    this.loader.addAnimation({
        "start": start, "duration": duration
       ,"layer": layer
       ,"image": "stars.png"
       ,"scale": [{"uniform2d":1.0}]
       ,"color":[{"a":0},{"duration":1,"a":255},{"duration":duration-1},{"duration":1,"a":0}]
   });
   this.loader.addAnimation({
        "start": start, "duration": duration
        ,"layer": layer
        ,"image": "planet_earth_moon.png"
        ,"scale": [{"uniform2d":0.4}]
        ,"position": [{"x":getScreenWidth()*0.75,"y":getScreenHeight()*0.75}]
        ,"color":[{"a":0},{"duration":1,"a":255},{"duration":duration-1},{"duration":1,"a":0}]
    });
    var sledgeDuration = duration-7;
    this.loader.addAnimation({
        "start": start+7, "duration": sledgeDuration
       ,"layer": layer
       ,"image": "sledge.png"
       ,"scale": [{"uniform2d":1.0}]
       ,"position": [{"x":getScreenWidth()*0.5,"y":-1500},{"duration":sledgeDuration,"x":getScreenWidth()*0.6}]
       ,"angle": [{"degreesZ":-30},{"duration":sledgeDuration,"degreesZ":20}]
       ,"color":[{"a":0},{"duration":1,"a":255},{"duration":sledgeDuration-1},{"duration":1,"a":0}]
   });
    this.loader.addAnimation({
        "start": start, "duration": duration
       ,"layer": layer
       ,"image": "cabin.png"
       ,"scale": [{"uniform2d":1.0}]
       ,"position": [{"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.45}]
       ,"color":[{"a":0},{"duration":1,"a":255},{"duration":duration-1},{"duration":1,"a":0}]
   });
   this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"sceneSledgeFbo","action":"unbind"}
    });
}

// ffmpeg -i batman-party-hard.gif -vsync 0 batman-party-hard-%d.png
function loadPngAnimation(animationObject) {
    animationObject.images = [];
    animationObject.i = void null;
    if (!animationObject.fps) {
        animationObject.fps = 30;
    }

    animationObject.frameDelay = 1.0 / animationObject.fps;

    for (var i = 1; i <= animationObject.frames; i++) {
        var image = new Image();
        image.load(animationObject.prefix + i + ".png");
        animationObject.images.push(image);
    }
}

function playPngAnimation(animation) {
    var timeNow = getSceneTimeFromStart();
    if (animation.animationObject.i === void null) {
        animation.animationObject.i = 0;
        animation.animationObject.startTime = timeNow;
        animation.animationObject.frameStartTime = animation.animationObject.startTime;
    }

    if (Math.abs(timeNow-animation.animationObject.frameStartTime) >= animation.animationObject.frameDelay) {
        animation.animationObject.i = (animation.animationObject.i+1)%animation.animationObject.frames;
        animation.animationObject.frameStartTime = timeNow;
    }

    animation.multiTexRef[0].ptr = animation.animationObject.images[animation.animationObject.i].ptr;
}

var animWrestling1 = {
    prefix: 'anim/wrestling1/wrestling1_',
    frames: 26,
    fps: 26
};

var animWrestling2 = {
    prefix: 'anim/wrestling2/wrestling2_',
    frames: 50,
    fps: 25
};

var animSoiniThumbs = {
    prefix: 'anim/soini-thumbs/soini-thumbs-',
    frames: 114,
    fps: 15
};

Demo.prototype.snowFall = function(start, duration, list)
{
    var iterFlake = 0;
    for (var i = 0; i < 100; i++) {
        var xSway = 1+Math.random();
        var xPos = Math.random();
        var xScript = "{return Math.sin(getSceneTimeFromStart()*"+xSway+")*50+getScreenWidth()*"+xPos+";}";
        var imageName = "snowflakes/slice"+Math.floor(Math.random()*9+1)+".png";
        var angle = 360;
        if (i%10 == 9 && list) {
            imageName = "snowflakes/flake_" + list[iterFlake] + ".png";
            iterFlake = (iterFlake+1)%list.length
            angle = 0;
        }
        this.loader.addAnimation({
            "start": start + (Math.random()*duration-1), "duration": duration
            ,"layer": layer
            ,"image": imageName
            ,"scale": [{"uniform2d":0.15}]
            ,"position": [{"x":xScript,"y":getScreenHeight()*(1.1+(Math.random()+0.2))},{"duration":duration,"x":xScript,"y":getScreenHeight()*-(0.1+Math.random()*0.2)}]
            ,"angle":[{"degreesZ":Math.random()*angle}]
            //,"color":[{"a":0},{"duration":1,"a":255},{"duration":duration-1},{"duration":1,"a":0}]
        });
    }
}

Demo.prototype.sceneOrpo = function(start, duration)
{
    this.loader.addAnimation([
        { 
            "start": start, "duration": duration
            ,"layer": layer
            ,"fbo":{"name":"sceneOrpoFbo","action":"begin","storeDepth":false}
        }]);
    
    this.loader.addAnimation({
        "start": start, "duration": duration
       ,"layer": layer
       ,"image": "stars.png"
       ,"scale": [{"uniform2d":1.0}]
       //,"color":[{"a":0},{"duration":1,"a":255},{"duration":duration-1},{"duration":1,"a":0}]
   });

   this.snowFall(start-10, duration+10, ["kokoomus"]);

   var delayBeforeMove=6;
   var moveDuration=3;
   var animShow=5;
   var moveBackDuration=3;

   this.loader.addAnimation({
    "start": start, "duration": duration
    ,"layer": layer
    ,"image": "orpo.png"
    ,"position":[
        {"x":getScreenWidth()*0.15,"y":getScreenHeight()*0.3},
        {"duration":delayBeforeMove},
        {"duration":moveDuration,"x":getScreenWidth()*-0.15,"y":getScreenHeight()*-0.45},
        {"duration":animShow},
        {"duration":moveBackDuration,"x":getScreenWidth()*0.15,"y":getScreenHeight()*0.3},
    ]
    ,"scale": [{"uniform2d":0.7}]
    ,"color":[{"a":0},{"duration":1,"a":255},{"duration":duration-1},{"duration":1,"a":0}]
    });

    this.loader.addAnimation({
        "start": start, "duration": duration
        ,"layer": layer
        ,"image": "orpo_smile.png"
        ,"position":[
            {"x":getScreenWidth()*0.15,"y":getScreenHeight()*0.3},
            {"duration":delayBeforeMove},
            {"duration":moveDuration,"x":getScreenWidth()*-0.15,"y":getScreenHeight()*-0.45},
            {"duration":animShow},
            {"duration":moveBackDuration,"x":getScreenWidth()*0.15,"y":getScreenHeight()*0.3},
        ]
        ,"scale": [{"uniform2d":0.7}]
        ,"color":[{"a":0},{"duration":delayBeforeMove+moveDuration+animShow},{"duration":0,"a":255}]
    });

    this.loader.addAnimation({
        "start": start, "duration": duration
       ,"layer": layer
       ,"image": "orpo_nice.png"
       ,"scale": [{"uniform2d":1.6}]
       ,"color":[{"a":255},{"duration":3},{"duration":1,"a":0}]
   });
   this.loader.addAnimation({
    "start": start, "duration": duration
   ,"layer": layer
   ,"image": "gift_ask.png"
   ,"scale": [{"uniform2d":1.6}]
   ,"position":[{"x":getScreenWidth()*0.67,"y":getScreenHeight()*0.5}]
   ,"color":[{"a":0},{"duration":3},{"duration":1,"a":255},{"duration":3},{"duration":1,"a":0}]
});

    this.loader.addAnimation({
        "start": start, "duration": duration
        ,"layer": layer
        ,"image": "dream_small_bubbles.png"
        ,"position":[
            {"x":getScreenWidth()*0.4,"y":getScreenHeight()*0.9},
            {"duration":delayBeforeMove},
            {"duration":moveDuration,"x":getScreenWidth()*0.1,"y":getScreenHeight()*0.1},
            {"duration":animShow},
            {"duration":moveBackDuration,"x":getScreenWidth()*0.4,"y":getScreenHeight()*0.9},
        ]
        ,"scale": [{"uniform2d":0.7}]
        ,"color":[{"a":0},{"duration":delayBeforeMove/2},{"duration":delayBeforeMove/2,"a":255},{"duration":moveDuration+animShow},{"duration":moveBackDuration,"a":0}]
        ,"shader":{"name":"dreamy2.fs"}
    });

    this.loader.addAnimation ({
        "start": start, "duration": duration, "layer": layer
        ,"image": ["anim/wrestling1/wrestling1_1.png","dream_big_bubble.png","anim/wrestling1/wrestling1_labels.png"]
        ,"animationObject": animWrestling1
        ,"initFunction":"{loadPngAnimation(animation.animationObject);}"
        ,"runFunction":"{playPngAnimation(animation);}"
        ,"scale":[{"uniform2d":3.0}]
        ,"color":[{"a":0},{"duration":delayBeforeMove/2},{"duration":delayBeforeMove/2,"a":255},{"duration":moveDuration+animShow},{"duration":moveBackDuration,"a":0}]
        ,"position":[
            {"x":getScreenWidth()*0.8,"y":getScreenHeight()*1.4},
            {"duration":delayBeforeMove},
            {"duration":moveDuration,"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5},
            {"duration":animShow},
            {"duration":moveBackDuration,"x":getScreenWidth()*0.8,"y":getScreenHeight()*1.4},
        ]
       ,"shader":{"name":"dreamy.fs"}
   });
   this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"sceneOrpoFbo","action":"unbind"}
    });
}

Demo.prototype.scenePurra = function(start, duration)
{
    this.loader.addAnimation([
        { 
            "start": start, "duration": duration
            ,"layer": layer
            ,"fbo":{"name":"scenePurraFbo","action":"begin","storeDepth":false}
        }]);
    
    this.loader.addAnimation({
        "start": start, "duration": duration
       ,"layer": layer
       ,"image": "stars.png"
       ,"scale": [{"uniform2d":1.0}]
       ,"color":[{"a":0},{"duration":1,"a":255},{"duration":duration-1},{"duration":1,"a":0}]
   });

   this.snowFall(start-10, duration+10, ["persu","sisu","swastika"]);

   var delayBeforeMove=3;
   var moveDuration=3;
   var animShow=3;
   var moveBackDuration=3;

   this.loader.addAnimation({
    "start": start, "duration": duration
    ,"layer": layer
    ,"image": "purra.png"
    ,"position":[
        {"x":getScreenWidth()*0.15,"y":getScreenHeight()*0.3},
        {"duration":delayBeforeMove},
        {"duration":moveDuration,"x":getScreenWidth()*-0.15,"y":getScreenHeight()*-0.45},
        {"duration":animShow},
        {"duration":moveBackDuration,"x":getScreenWidth()*0.15,"y":getScreenHeight()*0.3},
    ]
    ,"scale": [{"uniform2d":0.7}]
    ,"color":[{"a":0},{"duration":1,"a":255},{"duration":duration-1},{"duration":1,"a":0}]
    });

    this.loader.addAnimation({
        "start": start, "duration": duration
        ,"layer": layer
        ,"image": "purra_smile.png"
        ,"position":[
            {"x":getScreenWidth()*0.15,"y":getScreenHeight()*0.3},
            {"duration":delayBeforeMove},
            {"duration":moveDuration,"x":getScreenWidth()*-0.15,"y":getScreenHeight()*-0.45},
            {"duration":animShow},
            {"duration":moveBackDuration,"x":getScreenWidth()*0.15,"y":getScreenHeight()*0.3},
        ]
        ,"scale": [{"uniform2d":0.7}]
        ,"color":[{"a":0},{"duration":delayBeforeMove+moveDuration+animShow},{"duration":0,"a":255}]
    });
    this.loader.addAnimation({
        "start": start, "duration": duration
       ,"layer": layer
       ,"image": "riikka_nice.png"
       ,"scale": [{"uniform2d":1.6}]
       ,"color":[{"a":255},{"duration":2},{"duration":1,"a":0}]
   });
   this.loader.addAnimation({
    "start": start, "duration": duration
   ,"layer": layer
   ,"image": "gift_ask.png"
   ,"scale": [{"uniform2d":1.6}]
   ,"position":[{"x":getScreenWidth()*0.67,"y":getScreenHeight()*0.5}]
   ,"color":[{"a":0},{"duration":2},{"duration":1,"a":255},{"duration":3},{"duration":1,"a":0}]
});

    this.loader.addAnimation({
        "start": start, "duration": duration
        ,"layer": layer
        ,"image": "dream_small_bubbles.png"
        ,"position":[
            {"x":getScreenWidth()*0.4,"y":getScreenHeight()*0.9},
            {"duration":delayBeforeMove},
            {"duration":moveDuration,"x":getScreenWidth()*0.1,"y":getScreenHeight()*0.1},
            {"duration":animShow},
            {"duration":moveBackDuration,"x":getScreenWidth()*0.4,"y":getScreenHeight()*0.9},
        ]
        ,"scale": [{"uniform2d":0.7}]
        ,"color":[{"a":0},{"duration":delayBeforeMove/2},{"duration":delayBeforeMove/2,"a":255},{"duration":moveDuration+animShow},{"duration":moveBackDuration,"a":0}]
        ,"shader":{"name":"dreamy2.fs"}
    });

    this.loader.addAnimation ({
        "start": start, "duration": duration, "layer": layer
        ,"image": ["anim/wrestling2/wrestling2_1.png","dream_big_bubble.png","anim/wrestling2/wrestling2_labels.png"]
        ,"animationObject": animWrestling2
        ,"initFunction":"{loadPngAnimation(animation.animationObject);}"
        ,"runFunction":"{playPngAnimation(animation);}"
        ,"scale":[{"uniform2d":3.0}]
        ,"color":[{"a":0},{"duration":delayBeforeMove/2},{"duration":delayBeforeMove/2,"a":255},{"duration":moveDuration+animShow},{"duration":moveBackDuration,"a":0}]
        ,"position":[
            {"x":getScreenWidth()*0.8,"y":getScreenHeight()*1.4},
            {"duration":delayBeforeMove},
            {"duration":moveDuration,"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5},
            {"duration":animShow},
            {"duration":moveBackDuration,"x":getScreenWidth()*0.8,"y":getScreenHeight()*1.4},
        ]
       ,"shader":{"name":"dreamy.fs"}
   });
   this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"scenePurraFbo","action":"unbind"}
    });
}

Demo.prototype.sceneGreets = function(start, duration)
{
    this.loader.addAnimation([
        { 
            "start": start, "duration": duration
            ,"layer": layer
            ,"fbo":{"name":"sceneGreetsFbo","action":"begin","storeDepth":false}
        }]);
    
    this.loader.addAnimation({
        "start": start, "duration": duration
       ,"layer": layer
       ,"image": "book.png"
       ,"scale": [{"uniform2d":1.0}]
       ,"color":[{"a":0},{"duration":1,"a":255},{"duration":duration-1},{"duration":1,"a":0}]
   });

   var sleep = 1.0;
   for (var i=1;i<=3;i++) {
        var delay = i*sleep;
        this.loader.addAnimation({
            "start": start+delay, "duration": duration-delay
            ,"layer": layer
            ,"image": "greets/naughty_"+i+".png"
            ,"scale": [{"uniform2d":0.9}]
            ,"position":[{"x":getScreenWidth()*0.37,"y":getScreenHeight()*(0.9-i/10.0)}]
            ,"color":[{"a":0},{"duration":sleep,"a":255}]
            ,"shader":{"name":"slideRevealPic.fs"}
            });
    }

    for (var i=1;i<=8;i++) {
        var delay = i*sleep+3;
        this.loader.addAnimation({
            "start": start+delay, "duration": duration-delay
            ,"layer": layer
            ,"image": "greets/nice_"+i+".png"
            ,"scale": [{"uniform2d":0.9}]
            ,"position":[{"x":getScreenWidth()*0.7456,"y":getScreenHeight()*(0.9-i/10.0)}]
            ,"color":[{"a":0},{"duration":sleep,"a":255}]
            ,"shader":{"name":"slideRevealPic.fs"}
            });
    }
    this.loader.addAnimation(
        { 
             "start": start, "duration": duration
            ,"layer": layer
            ,"fbo":{"name":"sceneGreetsFbo","action":"unbind"}
        });
}

Demo.prototype.sceneEnd = function(start, duration)
{
    this.loader.addAnimation({
        "start": start, "duration": duration
       ,"layer": layer
       ,"image": "seasons_greetings.png"
       ,"scale": [{"uniform2d":1.5}]
       ,"color":[{"a":0},{"duration":5,"a":255}]
   });
}

Demo.prototype.sceneEffectX = function(start, duration)
{
    this.loader.addAnimation([
        { 
            "start": start, "duration": duration
            ,"layer": layer
            ,"fbo":{"name":"sceneEffectXFbo","action":"begin","storeDepth":false}
        }]);

    var c1 = colorScheme[4];
        
    this.loader.addAnimation({
        "start": start, "duration": duration
        ,"layer": layer
        ,"image": ["_embedded/defaultWhite.png"]
        ,"color":[{"r":c1[0],"g":c1[1],"b":c1[2]}]
    });
    this.loader.addAnimation({
        "start": start, "duration":duration
       ,"layer": layer, "image": ["gingerbread/7.png"]
       //,"shader":{"name":"kaleidoscope.fs"}
       ,"shader":{"name":"rotozoom.fs"}
       //,"shader":{"name":"tunnel.fs"}
       ,"scale": [{"uniform2d":4.0}]
       ,"color":[{"a":20}]
   });

    this.loader.addAnimation({
        "start": start, "duration": duration
       ,"layer": layer
       ,"image": "gifts.png"
       ,"position": [{"x":getScreenWidth()*0.5, "y":getScreenHeight()*-0.45},{"duration":duration-2,"x":getScreenWidth()*0.5, "y":getScreenHeight()*0.4}]
       //,"color":[{"a":0},{"duration":5,"a":255}]
   });
    for(var i = 0; i < 8; i++) {
        this.loader.addAnimation({
            "start": start, "duration": duration
           ,"layer": layer
           ,"image": "bauble/"+Math.floor(Math.random()*4+1)+".png"
           ,"scale": [{"uniform2d":0.7+(i/10.0)*0.5}]
           ,"position": [{"x":getScreenWidth()*(Math.random()*0.65+0.25), "y":getScreenHeight()*(Math.random()*0.4+1.0)}]
           ,"angle":[{"degreesZ":"{return Math.sin(getSceneTimeFromStart()+"+(Math.random()*10)+") * "+Math.floor(20+Math.random()*20)+";}"}]
           //,"color":[{"a":0},{"duration":5,"a":255}]
       });
    }
    this.loader.addAnimation(
        { 
             "start": start, "duration": duration
            ,"layer": layer
            ,"fbo":{"name":"sceneEffectXFbo","action":"unbind"}
        });
}

Demo.prototype.sceneEffectY = function(start, duration)
{
    var giftScreens = 16;
    for(var i = 0; i < giftScreens; i++) {
        this.loader.addAnimation([
            { 
                "start": start, "duration": duration
                ,"layer": layer
                ,"fbo":{"name":"gift"+i+"Fbo","action":"begin","storeDepth":false}
            }]);

    var c1 = colorScheme[Utils.getRandomArrayIndex(colorScheme)];
    var c2 = colorScheme[Utils.getRandomArrayIndex(colorScheme)];
    var c3 = colorScheme[Utils.getRandomArrayIndex(colorScheme)];
    
    this.loader.addAnimation({
        "start": start, "duration": duration
        ,"layer": layer
        ,"image": ["_embedded/defaultWhite.png"]
        ,"color":[{"r":c1[0],"g":c1[1],"b":c1[2]}]
    });
    this.loader.addAnimation({
        "start": start, "duration":duration
       ,"layer": layer, "image": ["_embedded/defaultTransparent.png"]
       ,"shader":{"name":"spiral.fs", "variable":[
        {"name":"background","type":"int","value":[Math.floor(Math.random()*3+1)]}
        ]}
        ,"color":[{"a":15}]
    });
    this.loader.addAnimation({
        "start": start, "duration": duration
       ,"layer": layer
       ,"image": ["_embedded/defaultTransparent.png"]
       ,"shader":{"name":"raymarch.fs", "variable":[
           {"name":"scene", "type":"int", "value":[2]}
           ,{"name":"shift","value":[0.0]}
           ,{"name":"boxRotateDegrees","value":"{return [getSceneTimeFromStart()*20,getSceneTimeFromStart()*20,getSceneTimeFromStart()*20]}"}
           ,{"name":"color1","value":[c2[0]/255.,c2[1]/255.,c2[2]/255.]}
           ,{"name":"color2","value":[c3[0]/255.,c3[1]/255.,c3[2]/255.]}
           //,{"name":"rotateDegrees","value":"{ return [Sync.getSyncValue('ray:rotx'),Sync.getSyncValue('ray:roty'),Sync.getSyncValue('ray:rotz')]}"}
           //,{"name":"movePosition","value":"{ return [Sync.getSyncValue('ray:x'),Sync.getSyncValue('ray:y'),Sync.getSyncValue('ray:z')]}"}
           //,{"name":"pixelateResolution","value":"{ return [Sync.getSyncValue('ray:pixres')]}"}
           //,{"name":"twistSkew","value":"{ return [Sync.getSyncValue('ray:twistSkew')]}"}
           ]}
       ,"color":[{"a":255}]
    });
    this.loader.addAnimation(
        { 
             "start": start, "duration": duration
            ,"layer": layer
            ,"fbo":{"name":"gift"+i+"Fbo","action":"unbind"}
        });
    
    }

    this.loader.addAnimation([
        { 
            "start": start, "duration": duration
            ,"layer": layer
            ,"fbo":{"name":"sceneEffectYFbo","action":"begin","storeDepth":false}
        }]);
        for (var i = 0; i < 6; i++) {
            this.loader.addAnimation({
                "start": start+i*3.5, "duration":6
                ,"layer": layer, "image": ["gift"+i+"Fbo.color.fbo"]
                ,"color":[{"a":0},{"duration":0.5,"a":255},{"duration":3},{"duration":0.5,"a":0}]
                });
        }

        var scale =0.25;
        var screenI=0;
        for(var y=0;y<4;y++){
            for(var x=0; x<4; x++) {
                this.loader.addAnimation({
                    "start": start+4*2.5+screenI*0.25, "duration":duration
                    ,"layer": layer, "image": ["gift"+screenI+"Fbo.color.fbo"]
                    ,"scale":[{"uniform2d":scale}]
                    ,"position":[{"x":getScreenWidth()*(scale/2.0+scale*x),"y":getScreenHeight()*(1-(scale/2.0+scale*y))}]
                    ,"color":[{"a":0},{"duration":0.25,"a":255}]
                    });
                    screenI++;
            }
        }

        /*this.loader.addAnimation({
    "start": start, "duration":end
    ,"layer": layer, "image": ["gingerbread/7.png"]
    ,"shader":{"name":"tunnel.fs"}
    ,"scale": [{"uniform2d":4.0}]
    //,"color":[{"a":100}]
    });
    this.loader.addAnimation({
        "start": start, "duration": duration+1
        ,"layer": layer
       ,"image": ["gingerbread/7.png"]
       ,"shader":{"name":"slideRevealPic.fs", "variable": [
       {"name": "shift", "value":"{return [0.5]; }"}
       ]}
       ,"color":[{"a":255},{"duration":duration},{"duration":1, "a":0}]
   });*/
   this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"sceneEffectYFbo","action":"unbind"}
    });

}

Demo.prototype.sceneEffectZ = function(start, duration)
{
    var c1 = colorScheme[1];
        
    this.loader.addAnimation({
        "start": start, "duration": duration
        ,"layer": layer
        ,"image": ["_embedded/defaultWhite.png"]
        ,"color":[{"r":c1[0],"g":c1[1],"b":c1[2]}]
    });

    this.loader.addAnimation ({
        "start": start, "duration": duration, "layer": layer
        ,"image": ["anim/soini-thumbs/soini-thumbs-1.png"]
        ,"animationObject": animSoiniThumbs
        ,"initFunction":"{loadPngAnimation(animation.animationObject);}"
        ,"runFunction":"{playPngAnimation(animation);}"
        ,"scale":[{"uniform2d":3.0}]
        ,"color":[{"a":20}]
   });

    for(var i = 0; i < 50; i++) {
        this.loader.addAnimation({
            "start": start+i*0.5, "duration": duration
           ,"layer": layer
           ,"image": "gingerbread/"+Math.floor(Math.random()*9+1)+".png"
           ,"scale": [{"uniform2d":0.4+Math.random()*0.4}]
           ,"position": [{"x":getScreenWidth()*Math.random(), "y":getScreenHeight()*Math.random()}]
           ,"angle":[{"degreesZ":Math.floor(Math.random()*360)}]
           ,"color":[{"a":0},{"duration":1,"a":255}]
       });
    }
}

Demo.prototype.init = function()
{
    /*
     * TEXT WRITER FBO
     */

    this.loader.addAnimation([
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"textFbo","action":"begin","storeDepth":false}
    }]);
    this.loader.addAnimation(
    {
         "start": start, "duration": duration
        ,"layer": layer
        ,"text":{
             "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'JUMALAUTA';}"
        }
        ,"scale": [{"uniform2d":15.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        ,"shader":{"name":"biasTex.fs", "variable":[
              {"name":"textureBias","value":[0.0]}
        ]}
        ,"color":[{"a":0},{"duration":1,"a":255},{"duration":3},{"duration":1,"a":0}]
    });
    this.loader.addAnimation(
    {
         "start": start, "duration": duration
        ,"layer": layer
        ,"text":{
             "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'NOUSEE';}"
        }
        ,"scale": [{"uniform2d":15.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        ,"shader":{"name":"biasTex.fs", "variable":[
              {"name":"textureBias","value":[0.0]}
        ]}
        ,"color":[{"a":0},{"duration":1+3},{"duration":1,"a":255},{"duration":3},{"duration":1,"a":0}]
    });
    this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"textFbo","action":"unbind"}
    });

    /*
     * FOREGROUND LAYOUT FBO
     */

    this.loader.addAnimation([
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"foregroundFbo","action":"begin","storeDepth":false}
    }]);
    this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"foregroundFbo","action":"unbind"}
    });

    //0 - 15 - production name -  OK
    this.sceneIntro(start, 15);

    //13.5 - 33.5 - sledge - OK
    this.sceneSledge(start+13.5, 21.5);

    //- 0:54 - petteri
    this.sceneOrpo(start+34, 20);

    //- 1:08 - effect X
    this.sceneEffectX(start+54, 14);

    //- 1:22 - riikka
    this.scenePurra(start+68, 14);

    //- 1:49 - effect Y
    this.sceneEffectY(start+82, 28);

    //- 2:04 - greets
    this.sceneGreets(start+109, 16);

    //- 2:14 - effect Z
    this.sceneEffectZ(start+124, 25);

    //- 2:22 - end card - OK
    this.sceneEnd(end-10.0, end);

    /*
     * VISIBLE DRAW TO SCREEN FROM HERE ON
     */

    this.loader.addAnimation({
        "start": start+13.5, "duration": 21.5
       ,"layer": layer
       ,"image": "sceneSledgeFbo.color.fbo"
       ,"scale": [{"uniform2d":1.0}]
       ,"color":[{"a":255},{"duration":20.5},{"duration":1,"a":0}]
   });

   this.loader.addAnimation({
        "start": start+34, "duration": 20
       ,"layer": layer
       ,"image": "sceneOrpoFbo.color.fbo"
       ,"scale": [{"uniform2d":1.0}]
       ,"color":[{"a":0},{"duration":1,"a":255},{"duration":18},{"duration":1,"a":0}]
   });

   this.loader.addAnimation({
    "start": start+68, "duration": 14
   ,"layer": layer
   ,"image": "scenePurraFbo.color.fbo"
   ,"scale": [{"uniform2d":1.0}]
   ,"color":[{"a":0},{"duration":1,"a":255},{"duration":12},{"duration":1,"a":0}]
});

this.loader.addAnimation({
    "start": start+54, "duration": 14
   ,"layer": layer
   ,"image": "sceneEffectXFbo.color.fbo"
   ,"scale": [{"uniform2d":1.0}]
   ,"color":[{"a":0},{"duration":1,"a":255},{"duration":12},{"duration":1,"a":0}]
});

this.loader.addAnimation({
    "start": start+82, "duration": 28
   ,"layer": layer
   ,"image": "sceneEffectYFbo.color.fbo"
   ,"scale": [{"uniform2d":1.0}]
   ,"color":[{"a":0},{"duration":1,"a":255},{"duration":26},{"duration":1,"a":0}]
});

this.loader.addAnimation({
    "start": start+109, "duration": 16
   ,"layer": layer
   ,"image": "sceneGreetsFbo.color.fbo"
   ,"scale": [{"uniform2d":1.0}]
   ,"color":[{"a":0},{"duration":1,"a":255},{"duration":14},{"duration":1,"a":0}]
});

this.loader.addAnimation({
        "start": start, "duration": end
       ,"layer": layer
       ,"image": "vignette.png"
       ,"color":[{"a":0},{"duration":4,"a":255}]
       ,"shader":{"name":"dreamy3.fs"}
    });
    this.loader.addAnimation({
         "start": start, "duration": end
        ,"layer": layer
        ,"image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"vignette.fs"}
    });
}
