// GPL licensed samples from https://sourceforge.net/projects/hydrogen/files/Sound%20Libraries/Main%20sound%20libraries/TR808909.h2drumkit/download
// https://www.gnu.org/licenses/

const kickPlayer = new Tone.Player("data:audio/mp3;base64,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")
  .toDestination();

const snarePlayer = new Tone.Player("data:audio/mp3;base64,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")
  .toDestination();

const cowbellPlayer = new Tone.Player("data:audio/mp3;base64,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")
  .toDestination();
cowbellPlayer.volume.value = -8

const hatPlayer = new Tone.Player("data:audio/mp3;base64,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")
  .toDestination();
