const Symbols = function(){
    PartBase.call(this);

    this.setEdgeDetection();
    this.setBloom(1.0);

    this.picktureId = 0;

    this.materials = this.createMaterials();
    this.picture = this.createSprite(this.picktureId);

    this.picture.scale.set(50, 50, 1);
    this.scene.add(this.picture);
};

Symbols.prototype = PartBase.prototype.inheritance();

Symbols.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);

    const id = TDEMO.SYNC.getSymbol();
    if(id !== this.picktureId){
        this.picture.material = this.materials[id];
        this.picture.material.needsUpdate = true;

    }
    this.picktureId = id;
    

    const pos = TDEMO.SYNC.getObjPosition();
    this.picture.position.x = pos.x;
    this.picture.position.y = pos.y;
    this.picture.position.z = pos.z;

    


    const edges = TDEMO.SYNC.getEdges();
    this.edge.enabled = edges;


};

Symbols.prototype.createSprite = function(index){
    const sprite = new THREE.Sprite(this.materials[index]);
    return sprite;
};

Symbols.prototype.createMaterials = function (){
    const materials = [];
    for(let i = 0; i < 33; ++i){
        const material = new THREE.SpriteMaterial({
            map : TDEMO.TEXTURES.getTextures()[i],
            blending: THREE.AdditiveBlending,
        });
        materials.push(material);
    }
    return materials;
}