#version 330 core

in vec2 texCoord;
in vec4 vertexFragColor;
out vec4 fragColor;
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform vec4 color = vec4(1);
uniform float shift = 0.0;
uniform float time = 1.0;
uniform float textureBias = 0.0;

void main()
{
    float shift2 = shift;
    if (shift2 > 0.5) {
        shift2 = 1.0-shift2;
    }

   vec2 coord=texCoord;
   coord.s += (sin(coord.t*8.0 +coord.s*0.4+ time*4.0)*0.12)*(coord.t-0.5)*shift2;
   coord.t += (cos(coord.s*50.0 +coord.t*1.3 + time*2.3)*0.15)*(coord.t-0.5)*shift2;

    //vec2 coord=texCoord;
    vec4 color0 = texture(texture0, coord, textureBias);
    vec4 color1 = texture(texture1, coord, textureBias);

    fragColor = vec4(1);
    fragColor *= mix(color0, color1, shift);
    fragColor *= color;
}
