#version 330 core

in vec2 texCoord;
out vec4 fragColor;
uniform sampler2D texture0;
uniform vec4 color = vec4(1,1,1,1);

#define M_PI 3.1415926535897932384626433832795

uniform float time = 1.0;
uniform float fade = 0.0;
uniform float angle = 0.0;
uniform float zoom = 1.0;

vec4 rotozoom()
{
	vec2 coord=texCoord.xy;
	float x = (-1.0 + 2.0 * coord.x);
	float y = (-1.0 + 2.0 * coord.y);
	float dist = sqrt(x*x + y*y);

	coord.x = (x*cos(angle) - y*sin(angle)) * zoom;
	coord.y = (y*cos(angle) + x*sin(angle)) * zoom;

	vec4 uv = texture(texture0, mod(coord + vec2(time), vec2(1.0,1.0)));
	uv.a -= fade/dist;

	return uv;
}

void main()
{
	fragColor = rotozoom() * color;
}
