#version 330 core

in vec2 texCoord;
in vec4 vertexFragColor;
out vec4 fragColor;
uniform sampler2D texture0;
uniform float time = 1.0;
uniform vec4 color = vec4(1,1,1,1);

uniform float fade = 1.0;

void main()
{
	vec2 coord=texCoord;
	float x = (-1.0+2.0*coord.x);
	float y = (-1.0+2.0*coord.y);
	float u = sqrt(x*x + y*y);
	float v = atan(y, x);

	coord.x = cos(v+time)/u+sin(time)*0.2;
	coord.y = sin(v+time)/u+cos(time)*0.2;
	coord = coord + time*0.8;
	//coord = pixelate(coord);
	//vec4 uv = texture2D(texture0, coord + time*0.8);
	//fragColor = vec4(uv.r,uv.g,uv.b,uv.a-fade/u);// * color;


	vec4 uv = texture2D(texture0, coord);
	float d = distance(texCoord, vec2(0.5,0.5));
	fragColor = vec4(uv.r,uv.g,uv.b,d*color.a);// * color;
}
