	device zxspectrum128
;        ORG #4000
; incbin "balls.scr"
        ORG #6000
mixp equ $BD00; place must be aligned to 256
begin
	ld sp,$5FFF
	ld a,r,(R1),a
beggame:
;	ld hl,$5800,de,$5801,bc,767,(hl),l:ldir
    ld hl,$5AFF,de,$5AFe,bc,$1B00-1,(hl),0:lddr

; draw vials
	ld a,8
	ld de,$4800
dv1:
	push af
	ld a,112
	ld hl,vs
	push de
dv2:
	exa
	push de
	ldi:ldi:ldi:ldi
	pop de
	call nbde
	exa
	dec a
	jr nz,dv2
	pop de
	inc e,e,e,e
	pop af
	dec a
	jr nz,dv1
;
	call mixlvl
	call drawgame
	xor a
	ld (ppos),a
	call arrxor
	dec a
	ld (bsel),a
gamelp:
;key left
	ld a,$DF:in a,($FE):and 2:jr nz,keyright  ;O
	ld c,$FF
putarr:
	ei:halt
	ld a,(ppos)
	call arrxor
	add a,c
	and 7
	call arrxor
	ld (ppos),a
endkeys:
;	call wk
	ld b,15
del: ei:halt:djnz del
	jr gamelp
keyright:
	ld a,$DF:in a,($FE):and 1:jr nz,keyfire ;P
;draw arrow cursor
	ld c,1
	jr putarr

keyfire:
	ld a,$BF:in a,($FE):and 1:jp nz,gamelp;Enter
;test selection status
	ld a,(bsel)
	cp $FF
	jp nz,select_ok
	ld a,(ppos)
	call tabadr
;find first ball
	ld b,5
ffblp:
	ld a,(hl)
	or a
	jr nz,gotball
	inc hl
	djnz ffblp
;if empty,ignore
	jp endkeys
gotball:
	ld a,(hl)
	ld (bcol),a
	ld a,(ppos)
	ld (bsel),a
;animate
	ld a,5
	sub b
	ld b,a
	jr z,nomove
mup:
	ld (hl),0
	dec hl
	ld a,(bcol)
	ld (hl),a
	call drawgame3
;	jr $
	djnz mup
nomove
	ld (hl),0
	ld de,(bsel)
	ld d,0
	ld hl,upper
	add hl,de
	ld a,(bcol)
	ld (hl),a
	call drawgame3
	jp endkeys

select_ok:
;check vial empty?
	ld a,(ppos)
	call tabadr
	ld a,(hl)
	or a
	jp nz,endkeys
;find first ball
	ld b,5
ffblp1:
	ld a,(hl)
	or a
	jr nz,gotball1
	inc hl
	djnz ffblp1
gotball1:
	ld a,5
	sub b
	ld b,a
;display ball on new place
	ld de,(bsel)
	ld d,0
	ld hl,upper
	add hl,de
	ld (hl),0

	ld de,(ppos)
	ld d,0
	ld hl,upper
	add hl,de
	ld a,(bcol)
	ld (hl),a

	call drawgame3
	ei:halt
	ld (hl),0
;	jr $
;drop down
	ld a,(ppos)
	call tabadr

ddlp:
	ld a,(bcol)
	ld (hl),a
	call drawgame3
	ld (hl),0
	inc hl
	djnz ddlp
	dec hl
	ld (hl),a
	call drawgame3
	ld a,$FF,(bsel),a
	call checkl
	jp nz,endkeys

       LD    HL,D_MEL1
       CALL  MELBEP
       LD    HL,D_MEL1
       CALL  MELBEP
       jp beggame
MELBEP LD    B,(HL)      ; B - 
       INC   B           ;   
       DEC   B           ;    0
       RET   Z
       INC   HL
       LD    C,(HL)      ; C -  
       INC   HL
       PUSH  HL
       CALL  BEPER       ; 
       POP   HL
       JR    MELBEP

BEPER  PUSH  BC
       LD    A,B         ;    
       CALL  11560       ;    
       LD    A,100
       CALL  11560       ;    100
       RST   40
       DEFB  5,56        ; 
       POP   BC
       LD    A,C         ;  
       AND   A
       JP    M,BEPER1    ; ,   BEPER1
       CALL  11560       ;      
       JP    1016        ;   
BEPER1 NEG               ;  
       CALL  11560       ;  
       RST   40
       DEFB  27,56       ; 
       JP    1016        ;   
;BEPER  .........
D_MEL1 DEFB  10,-5,10,0,10,1,10,2
       DEFB  20,5,10,2,20,5,10,7
       DEFB  0

;tt: ld a,r:out ($FE),a:jr tt
;-------------- V A R I A B L E S --------------
bsel: db 0 ; select status $FF if none
bcol: db 0
ppos: db 0 ; cursor position
arrow:  db 1, 128, 7, 224, 31, 248, 127, 254, 3, 192, 3, 192
upper: db 0,1,2,3,4,5,6,7
;-------------- R O U T I N E S --------------
tabadr: ; calculate table address, IN:A=number of vial, OUT:HL=adr
	ld h,mixp/256
	ld l,a
	add a,a
	add a,a
	add a,l
	ld l,a
	ret
wk:
	xor a:in a,($fe)
	cpl
	and 31
	jr nz,wk
	ret
rndn: ;random number 0..N, IN: B=num, OUT:A=rnd(N)
	call random
rn:	sub b
	jr nc,rn
	add a,b
	ret
random  PUSH BC:LD A,(R1),C,A
        LD A,(R2):ADD A,C:LD C,A
        LD (R1),A,A,(R3)
        SUB C:LD C,A,(R2),A
        RRCA:LD (R3),A
        LD A,C:POP BC
        RET

R1      DB #15
R2      DB #70
R3      DB #FD 

checkl:
	ld hl,mixp
	ld de,5
	ld c,7 ; check vials w/o right position
chlp1:
	push hl
	pop ix
	ld b,4
chlp2:
	inc ix
	ld a,(hl)
	cp (ix+0)
	ret nz
	djnz chlp2
	add hl,de
	dec c
	jr nz,chlp1
	xor a
	ret

mixlvl:
;fill values
	ld hl,mixp
	ld a,1
mxlp1:
	ld b,5
mxlp2:
	ld (hl),a
	inc l
	djnz mxlp2
	inc a
	cp 8
	jr nz,mxlp1
mxlp3:
	ld (hl),0
	inc l
	jr nz,mxlp3

;mix random
	ld b,34+1
frlp1:
	push bc
frlp2:
	ld b,34+1
	call rndn
	cp l
	jr c,frlp2
	ld e,a
	ld d,h
	ld c,(hl)
	ld a,(de)
	ld (hl),a
	ld a,c
	ld (de),a
	inc l
	pop bc
	djnz frlp1
;reset upper
	ld hl,upper
	ld b,8
resu:
	ld (hl),0:inc hl:djnz resu
	ret
arrxor: ; draw xored arrow,A=coord.X
	push af
	add a,a
	add a,a
	add a,$e1 -32*2
	ld e,a
	ld d,$54
	ld hl,arrow
	ld b,6
axlp:
	ld a,(de):xor (hl):ld (de),a:inc hl
	inc e
	ld a,(de):xor (hl):ld (de),a:inc hl
	dec e
	call nbde
	djnz axlp
	pop af
	ret
nbde    INC D:LD A,D:AND 7:RET NZ
        LD A,E:ADD A,#20:LD E,A:RET C
        LD A,D:SUB 8:LD D,A:RET
;nbhl    INC h:LD A,h:AND 7:RET NZ
;        LD A,L:ADD A,#20:LD L,A:RET C
;        LD A,H:SUB 8:LD H,A:RET

putball: ; fill attribute, IX=address,A=color
	or a
	jr z,nobright
	or $40
nobright:
	ld (ix+0),a
	ld (ix+1),a
	and $3F
	ld (ix+32),a
	ld (ix+33),a
	ret
drawgame:
	call drawgame2
;up
	ld hl,$5800+10*32
	ld b,8
dg4:
 ld (hl),$7:inc hl
 ld (hl),$7:inc hl
 ld (hl),$7:inc hl
 ld (hl),$47:inc hl
 djnz dg4

;fill last line
	ld hl,$5AE0-64
dg3: ld (hl),$7:inc l:jr nz,dg3
	ret

drawgame3:
	push af,bc,de,hl,ix
	ei:halt
	call drawgame2
	pop ix,hl,de,bc,af
	ret
drawgame2:
	ld hl,mixp
	ld ix,$5801+11*32
	ld c,8
dg1
	ld b,5
	push ix
	ld de,64
dg2
	ld (ix-1),$07
	ld (ix+31),$07
;
	ld (ix+2),$47
	ld (ix+34),$47

	ld a,(hl)
	inc hl
	call putball
	add ix,de
	djnz dg2
	
	pop ix
	inc ix,ix,ix,ix
	dec c
	jr nz,dg1
;5901 - draw position
	ld hl,upper
	ld b,8
	ld ix,$5901
duplp:
	ld a,(hl)
	inc hl
	call putball
	inc ix,ix,ix,ix
	djnz duplp
	ret
vs:incbin "vial.bin"
end
	display /d,end-begin
	savesna "!void.sna",begin
	savebin "cc.code",begin,end-begin
