//------------------------------------
// "cyan1k"
// 1k intro
// by wacek/arise
//------------------------------------

//------------------------------------
// global compile variables
//------------------------------------

.var from  = $a0		// + $a1
.var temp  = $a2
.var frame = $a3
.var to    = $a4		// + $a5
.var temp2 = $a6
.var tempo = $a7
.var counter = $a8
.var ctf_temp = $a9
.var uc_here = $aa
.var uc_here2 = $ab

.var data2 = $1000

.var xpos = $98
.var ypos = $10

.var sprite = $0f80

.var kolor1 = $2400
.var kolor5 = $2500

.var logoline = $9e
.var rasterline = $fa

//------------------------------------
// global compile variables
//------------------------------------

// uncomment below for basic start:
//BasicUpstart2(start)

			* = $0900	"main"
			
start:		sei
			
			// inits, sprite build, music init etc.

			ldx #$00
			stx $d011
			stx uc_here2
			stx $0286
			stx counter
			stx frame
			dex
			stx to
			jsr $e544

			lda #$03
			sta $d020
			sta $d021
			sta tempo
			
			lda #$a9
			sta $d405
			sta $d406
			sta $d405 + 14
			sta $d406 + 14

			lda #$0c
			sta $d405 + 7
			sta $d406 + 7
			sta from + 1

			// copy logo

			ldx #26
!loop:		lda logo_line_1-1,x
			sta $0450 + 487-1,x
			lda logo_line_2-1,x
			sta $0478 + 487-1,x
			dex
			bne !loop-
		
			// unpack colors, phase 1
			
			lda #<packed_kolory
			sta from
			lda #$23
			sta to + 1
			
uc_loop:	ldy uc_here2
			lda (from),y
			beq depacked
			tax
			and #%11111100
			clc
			ror
			ror
			tay
			sta uc_here
			
			txa
			and #%00000011
			tax		
			lda kolor_tab,x		
			
!loop:		sta (to),y
			dey
			bne !loop-
			
			lda to
			adc uc_here	//: #0
			sta to
			bcc !skip+
			
			inc to + 1
			
!skip:		inc uc_here2
			jmp uc_loop
		
			// unpack colors, phase 2
		
depacked:	jsr data2_to_from
			
			tax
			tay
			
!loop:		lda coords_packed,x
			sta temp
			and #$f0
			ror
			ror
			ror
			ror
			sta (from),y
			iny
			lda temp
			and #$0f
			sta (from),y
			inx
			iny
			bne !loop-
			
			inc from + 1
			lda from + 1
			cmp #$12
			bne !loop-

			// unpacking vector data
			
!loop:		jsr coord_to_from
			lda start_bytes,x
			sta (from),y
			inx
			cpx #$10
			bne !loop-

!bloop:		ldx #1
			ldy #$3f
			
!loop:		lda rev1: data2,x
			sta rev2: data2 + $200,y
			
			lda #0
			sta $0f80,x
			
			dey
			inx
			cpx #$40
			bne !loop-

			lda rev1
			clc
			adc #$40
			sta rev1
			sta rev2
			bcc !skip+
			
			inc rev1 + 1
			inc rev2 + 1

!skip:		lda rev1 + 1
			cmp #$22
			bne !bloop-

			lda #$0f
			sta $0f83
			sta $0f86
			sta $d418

			lda #$03
			sta $0f80
			sta $0f89
			
			jsr data2_to_from

			ldx #0

!bloop:		ldy #0

!loop:		lda (from),y
			iny
			clc
			adc (from),y
			clc
			adc #$f8
			sta (from),y
			
			cpy #$3f
			bne !loop-

			lda from
			clc
			adc #$40
			sta from
			bcc !skip+
			
			inc from + 1

!skip:		inx
			cpx #16
			bne !bloop- 

			// setup sprites

			dec $d015

!loop:		lda #sprite / 64
			sta $07f7,x
			dex
			bne !loop-

			// main loop

!bloop:		ldy #2			
			sty temp2

wait:		bit $d011
			bpl *-3
			bit $d011
			bmi *-3
			
			lda #$1b
			sta $d011
			
			jsr music_play

			dec temp2
			beq !skip+

			jsr do_raster

			jmp wait

!skip:		ldx #0
			ldy frame
			
!loop:		jsr coord_to_from
			adc $1080,y
			sta $d000,x			

			inx
			
			jsr coord_to_from
			adc $1140,y
			cmp #logoline
			bcc !skip+

			clc
			lda #$9e
!skip:		sta $d000,x			
						
			inx			
			cpx #$10			
			bne !loop-			

			clc
			
!loop:		lda kolor1,y
			sta $d017,x
			lda kolor5,y
			sta $d01b,x
			
			tya
			adc #$40
			tay
			inx
			cpx #$14
			bne !loop-

			jsr do_raster
			
			inc frame
			ldy frame
			cpy #$40
			bne !skip+

			lda #0		
			sta frame	

!skip:		jmp !bloop-	

//-----------------------------------------			
// subroutines
//-----------------------------------------			

coord_to_from:

			stx ctf_temp
			txa
			and #%00000011
			tax
			lda coord_lo,x
			sta from
			lda ctf_temp
			and #%00001100
			clc
			ror
			ror
			tax
			lda coord_hi,x
			sta from + 1
			ldx ctf_temp
			lda (from),y
			rts

data2_to_from:
			lda #>data2
			sta from + 1
			lda #<data2
			sta from
			rts

do_raster:	ldx #0

			lda #rasterline
!loop:		cmp $d012
			bne !loop-

			ldy #10
!loop:		dey
			bne !loop-

			nop
			bit $ea
			stx $d020

			ldx #3

			ldy #10
!loop:		dey
			bne !loop-

			nop
			nop
			nop
			stx $d020

			rts

//-----------------------------------------			
// data, tables
//-----------------------------------------			

start_bytes:
			.byte 16 + xpos	// (1)
			.byte 16 + ypos // (1)
			.byte 16 + xpos // (2)
			.byte 79 + ypos	// (2)		
						
			.byte 26 + xpos // (5)
			.byte 26 + ypos // (5)
			.byte 26 + xpos // (6)
			.byte 69 + ypos // (6)

			.byte 79 + xpos // (3)
			.byte 79 + ypos // (3)
			.byte 79 + xpos // (4)
			.byte 16 + ypos // (4)

			.byte 69 + xpos // (7)
			.byte 69 + ypos // (7)
			.byte 69 + xpos // (8)
			.byte 26 + ypos	// (8)	


coord_lo:	.byte $00,$40,$80,$c0 
coord_hi:	.byte $10,$11,$12,$13

coords_packed:			
			.import c64 "assets\coordinates_packed.prg"			

logo_line_1:
			.import c64 "assets\logo_01_cut.prg",0,26
logo_line_2:
			.import c64 "assets\logo_01_cut.prg",40,26

packed_kolory:
			.import binary "assets\packed2.kolory.bin"
kolor_tab:	.byte 0
			.byte $01,$0d,$05

//-----------------------------------------			
// music
//-----------------------------------------			
						
music_play: dec tempo 
			bne no_seq_loop
			
			lda #$0e
			sta tempo

play_ch1:	clc
			ldx counter
						
			lda sequence13,x
			and #$f0
			ror
			ror
			ror
			ror
			beq play_ch2

			ldy #0
			jsr load_notes
			jmp !skip+	
				
play_ch2:	lda #$10
			sta $d404

!skip:		lda counter
			and #%11111100
			ror
			ror
			tax

			lda sequence2,x
			beq play_ch3
			
			ldy #7
			jsr load_notes
			jmp !skip+ 

play_ch3:	lda #$10
			sta $d404 + 7
			
!skip:		ldx counter

			lda sequence13,x
			and #$0f
			beq inc_counter

			ldy #14
			jsr load_notes
			jmp !skip+

inc_counter:
			lda #$10
			sta $d404 + 14
			
!skip:		inc counter
			lda counter
			cmp #32
			bne no_seq_loop
						
			lda #0
			sta counter

no_seq_loop:			
			rts			

load_notes:	tax			
			lda	notes_lo,x	
			sta $d400,y	
			lda notes_hi,x	
			sta $d401,y	
			lda #$11	
			sta $d404,y	
notes_lo:	rts	

			//      0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11
			//     -- c-2 c-4 d-4 c-5 g-5 d#4 g#2 g#5 b-1 f-4 b-4

			.byte     $16,$5a,$5a,$b4,$00,$72,$7d,$e9,$db,$d4
notes_hi:	.byte $de
			.byte $04,$10,$12,$20,$31,$13,$06,$33,$03,$15,$1e

// (C-2) c-4 d-4 c-5 g-5 d-4 c-5 g-5
//     1   2   3   4   5   3   4   5
// (C-2) c-4 d#4 c-5 g-5 d#4 c-5 g-5
//     1   2   6   4   5   6   4   5
// (g#2) c-4 d#4 c-5 g#5 d#4 c-5 g#5
//     7   2   6   4   8   6   4   8
// (b-1) d-4 f-4 b-4 g#5 f-4 b-4 g#5
//     9   3   a   b   8   a   b   8

sequence2:	.byte 1,0,1,0,7,0,9	//,0

sequence13:	.byte $00,$02,$30,$04,$50,$03,$40,$05
			.byte $00,$20,$06,$40,$05,$60,$04,$50
			.byte $00,$02,$60,$04,$80,$06,$40,$08
			.byte $00,$30,$0a,$b0,$08,$a0,$0b,$80

//------------------------------------
// all ends here
//------------------------------------