
; Planet of Pyramid Monsters
; 256B oldschool intro
; for Lovebyte 2023
; by mike/zeroteam
;
; required: ZX Spectrum 16kB


DEBUG		equ	0

HILLS_NO	equ	32

		org	24576

A0
;SKIP is used later as a variable
SKIP		ld	hl,16384
		ld	de,16385
		ld	b,6912/256
		ld	(hl),56
		ldir
		ld	l,128
-		ld	h,LINE_TAB/256
		ld	a,l
		dec	a
		ld	c,a
		add	a,a
		inc	a
		cpl
		ld	(hl),a

		inc	h
		ld	(hl),c

		inc	h
		ld	(hl),c

		inc	h
		ld	(hl),a

		rr	l
		jr	nz,-

		IF	DEBUG
		ld	h,LINE_TAB/256
		ld	l,128
		ld	de,16384
DEBUG1		ld	c,h
		ld	b,e
		ld	a,(hl)
		ld	(de),a
		inc	e
		inc	h
		ld	a,(hl)
		ld	(de),a
		inc	e
		inc	h
		ld	a,(hl)
		ld	(de),a
		inc	e
		inc	h
		ld	a,(hl)
		ld	(de),a
		ld	e,b
		ld	h,c
		inc	d
		srl	l
		jr	nz,DEBUG1
		ld	a,56+64
		ld	(22529),a
		ld	(22531),a
		ENDIF


MLOOP		ld	hl,SKIP
		dec	(hl)
		ld	a,(hl)
		or	a
		jr	nz,HILLS_NO_SPACE
		ld	(hl),5

		;ld	a,(HILLS+3*HILLS_NO-2)
		;or	a
		;jr	nz,HILLS_NO_SPACE
		ld	hl,HILLS+3*HILLS_NO-4
		ld	de,HILLS+3*HILLS_NO-1
		ld	bc,3*HILLS_NO-3
		lddr
		inc	hl
		ld	a,r
		and	31
		ld	(hl),a
		inc	hl
		ld	(hl),070h
		inc	hl

XORPATTERN	ld	de,0FF44h
		rrc	e
		inc	e
		ld	a,e
		xor	d
		ld	d,a
		ld	(XORPATTERN+1),de
		ld	(hl),a


;PATTERN		ld	c,-1
;XOR_PATTERN	ld	a,10001000b
;		rrca
;		inc	a
;		ld	(XOR_PATTERN+1),a
;		xor	c
;		ld	(PATTERN+1),a
;		ld	(hl),a

HILLS_NO_SPACE

		call	DRAW
		ld	hl,HILLS
UPDATE_HILL	ld	e,(hl)
		inc	hl
		ld	a,(hl)
		or	a
		jr	z,SKIP_UPDATE
		inc	a
		ld	d,a
		and	7
		jr	nz,UH1
		call	DOWNDEX
		jr	nc,UH1
		ld	d,0
UH1		ld	(hl),d
		dec	hl
		ld	(hl),e
		inc	hl
		inc	hl
		inc	hl
		jr	UPDATE_HILL
SKIP_UPDATE

		ld	hl,7000h
		ld	de,5000h
		ld	bc,2048
		ldir

NOISE		ld	h,0
		ld	d,70h
		ld	b,2048/256
		ldir
		ld	a,h
		and	31
		ld	h,a
		ld	(NOISE+1),a

;		ei
;		halt

		jr	MLOOP

DRAW
		ld	hl,HILLS
DRAW0		ld	e,(hl)
		inc	hl
		ld	a,(hl)
		or	a
		ret	z


		ld	d,a
		inc	hl
		ld	a,(hl)
		ld	ixl,a
		inc	hl
		push	hl
		ld	c,e
		ld	l,16
		ld	b,l

T		ld	ixu,e
		ld	a,l
		ex	af,af'


LLL2		ld	h,LINE_TAB/256

		call	ORBYTE

		ld	l,b

		ld	a,c
		sub	e
		jr	z,DRAW_ONE_BYTE
		inc	e
		dec	a
		jr	z,DRAW_ONE_BYTE

		ld	b,a
		ld	a,ixl
DRAW_MORE_BYTES	ld	(de),a
		inc	e
		djnz	DRAW_MORE_BYTES
		ld	b,l

DRAW_ONE_BYTE	
		call	ORBYTE

		ld	e,ixu
		ex	af,af'
		ld	l,a
		inc	d
		ld	a,d
		and	7
		jr	nz,DOWNHL

		call	DOWNDEX

		ld	a,c
		add	a,32
		ld	c,a
		jr	c,T4
DOWNHL		
		ld	a,e
		and	31
		jr	z,T3
		rlc	l
		ld	a,e
		sbc	a,0
		ld	e,a
T3		ld	a,c
		inc	a
		and	31
		jr	z,T
		rrc	b
		ld	a,c
		adc	a,0
		ld	c,a
		jr	T
T4
		pop	hl
		jr	DRAW0

ORBYTE
		ld	a,(de)
		and	(hl)
		ld	(de),a
		inc	h
		ld	a,(hl)
		and	ixl
		inc	h
		ex	de,hl
		or	(hl)
		ld	(hl),a
		ex	de,hl
		ret
DOWNDEX
		ld	a,d
		sub	8
		ld	d,a
		ld	a,e
		add	a,32
		ld	e,a
		ret


A0LEN		equ	$-A0

		align	256
LINE_TAB	ds	4*256

HILLS		;defw	5008h		;vram add. of left point
		;defb	08h		;low addres of right point (same vram line)
		;defb	64,128		;pixel of right, pixel of left
		ds	3*HILLS_NO

