.include "swis.asm"

.org 0x8000

.equ interf_tex, 0x10000

Start:
screen_addr:

	; Set screen MODE 8 (640*256*2bpp)
	SWI OS_WriteI+22
	SWI OS_WriteI+8
nframe:
	; Disable cursor
	swi 0x36

	adr r1, interf_tex

	mov r10,#16
	fourOffsets:
		mov r4,#448
		genLoopY:
			sub r5,r4,#256
			mov r5,r5,LSL #0
			mul r6,r5,r5
			mov r3,#1280
			genLoopX:
				mov r8,#8
				mov r9,#0
				pix4:
					sub r5,r3,#640
					sub r5,r5,r10
					sub r5,r5,r8,LSR #1

					mul r7,r5,r5
					add r5,r6,r7,LSR#2

					ands r5,r5,#2048
					moveq r5,#1

					subs r8,r8,#2
					orr r9,r9,r5,LSL r8
				bne pix4
				strb r9,[r1],#1
			subs r3,r3,#4
			bne genLoopX
		subs r4,r4,#1
		bne genLoopY
	subs r10,r10,#4
	bne fourOffsets

	; Init sines
	mov r1,#2048
	mov r2,#32	; CX	; Starting Y (changed a bit from the X86 for the curve drawn to be more consistent)
	mov r3,#772	; SI	; Controls amplitude (I set it to be almost in the 0-255 range)
	adr r0,sines
singen:
	mov r4,r2,LSR #8		; R4 = (CX >> 8)
	add r4,r4,#128
	strb r4,[r0],#1			; Write 
	mov r4,#40				; Controls frequency (40 just happens to loop about 256 pixels)
	mul r4,r2,r4			; R4 = 40 * CX
	add r2,r2,r3			; CX = CX + SI	; moved here compared to where is at x86 code, to make sine more even
	sub r3,r3,r4,ASR #16	; SI = SI - (R4 >> 16) (DX in the x86 IMUL)
	subs r1,r1,#1
	bne singen
	


main_loop:
	adr r10,interf_tex
	mov r11,r10

	swi OS_ReadMonotonicTime

	mov r1,r0,LSR #8

	and r14,r1,#12
	mov r14,r14,LSR #3
	add r14,r14,#1

	ands r1,r1,#3
	beq part0

	swi 0x11E

	and r6,r0,#255

	cmp r6,#252
	blt nobeep

	mov r0,#1
	and r1,r6,#7
	swi 0x40185

	swi 0x107
nobeep:

	; Read VDU values (Start Address mainly)
	adr r0, screen_addr_input
	adr r1, screen_addr
	swi OS_ReadVduVariables
	ldr r1,[r1]

	;adr r1, screen_addr
	;ldr r1,[r1]

	b part1

part0:
	;swi 0x11E
	;swi 0x11F
	;swi 0x100
	;swi 0x100

	;mov r2,#1
	;printimesY:

	adr r2,nframe
	ldr r3,[r2]
	add r3,r3,#1
	str r3,[r2]

		swi 0x111
		and r0,r3,#3
		swi 0

		mov r3,#2
		printimesX:
			;adr r0,message
			;swi OS_WriteO

			swi 1
			.ascii "Ibuprofen \0"
			.align 4
			
			
			subs r3,r3,#1
		bne printimesX
		;mov r0,#32
		;swi OS_WriteC
	;subs r2,r2,#1
	;bne printimesY

	b nextframe
part1:

	adr r8,sines
	ldrb r7,[r8,r6]
	and r7,r7,#252

	mov r4,#160
	mul r3,r7,r4
	add r10,r10,r3

	mov r5,r6,LSL #1
	and r5,r5,#255
	ldrb r7,[r8,r5]
	and r7,r7,#252
	mul r3,r7,r4
	add r11,r11,r3

	ldrb r7,[r8,r6,LSR #1]
	and r3,r7,#3
	rsb r3,r3,#3

	and r7,r7,#252
	add r7,r7,#192

	add r11,r11,r7
	add r11,r11,#32
	add r10,r10,r7

	mov r5,#320
	mov r4,#448
	mul r4,r5,r4
	mul r3,r4,r3
	add r10,r10,r3
	add r11,r11,r3

	mov r4,#256
	rendLoopY:
		mov r3,#10
		rendLoopX:
			;ldr r5,[r11],#4
			;ldr r6,[r10],#4
			;eor r5,r5,r6,LSL #1
			;str r5,[r1],#4

			ldmia r11!,{r2,r5-r7}
			ldmia r10!,{r8,r9,r12,r13}
			eor r2,r2,r8,LSL #1
			eor r5,r5,r9,LSL r14
			eor r6,r6,r12,LSL #1
			eor r7,r7,r13,LSL r14
			stmia r1!,{r2,r5-r7}

		subs r3,r3,#1
		bne rendLoopX
		add r10,r10,#160
		add r11,r11,#160
	subs r4,r4,#1
	bne rendLoopY


nextframe:

	mov r0,#OSByte_Vsync
	swi OS_Byte

	swi OS_ReadEscapeState
	bcc main_loop

	swi OS_Exit

screen_addr_input:
	.long VD_ScreenStart, -1

;nframe:
;	.long 0

sines:

