
;"Hole #11 enigma"
;ZX Spectrum 48K, tiny 8b intro
;code - .ded^RMDA

;10.02.2023, Samara, Russia

;---[Some tech info]--------------------------------------------
;4b - FX pattern init
;4b - selfmode loop
;
;---[How to build]----------------------------------------------
;in SjASMplus https://github.com/z00m128/sjasmplus
;sjasmplus.exe hole11.asm

	DEVICE	ZXSPECTRUM48

	org	#8003-9

begin:	equ	$

;-------debug only init----------------------------------------
	di			;!!! this works without DI also
	ld	a,7		;!!! for debuging
	out	(#fe),a		;!!! for debuging
;-------8 bytes option ----------------------------------------
hole11:
;	ld	d,0	;d=27 e=4 ;d=32 e=4 ; d=63 e=4 ;d=92 e=4
;	ld	e,4*2

	ld	de,4*2		;4 * non parity for #8003
;	ld	de,#005b	;party version with dramatic action	

;-------7 bytes option-----------------------------------------
;	ld	e,4*1	;1,13,15,23,27,35,41,43,57 - flip inc/dec (hl)
			;2,3
			;32,48
			;37,39
			;64
;-------5 bytes option-----------------------------------------
	ld	l,e

;-------4 bytes main loop--------------------------------------
	org	#8003	;use non-parity ORG XX01 to unlock SHIFT 8

	add	hl,de	;#19
	inc	(hl)	;#34,#35 - #34 works fine and may be but inside oppcode
	jr	$-2
fin:
;-------BASIC--------------------------------------
;0001 CLS : LIST : PAUSE 1337
;0002 LET ded=PEEK (23672)
;0003 REM INPUT ded
;0004 REM LET ded=40  : REM 91
;0005 LET RMDA=32767
;0006 REM .......................
;0007 REM
;0011 POKE RMDA+0,017 :REM LD DE
;0022 POKE RMDA+1,ded :REM E=RND
;0033 POKE RMDA+2,000 :REM D=0
;0044 POKE RMDA+3,107 :REM L,E
;0055 POKE RMDA+4,025 :REM HL+DE
;0066 POKE RMDA+5,052 :REM INC(H
;0077 POKE RMDA+6,024 :REM JR$-2
;0088 POKE RMDA+7,252 :REM
;0099 REM
;0128 REM .......................
;0256 REM
;0512 REM ....Hole #11 enigma....
;0768 REM .4.8.12.52.60.85.92.203
;1024 REM - My God, It's Full of
;2048 RUN USR RMDA
;-----comment this for Pasmo or uncomment for SjAsm-------------
	SAVESNA	"hole11.sna", begin
	SAVEBIN	"hole11.bin", hole11,8
;	EMPTYTRD"hole11.trd","Hole17"
;	SAVETRD	"hole11.trd","enigma.C",begin,fin-begin
;	EMPTYTAP"hole11.tap"
;	SAVETAP	"hole11.tap",CODE,"enigma",begin,fin-begin
;-------=RMDA=---------------------------------------------[eof]