-- title: Omnisnake
-- author: Wojciech Graj
-- desc: Lovebyte 2023 Nano Game Highend submission
-- website: https://github.com/wojciech-graj/lovebyte2023
-- license: BSL-1.0 License
-- script: lua

--          Copyright Wojciech Graj 2022-2023.
-- Distributed under the Boost Software License, Version 1.0.
--    (See accompanying file LICENSE or copy at
--          https://www.boost.org/LICENSE_1_0.txt)

--{
angle = 0
cls()
posx = 0
posy = 0
t = 0
goalx = 0
goaly = 0
level = 9
--}

-- Set palette
for i = 0, 47 do
   poke(16320 + i, (i % 3 - 1) * i * 5)
end

function TIC()
   -- Process input
   angle = angle - (btn(2) and .1 or 0) + (btn(3) and .1 or 0)
   --{
   t = t + 1
   -- Move snake head
   posx = posx + math.sin(angle + 1.6)
   posy = posy + math.sin(angle)
   pix(goalx, goaly, 0)
   --}

   -- Check if close to goal
   if (posx - goalx) ^ 2 < 9 and (posy - goaly) ^ 2 < 9 then
      -- Move goal and increase level
      --{
      goalx = 80 * math.sin(t) + 98
      goaly = 50 * math.sin(t + 1.6) + 68
      level = level + 5
      --}
   end

   -- Check if game should end
   if ((pix(posx, posy) > 0 and pix(posx, posy) < 14)
      or posx < 0 or posy < 0 or posx > 239 or posy > 135) then
      exit()
   end

   -- Draw snake head and goal
   --{
   pix(goalx, goaly, t % 15)
   pix(posx, posy, 15)
   --}

   -- Fade snake pixels
   for i = 0, 32640 do
      poke4(i, (t % level == 0 and peek4(i) > 0) and peek4(i) - 1 or peek4(i))
   end
end
