//------------------------------------
// "maze #96"
// 256b game
// by wacek of arise
//------------------------------------ 

.var out 	  = $a0	// +$a1
.var tempx 	  = $a2
.var counter  = $a3
.var counter2 = $a4

			* = $1000
			
start:		sei
			
			jsr $e544
			
			lda #$04
			sta out
			sta out + 1
			sta counter
			sta counter2
			
!bloop:		ldx #0

!loop:		stx tempx
			ldx counter2
			lda #$00
			sta $0efc,x
			lda $a000,x
			and #$07
			jsr draw_square
			
			lda out
			adc #2
			sta out
			bcc !skip+				

			clc							
			inc out+1				
							
!skip:		ldx tempx
			inc counter2
			inx							
			cpx #12							
			bne !loop-							

			clc
			lda out
			adc #56
			sta out
			bcc !skip+
			
			clc
			inc out+1
			 	
!skip:		inc counter				
			lda counter				
			cmp #17				
			bne !bloop-				

			// setup sprites
			
			inc $d015

			lda #24
			sta $0f00
			sta $0f09
			lda #60
			sta $0f03
			sta $0f06
			sta $07f8

			// game loop
			
main_loop:	bit $d011
			bpl *-3
			bit $d011
			bmi *-3
			
			lda $dc00

			clc
			ror
			bcs !skip+
			dec $d001
			
!skip:		ror
			bcs !skip+
			inc $d001
			
!skip:		ror
			bcs !skip+
			dec $d000
			
!skip:		ror
			bcs !skip+
			inc $d000
			
!skip:		lda $d01f
			beq !skip+

main_reset_ball:
			jsr reset_ball

!skip:		lda $d001
			cmp #$2e
			beq main_reset_ball
			cmp #$f9
			beq main_reset_ball

			lda $d000
			cmp #$12
			beq main_reset_ball
			cmp #$ff
			bne main_loop
			
			// you win!

			ldx #8
!loop:		lda mazes - 5,x
			sta $05fd,x
			dex
			bne !loop- 
			jmp *

//------------------------------------ 
// subroutines 
//------------------------------------ 

copy_char:	inx
			iny
copy_char2:	lda mazes,x
			sta (out),y
copy_char_rts:			
			rts

draw_square:
			// a = square
			// 0 = skip

			beq copy_char_rts
			
			ldy #0
			clc
			rol
			rol
			tax
			jsr copy_char2
			jsr copy_char

			tya
			adc #38
			tay
			jsr copy_char
			jsr copy_char

reset_ball:	lda #55
			sta $d000
			sta $d001
			rts

//------------------------------------ 
// data 
//------------------------------------ 

			.text "you "			
mazes:		.text "win!"			
			
			// square #1
			.import binary "assets\mazes2.bin", 2,2
			.import binary "assets\mazes2.bin",42,2
			
			// square #2
			.import binary "assets\mazes2.bin", 4,2
			.import binary "assets\mazes2.bin",44,2
			
			// square #3
			.import binary "assets\mazes2.bin", 6,2
			.import binary "assets\mazes2.bin",46,2

			// square #4
			.import binary "assets\mazes2.bin", 80,2
			.import binary "assets\mazes2.bin",120,2
			
			// square #5
			.import binary "assets\mazes2.bin", 82,2
			.import binary "assets\mazes2.bin",122,2
			
			// square #6
			.import binary "assets\mazes2.bin", 84,2
			.import binary "assets\mazes2.bin",124,2
			
			// square #7
			.import binary "assets\mazes2.bin", 86,2
			.import binary "assets\mazes2.bin",126,2
			
//------------------------------------ 
// all ends here.
//------------------------------------ 