const AUDIO_URL = 'glxblt_-_super_blekare.mp3';
const AUDIO_START_TIME = 0;
const BPM = 174;
const SECONDS_PER_BEAT = 60 / BPM;

const SWEETIE16 = [
    0x1a1c2c, 0x5d275d, 0xb13e53, 0xef7d57, 0xffcd75, 0xa7f070, 0x38b764, 0x257179,
    0x29366f, 0x3b5dc9, 0x41a6f6, 0x73eff7, 0xf4f4f4, 0x94b0c2, 0x566c86, 0x333c57,
];

const CREDITS = [
    [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0],
    [1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1],
    [0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1, 0, 1],
    [0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1],
    [1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1],
    [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ,0, 0, 0, 0, 0],
    [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0],
    [1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0],
    [0, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 1, 1],
    [0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0],
    [1, 1, 0, 0, 0, 1, 1, 0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1],
    [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
];

let canvas, ctx, audioContext, audioSource, imageData, pixPtr;
let audioStartTimestamp;  // subtract this from audioContext.currentTime to get current audio position
let palette = SWEETIE16;

let lifeWorld = [];
for (let y = 0; y < 256; y++) {
    lifeWorld[y] = [];
    for (let x = 0; x < 256; x++) {
        lifeWorld[y][x] = Math.random() > 0.5 ? 1 : 0;
    }
}

const runLifeGeneration = () => {
    let newWorld = [];
    for (let y = 0; y < 256; y++) {
        newWorld[y] = [];
        for (let x = 0; x < 256; x++) {
            neighbours = (
                lifeWorld[(y+255) % 256][(x+255)%256]
                + lifeWorld[(y+255) % 256][x]
                + lifeWorld[(y+255) % 256][(x+1)%256]
                + lifeWorld[y][(x+255)%256]
                + lifeWorld[y][(x+1)%256]
                + lifeWorld[(y+1) % 256][(x+255)%256]
                + lifeWorld[(y+1) % 256][x]
                + lifeWorld[(y+1) % 256][(x+1)%256]
            )
            if (neighbours == 3) {
                newWorld[y][x] = 1;
            } else if (neighbours == 2) {
                newWorld[y][x] = lifeWorld[y][x];
            } else {
                newWorld[y][x] = 0;
            }
        }
    }
    lifeWorld = newWorld;
}

const pix = (x, y, c) => {
    const rgb = palette[c&15];
    const addr = y*320*4+x*4;
    imageData.data[addr] = rgb >> 16;
    imageData.data[addr + 1] = (rgb >> 8) & 0xff;
    imageData.data[addr + 2] = rgb & 0xff;
    imageData.data[addr + 3] = 0xff;
}
const nextPix = (c) => {
    const rgb = palette[c&15];
    imageData.data[pixPtr++] = rgb >> 16;
    imageData.data[pixPtr++] = (rgb >> 8) & 0xff;
    imageData.data[pixPtr++] = rgb & 0xff;
    imageData.data[pixPtr++] = 0xff;
}

let nextLifeBeat = 96 * 4;

const normVec = (v) => {
    const len = Math.sqrt(v[0]*v[0]+v[1]*v[1]+v[2]*v[2]);
    return [v[0]/len, v[1]/len, v[2]/len];
}
const crossProduct = (v1, v2) => {
    return [
        v1[1]*v2[2] - v1[2]*v2[1],
        v1[2]*v2[0] - v1[0]*v2[2],
        v1[0]*v2[1] - v1[1]*v2[0],
    ]
}

const frame = () => {
    imageData = ctx.createImageData(320,240);
    pixPtr = 0;

    const t = (audioContext.currentTime - audioStartTimestamp);
    const beat = t / SECONDS_PER_BEAT;
    const subbeat = beat * 4;

    if (beat < 64) {
        // plasma

        if (beat < 63) {
            palette = SWEETIE16;
        } else {
            const brightness = beat - 63;
            palette = [];
            for (let i = 0; i < 16; i++) {
                const orig = SWEETIE16[i];
                palette[i] = (
                    (((orig >> 16) * (1-brightness) + 255 * brightness) << 16)
                    + ((((orig >> 8) & 0xff) * (1-brightness) + 255 * brightness) << 8)
                    + ((orig & 0xff) * (1-brightness) + 255 * brightness)
                );
            }
        }

        let siren;
        if (t < 8.3) {
            siren = 0;
        } else {
            siren = Math.sin(t - 8.3) * 2;
        }
        const tp = Math.sin(t/3)/2;
        let rippleStrength;
        if (t < 11.05) {
            rippleStrength = 0;
        } else if (t < 11.45) {
            rippleStrength = (t - 11.05) * 2.5 * 20;
        } else {
            rippleStrength = 20 - (t - 11.45)
        }
        let portalT = Math.max(0, t - 19);
        for (let sy = 0; sy < 240; sy++) {
            for (let sx = 0; sx < 320; sx++) {
                let cx = sx - 200; let cy = sy - 160;
                let r = Math.sqrt(cx*cx+cy*cy);
                const a = Math.atan2(cx, cy);
                r = r + rippleStrength * (1 + Math.sin(r / 20 - t*5));  // add ripple
                r = Math.pow((r / 50), 1/(1+portalT*5)) * 50;

                cx = r * Math.sin(a) / (1 + portalT*portalT);
                cy = r * Math.cos(a) / (1 + portalT*portalT);
                const x = cx + 200; const y = cy + 160;

                nextPix(
                    Math.sin(x / (5+tp)) + Math.sin(x / 6) + Math.sin((x+y/8) / 5) + Math.sin((x+y/8) / 6)
                    + siren
                    + (t > 11.05 && (x&1) - (y&1))
                );
            }
        }
    } else if (beat < 128 || (beat >= 136 && beat < 192)) {
        // life
        palette = SWEETIE16;
        while (subbeat >= nextLifeBeat) {
            if ([1,0,1,0,1,0,1,1][nextLifeBeat % 8]) {
                runLifeGeneration();
            }
            nextLifeBeat += 1;
        }

        // rotozoomer
        /*
        for (let sy = 0; sy < 240; sy++) {
            for (let sx = 0; sx < 320; sx++) {
                const x = sx/8 * Math.cos(t) + sy/8 * Math.sin(t);
                const y = sy/8 * Math.cos(t) - sx/8 * Math.sin(t);
                const fx = x * 8 & 7;
                const fy = y * 8 & 7;
                if (fx == 0 || fy == 0) {
                    nextPix(0);
                } else {
                    nextPix(lifeWorld[y&255][x&255] ? 2 : 0);
                }
            }
        }
        */
        const fov = Math.tan(Math.PI / 4);

        let camera, lookAt, up;
        let upperPlane = 0;
        let lowerPlane = 0;
        let glitchStrength = 0;

        if (beat < 80) {
            camera = [0, 5 + (beat-64), 0 + t*20];
            lookAt = [1, 0, 20 + t*20];
            up = [0, 1, 0];
        } else if (beat < 112) {
            camera = [0, 5, 0 + t*20];
            lookAt = [10, 0, 20 + t*20];
            up = [0, 1, 0];
        } else if (beat < 136) {
            const twist = Math.max(0, beat - 120);
            camera = [0, 5 - twist * 2, 0 + t*20];
            lookAt = [-10 + twist * 2, 0, 20 + t*20];
            up = [0, 1, 0];
        } else if (beat < 160) {
            camera = [0, 6, 0 + t*20];
            lookAt = [4, 0, 10 + t*20];
            up = [0, 1, 0];
            const beatStrength = Math.pow(1 - (beat % 8) / 8, 8);
            upperPlane = 10 - beatStrength * 10;
            lowerPlane = 10;
        } else {
            camera = [2, 6 - (beat-160), 0 + t*20];
            lookAt = [4, 0, 10 + t*20];
            up = [1, 0, 0];
            const beatStrength = Math.pow(1 - (beat % 8) / 8, 8);
            upperPlane = 10 - beatStrength * 10;
            lowerPlane = 10;
            const offbeat = ((beat + 4) % 8) / 8;
            glitchStrength = Math.max(0, 1 - offbeat);
        }

        const lookVec = normVec([
            lookAt[0] - camera[0],
            lookAt[1] - camera[1],
            lookAt[2] - camera[2],
        ])
        const upVec = normVec([
            up[0] - camera[0],
            up[1] - camera[1],
            up[2] - camera[2],
        ])
        const camXVec = normVec(crossProduct(lookVec, upVec));
        const camYVec = normVec(crossProduct(lookVec, camXVec));

        for (let sy = 0; sy < 240; sy++) {
            for (let sx = 0; sx < 320; sx++) {
                const cx = (sx - 160) / 160;
                const cy = (120 - sy) / 160;
                const camVec = [
                    lookVec[0] + cx * fov * camXVec[0] + cy * fov * camYVec[0],
                    lookVec[1] + cx * fov * camXVec[1] + cy * fov * camYVec[1],
                    lookVec[2] + cx * fov * camXVec[2] + cy * fov * camYVec[2],
                ]
                // equation of camera line is camera + i * camVec;
                // this crosses the Y plane at
                // 0 = camera[1] + i * camVec[1]
                // i = -camera[1] / camVec[1]

                // and crosses an arbitrary Y plane at
                // y = camera[1] + i * camVec[1]
                // i = (y - camera[1]) / camVec[1]
                let i, x, y;
                if (Math.abs(camVec[1]) < 0.00001) {
                    nextPix(0);
                } else {
                    const iUpper = upperPlane - camera[1] / camVec[1];
                    const iLower = lowerPlane - camera[1] / camVec[1];

                    let xUpper = camera[0] + iUpper * camVec[0];
                    xUpper += glitchStrength * (10000 * (1 + Math.sin(xUpper)) % 2);
                    const yUpper = camera[2] + iUpper * camVec[2];
                    const fxUpper = (xUpper+100) * 8 & 7;
                    const fyUpper = (yUpper+100) * 8 & 7;
    
                    let xLower = camera[0] + iLower * camVec[0];
                    xLower += glitchStrength * (10000 * (1 + Math.sin(xLower)) % 2);
                    const yLower = camera[2] + iLower * camVec[2];
                    const fxLower = (xLower+100) * 8 & 7;
                    const fyLower = (yLower+100) * 8 & 7;

                    const useUpper = (
                        iUpper > 0 && fxUpper != 0 && fyUpper != 0
                        && lifeWorld[yUpper&255][xUpper&255]
                        // && ((xUpper & 1) == (yUpper & 1))
                    );

                    const useLower = (
                        iLower > 0 && fxLower != 0 && fyLower != 0
                        && lifeWorld[yLower&255][xLower&255]
                        // && ((xLower & 1) != (yLower & 1))
                    );

                    let result = 0;
                    if (useUpper) {
                        result = 2;
                    } else if (useLower) {
                        result = 1;
                    }

                    nextPix(result);
                }
            }
        }
    } else if (beat < 136) {
        // life tunnel
        palette = SWEETIE16;
        while (subbeat >= nextLifeBeat) {
            runLifeGeneration();
            nextLifeBeat += 0.5;
        }

        for (let sy = 0; sy < 240; sy++) {
            for (let sx = 0; sx < 320; sx++) {
                const cx = (sx - 160) / 160;
                const cy = (120 - sy) / 160;
                const r = Math.sqrt(cx*cx+cy*cy);
                const a = Math.atan2(cx, cy);

                const x = Math.pow(beat-128, 2) + a * 64 / Math.PI;
                const y = Math.pow(beat-128, 2.5) * 4 + 64 / r;

                const fx = (x+100) * 8 & 7;
                const fy = (y+100) * 8 & 7;
                if (fx == 0 || fy == 0) {
                    nextPix(0);
                } else {
                    nextPix(lifeWorld[y&255][x&255] ? 9 : 0);
                }
            }
        }
    } else if (beat < 200) {
        // black screen
        palette = SWEETIE16;
        for (let sy = 0; sy < 240; sy++) {
            for (let sx = 0; sx < 320; sx++) {
                nextPix(0);
            }
        }
    } else {
        // credits
        palette = [SWEETIE16[0], 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
        const orig = SWEETIE16[2];
        const origR = orig >> 16;
        const origG = (orig >> 8) & 0xff;
        const origB = orig & 0xff;
        const saturation = 0.7 - (Math.cos((beat - 200) / 2) / 4);
        palette[2] = (
            (((origR * saturation) & 0xff) << 16)
            + (((origG * saturation) & 0xff) << 8)
            + (((origB * saturation) & 0xff) << 0)
        );
        for (let sy = 0; sy < 240; sy++) {
            for (let sx = 0; sx < 320; sx++) {

                let cx = sx - 160; let cy = sy - 120;
                let r = Math.sqrt(cx*cx+cy*cy);
                const a = Math.atan2(cx, cy);
                r = r + 10 * (1 + Math.sin(r / 20 - t*5));  // add ripple

                cx = r * Math.sin(a) + 150;
                cy = r * Math.cos(a) + 100;

                let x = cx * 25 / 320;
                let y = cy * 25 / 320;
                const fx = (x+100) * 8 & 7;
                const fy = (y+100) * 8 & 7;
                x = Math.floor(x);
                y = Math.floor(y);

                if (fx == 0 || fy == 0 || x < 0 || x > 22 || y < 0 || y > 13) {
                    nextPix(0);
                } else {
                    nextPix(CREDITS[y][x] ? 2 : 0);
                }
            }
        }
    }

    ctx.putImageData(imageData, 0, 0);
    window.requestAnimationFrame(frame);
}

const runDemo = () => {
    audioStartTimestamp = audioContext.currentTime - AUDIO_START_TIME;
    audioSource.start(0, AUDIO_START_TIME);
    window.requestAnimationFrame(frame);
}

document.addEventListener('DOMContentLoaded', () => {
    const button = document.querySelector('button');
    let audioDataBuffer;

    fetch(AUDIO_URL).then(response => response.arrayBuffer()).then(buf => {
        audioDataBuffer = buf;
        button.removeAttribute('disabled');
    })

    button.addEventListener('click', () => {
        document.body.removeChild(button);
        canvas = document.createElement('canvas');
        canvas.width = 320;
        canvas.height = 240;
        document.body.appendChild(canvas);
        canvas.style.height = window.innerHeight + 'px';
        // with margin:
        // canvas.style.height = (window.innerHeight - 32) + 'px';
        // canvas.style.marginTop = '16px';

        ctx = canvas.getContext('2d');

        const AudioContext = window.AudioContext || window.webkitAudioContext;
        audioContext = new AudioContext({latencyHint: 'playback'});
        audioContext.decodeAudioData(audioDataBuffer).then(audioBuffer => {
            audioSource = audioContext.createBufferSource();
            audioSource.buffer = audioBuffer;
            audioSource.connect(audioContext.destination);
            runDemo();
        })
    })
});
