#version 330

varying vec2 UV;
varying vec4 Color;
uniform sampler2D texture2d;
uniform sampler2D texture2ddepth;
uniform sampler2D textureText;
uniform float ttime;
uniform float beat;
uniform float fftbeat;
uniform float k0;
vec2 _UV;
float aspect = 16.0 / 9.0;
float Speed = -10.0; // Speed : (speed), min=-1000.0, max=1000.0
float Density = 1.0; // Density : (density), min=0.0, max=10.0
float Brightness = 1.0; // Brightness : (brightness) min=0.0, max=10.0
float Seed = 6.5; // Seed : (seed), min=3.0, max=100.0

uniform sampler2D fft;


float rand(float n) { return fract(sin(n) * 43758.5453123); }

const float tau = 6.28318530717958647692;

// Gamma correction
#define GAMMA (2.2)

vec3 ToLinear( in vec3 col )
{
	// simulate a monitor, converting colour values into light values
	return pow( col, vec3(GAMMA) );
}

vec3 ToGamma( in vec3 col )
{
	// convert back into colour values, so the correct light will come out of the monitor
	return pow( col, vec3(1.0/GAMMA) );
}

vec4 Noise( vec2 p )
{
	 p = vec2(dot(p, vec2(127.1, 311.7)), dot(p, vec2(269.5, 183.3)));
	return p.xyxy;

}




void Starfield ( out vec4 fragColor, in vec2 fragCoord )
{
	vec3 ray;
	ray.xy = 1.0*(fragCoord.xy-vec2 (1920.0,1080.0).xy*.5)/1920.0;
	ray.z = 1.0;

	float offset = ttime*1.5*2.1;	
	float speed2 = 1.; //(cos(offset)+1.0)*2.0;
	float speed = speed2+.0;
	offset += 0.0;
	offset *= 1.0;
	
	
	vec3 col = vec3(0);
	
	vec3 stp = ray/max(abs(ray.x),abs(ray.y));
	
	vec3 pos = 2.0*stp+.5;
	for ( int i=0; i < 10;i++ )
	{
		float z = Noise(vec2(pos.xy*0.4)).x*0.01;
		z = fract(z-offset);
		float d = 20.0*z-pos.z;
		float w = pow(max(0.0,1.0-8.0*length(fract(pos.xy)-.5)),2.0);
		vec3 c = max(vec3(0),vec3(1.0-abs(d+speed2*.5)/speed,1.0-abs(d)/speed,1.0-abs(d-speed2*.5)/speed));
		col += 1.5*(1.0-z)*c*w;
		pos += stp;
	}
	
	fragColor =4.0*vec4(ToGamma(col),1.0);
}














vec3 hsv2rgb(in vec3 c)
{
	vec3 rgb = clamp(abs(mod(c.x * 6.0 + vec3(0.0, 4.0, 2.0), 6.0) - 3.0) - 1.0, 0.0, 1.0);

	return c.z * mix(vec3(1.0), rgb, c.y);
}

vec2 Qhash(vec2 p) {
	p = vec2(dot(p, vec2(127.1, 311.7)), dot(p, vec2(269.5, 183.3)));
	return -1.0 + 2.0 * fract(sin(p) * 43758.5453123);
}

float Qnoise(in vec2 p) {
	const float K1 = 0.366025404; // (sqrt(3)-1)/2;
	const float K2 = 0.211324865; // (3-sqrt(3))/6;
	vec2 i = floor(p + (p.x + p.y) * K1);
	vec2 a = p - i + (i.x + i.y) * K2;
	vec2 o = (a.x > a.y) ? vec2(1.0, 0.0) : vec2(0.0, 1.0); //vec2 of = 0.5 + 0.5*vec2(sign(a.x-a.y), sign(a.y-a.x));
	vec2 b = a - o + K2;
	vec2 c = a - 1.0 + 2.0 * K2;
	vec3 h = max(0.5 - vec3(dot(a, a), dot(b, b), dot(c, c)), 0.0);
	vec3 n = h * h * h * h * vec3(dot(a, Qhash(i + 0.0)), dot(b, Qhash(i + o)), dot(c, Qhash(i + 1.0)));
	return dot(n, vec3(70.0));
}


float hash(float n)
{
	return fract(sin(n) * 43758.5453);
}


float noise2(float p) {
	float fl = floor(p);
	float fc = fract(p);
	return mix(rand(fl), rand(fl + 1.0), fc);
}

#define GOLDEN_ANGLE 2.39996

#define ITERATIONS 192
#define BOKEH_SIZE 1.6


mat2 rot = mat2(cos(GOLDEN_ANGLE), sin(GOLDEN_ANGLE), -sin(GOLDEN_ANGLE), cos(GOLDEN_ANGLE));

//-------------------------------------------------------------------------------------------
#define W0 0.5545497
#define W1 0.308517


float noise(in vec3 x)
{
	vec3 p = floor(x);
	vec3 f = fract(x);

	f = f * f * (3.0 - 2.0 * f);

	float n = p.x + p.y * 57.0 + 113.0 * p.z;

	float res = mix(mix(mix(hash(n + 0.0), hash(n + 1.0), f.x),
		mix(hash(n + 57.0), hash(n + 58.0), f.x), f.y),
		mix(mix(hash(n + 113.0), hash(n + 114.0), f.x),
			mix(hash(n + 170.0), hash(n + 171.0), f.x), f.y), f.z);
	return res;
}

float speed = 10.0;
float blockSize = 64.0 * 0.2;
float maxRGBSplitX = 32.0 * 0.1 * fftbeat * 10.0;
float maxRGBSplitY = 32.0 * 0.1 * fftbeat * 10.0;

float randomNoise(vec2 seed) {
	return fract(sin(dot(seed * floor(ttime * speed), vec2(17.13, 3.71))) * 43758.5453);
}

float randomNoise2(float seed) {
	return randomNoise(vec2(seed, 1.0));
}




vec4 Split(vec2 __UV)
{
	// Normalized pixel coordinates (from 0 to 1)
	vec2 uv = __UV;
	float dispPower = 1.0 - clamp((ttime - 4.0) * 0.2, 0.0, 1.0);
	dispPower = clamp((ttime - 18.0) * 0.2, 0.0, 1.0);
	dispPower = clamp((ttime - 1.0) * 0.05, 0.0, 1.0);
	dispPower *= 1.0;
	float block = randomNoise(floor(uv * vec2(blockSize * 1.0, 0.7 * blockSize)));

	float displaceNoise = pow(block, 8.0) * pow(block, 3.0);
	float splitRGBNoise = pow(randomNoise2(7.2341), 17.0);
	float offsetX = displaceNoise - splitRGBNoise * maxRGBSplitX;
	float offsetY = displaceNoise - splitRGBNoise * maxRGBSplitY;

	float noiseX = 0.05 * randomNoise2(13.0);
	float noiseY = 0.05 * randomNoise2(7.0);
	vec2 offset = vec2(offsetX * noiseX, offsetY * noiseY);
	//	offset*=0.0;
	uv.x += displaceNoise * 0.02 * dispPower;
	offset *= dispPower;
	vec4 colorR = texture(texture2d, uv);
	vec4 colorG = texture(texture2d, uv + offset);
	vec4 colorB = texture(texture2d, uv - offset);
	colorR *= vec4(1.0, 0.5, 0.0, 1);
	colorG *= vec4(0, 0.5, 0, 1);
	colorB *= vec4(0., 0, 1.0, 1);

	//if( displaceNoise>0.501+1.0-dispPower) 	colorB*=3.0;


	return colorR + colorG + colorB;

}







float randomNoise(float seed) {
	return randomNoise(vec2(seed, 1.0));
}


float fbm(vec3 p)
{
	float f;
	f = 0.5000 * noise(p); p = p * 2.02;
	f += 0.2500 * noise(p); p = p * 2.03;
	f += 0.1250 * noise(p);
	return f;
}

float hash2(in vec2 c)
{
	float x = c.x * fract(c.x * W0);
	float y = c.y * fract(c.y * W1);

	// NOTICE: as is - if a sampling an integer lattice
	// any zero input will cause a black line in that
	// direction. 
	return fract(x * y);
}



float Star(vec3 p) {
	Brightness = 1.5;
	vec3 pos = p;
	p += vec3(1.35, 1.54, 1.23);
	p *= .3;
	for (int i = 0; i < 18; i++) {
		p.xyz = abs(p.xyz);
		p = p / dot(p, p);
		p = p * 1. - vec3(.9 * Seed * 0.1);
	}
	return 1.0 * clamp(pow(length(p), 1.3 * Brightness) * .004 * (Density + 0.75), 0.0, 10.0);
}

float Stars(vec3 p) {
	float coun = 0.0;
	float f = 0.0;
	for (int x = -1; x < 2; x++)
		for (int y = -1; y < 2; y++)
		{
			coun++;
			f += Star(p + vec3(x, y, 0) * 0.0008);
		}
	f /= coun;


	f += (1.0 - _UV.y) * 0.4 * fbm(p * 0.7 + vec3(0, 0, 0.1 * ttime));
	//f*=0.0;
	return f;
};



vec3 Bokeh(sampler2D tex, vec2 uv, float radius, vec2 fragCoord)
{
	vec3 acc = vec3(0), div = acc;
	float r = 1.;
	float _ITERATIONS = ITERATIONS;

	vec2 vangle = vec2(0.0, radius * .01 / sqrt(float(_ITERATIONS)));

	// rotate the initial vangle with time
	float t = hash2(fragCoord) / 8. + ttime * 100.0;
	mat2 rot2 = mat2(cos(t), sin(t), -sin(t), cos(t));
	vangle = rot2 * vangle;

	for (int j = 0; j < ITERATIONS; j++)
	{
		// the approx increase in the scale of sqrt(0, 1, 2, 3...)
		r += 1. / r;
		vangle = rot * vangle;
		//if (uv.y<0.015)		vangle*=0.5;










		vec2 _UV2 = uv + (r - 1.) * vangle * vec2(1.0, aspect);


		//		vec3 col = texture(tex, clamp (uv + (r-1.) * vangle*vec2 (1.0,aspect),vec2 (0.0), vec2 (1.0))).xyz; /// ... Sample the image
		vec3 col = texture(tex, clamp(_UV2, vec2(0.0), vec2(1.0))).xyz; /// ... Sample the image
		vec2 Sep = vec2(0.0005, 0.0);

		//col *= vec3(1, 0.5, 0);
		//col += vec3(0, 0.5, 1) * texture(tex, clamp(_UV2 + Sep, vec2(0.0), vec2(1.0))).xyz; /// ... Sample the image
		/*
		if (_UV2.x < 0.0) col *= 0.0;
		if (_UV2.y < 0.0) col *= 0.0;
		if (_UV2.x > 1.0) col *= 0.0;
		if (_UV2.y > 0.99) col *= 0.0;

		*/

		//l = col * col *1.8; // ... Contrast it for better highlights - leave this out elsewhere.
		vec3 bokeh;
		bokeh = pow(col, vec3(2));
		acc += col * bokeh;
		div += bokeh;
	}
	return acc / div;
}




vec3 Smooth2(vec2 _UV0) {

	//depth-1-depth;
	vec3 Output = vec3(0.0);
	float tot = 0.0;
	float dstt = 1.0;

	for (int y = -14; y < 15; y++)
		for (int x = -14; x < 15; x++)
		{
			vec2 N_UV = _UV0 + vec2(float(x), float(y)) * vec2(9.0 / 16.0, 1.0) * 0.00200 * 1.7 * dstt;
			N_UV.x=clamp (N_UV.x,0.01,0.99);
			N_UV.y=clamp (N_UV.y,0.01,0.99);
			float dst = 1.0 / (1.0 + 13.0 * length(vec2(x, y)) * length(vec2(x, y)));
			Output += pow(1.0 * texture2D(texture2d, N_UV).xyz, vec3(1.0)) * dst;
			//*texture2D (Texture1, N_UV).w;
			//Output+=N_UV.xyx;
			tot += dst;

		}

	Output /= tot;
	Output=clamp (Output,vec3 (0.0), vec3 (1.0));
	return 4.0 * Output;//*0.2;


};



vec3 SmoothRadial(vec2 _UV0) {

	//depth-1-depth;
	vec3 Output = vec3(0.0);
	float tot = 0.0;
	float dstt = 1.0;
	vec2 DirV = _UV0 - vec2(0.5);
	vec3 DV = vec3(DirV, 0);
	vec3 UpV = vec3(0, 0, 1);
	vec3 RightV = cross(DV, UpV);
	//for (int y = -5; y < 6; y++)
	float fz=0.1;
	if (ttime>85) fz=1.0;
	for (int x = 0; x < 32; x++)
		for (int r = -4; r < 4; r++)
		{
			float dst = 1.0;
			vec2 N_UV = _UV0 - DirV * fz*0.25 * float(x) / 12.0;
			N_UV += RightV.xy * float(r) * 0.003;
			vec3 col = texture2D(texture2d, N_UV).xyz;
			dst = float(22 - x) / 22.0; //length (col);
			dst *= 1.0 + 3.0 * length(col);
			Output += dst * pow(col, vec3(1.0));
			//*texture2D (Texture1, N_UV).w;
			//Output+=N_UV.xyx;
			tot += dst;

		}

	Output /= tot;
	return Output * 0.3;


};


vec2 Barrel(vec2 _UV)
{
	vec2 iResolution = vec2(1920, 1080);
	vec2 fragCoord = _UV * iResolution;

	vec2 source_uv = fragCoord.xy / iResolution.xy;
	//assume your distortion center coordinate is (0.5,0.5),you can use your distortion center instead.
	vec2 distortion_center = vec2(0.5, 0.5);
	//Define algorithm dependent variables 
	float distortion_x, distortion_y, rr, r2, theta;
	//define distortion coefficient K1 and K2 ,In most cases we can only adjust K1. then K2 parameters can be adjusted more perfect Effect
	//iTime is used for Real-time change.
	//K1 < 0 is pincushion distortion
	//K1 >=0 is barrel distortion
	float distortion_k1 = -ttime * 0.1;
	float distortion_k2 = 0.5;
	vec2 dest_uv;
	rr = sqrt((source_uv.x - distortion_center.x) * (source_uv.x - distortion_center.x) + (source_uv.y - distortion_center.y) * (source_uv.y - distortion_center.y));
	r2 = rr * (1.0 + distortion_k1 * (rr * rr) + distortion_k2 * (rr * rr * rr * rr));
	theta = atan(source_uv.x - distortion_center.x, source_uv.y - distortion_center.y);
	distortion_x = sin(theta) * r2 * 1.0;//1.0 is  scale factor
	distortion_y = cos(theta) * r2 * 1.0;//1.0 is  scale factor
	dest_uv.x = distortion_x + 0.5;
	dest_uv.y = distortion_y + 0.5;
	return dest_uv;
}

vec4 Chromatic2(vec2 _UV)
{
	vec2 iResolution = vec2(1920, 1080);
	vec2 fragCoord = _UV * iResolution;

	vec3 refractiveIndex = vec3(1.0, 1.01, 1.02);
	vec2 uv = fragCoord.xy / iResolution.xy;
	vec2 normalizedTexCoord = vec2(2.0, 2.0) * uv - vec2(1.0, 1.0);    // [0, 1] -> [-1, 1]
	vec3 texVec = vec3(normalizedTexCoord, 1.0);
	vec3 normalVec = vec3(0.0, 0.0, -1.0);
	vec3 redRefractionVec = refract(texVec, normalVec, refractiveIndex.r);
	vec3 greenRefractionVec = refract(texVec, normalVec, refractiveIndex.g);
	vec3 blueRefractionVec = refract(texVec, normalVec, refractiveIndex.b);
	vec2 redTexCoord = ((redRefractionVec / redRefractionVec.z).xy + vec2(1.0, 1.0)) / vec2(2.0, 2.0);
	vec2 greenTexCoord = ((greenRefractionVec / greenRefractionVec.z).xy + vec2(1.0, 1.0)) / vec2(2.0, 2.0);
	vec2 blueTexCoord = ((blueRefractionVec / blueRefractionVec.z).xy + vec2(1.0, 1.0)) / vec2(2.0, 2.0);

	return vec4
	(
		texture(texture2d, redTexCoord).r,
		texture(texture2d, greenTexCoord).g,
		texture(texture2d, blueTexCoord).b,
		1.0
		);
}



vec4 Chromatic3(vec2 _UV)
{
	vec2 iResolution = vec2(1920, 1080);
	vec2 fragCoord = _UV * iResolution;

	vec3 refractiveIndex = vec3(1.0, 1.1, 1.2);
	vec2 uv = fragCoord.xy / iResolution.xy;
	vec2 normalizedTexCoord = vec2(2.0, 2.0) * uv - vec2(1.0, 1.0);    // [0, 1] -> [-1, 1]
	vec3 texVec = vec3(normalizedTexCoord, 1.0);
	vec3 normalVec = vec3(0.0, 0.0, -1.0);
	vec3 redRefractionVec = refract(texVec, normalVec, refractiveIndex.r);
	vec3 greenRefractionVec = refract(texVec, normalVec, refractiveIndex.g);
	vec3 blueRefractionVec = refract(texVec, normalVec, refractiveIndex.b);
	vec2 redTexCoord = ((redRefractionVec / redRefractionVec.z).xy + vec2(1.0, 1.0)) / vec2(2.0, 2.0);
	vec2 greenTexCoord = ((greenRefractionVec / greenRefractionVec.z).xy + vec2(1.0, 1.0)) / vec2(2.0, 2.0);
	vec2 blueTexCoord = ((blueRefractionVec / blueRefractionVec.z).xy + vec2(1.0, 1.0)) / vec2(2.0, 2.0);

	return vec4
	(
		texture(texture2d, redTexCoord).r,
		texture(texture2d, greenTexCoord).g,
		texture(texture2d, blueTexCoord).b,
		1.0
		);
}

vec4 Grain(vec2 uv) {

	float strength = 16.0;
	float x = (uv.x + 4.0) * (uv.y + 4.0) * (ttime * 10.0);
	vec4 grain = vec4(mod((mod(x, 13.0) + 1.0) * (mod(x, 123.0) + 1.0), 0.01) - 0.005) * strength;
	return 0.2 * grain;

};

void Distort2( out vec4 O, in vec2 _UV )
{
    vec2 R = vec2 (1920,1080),
        
         M= vec2 (1200,1200)*1.3, //*fftbeat,
         U =_UV,
         P = vec2(350., 350.*R.y/R.x),
         C = floor(U*P)/P;
    U -= C;
    U *= (M/R-.5)*14.0; // distortion based on mouse
    U += C;
    O = vec4(texture(texture2d, U).rgb,1.);
}


void Distort( out vec4 fragColor, in vec2 _UV )
{
    // normalized pixel coordinates (from 0 to 1)
    vec2 uv = _UV;
    float aspect = 16.0/9.0;
   	vec2 disorsion = uv-.5;
    
    disorsion.x*=aspect; // aspect correction
    
    // take distance from center
   	float len = length(disorsion);
    
    // these are the lens parameters
    float k1 = 1.2;
    float k2 = 1.0;
    float k3 = -3.2-fftbeat*1.0;
    
    disorsion 
        = disorsion*k1 
        + disorsion*len*k2 
        + disorsion*len*len*k3;
        // higher powers may be added if necessary
    
    
    disorsion.x/=aspect; // aspect correction
    
    vec4 col = texture(texture2d, disorsion+.5);
    

   
        float edge = 10.7;
        float dispersion = 1.03;
    	col *= vec4(
            pow(max(edge-len, 0.0), 0.2),
            pow(max(edge-dispersion-len, 0.0), 0.2),
            pow(max(edge-dispersion*2.0-len, 0.0), 0.2),
        1)*1.2;
    


    fragColor = col;
}

void main(void)
{	
float TheBeat=0.0;
_UV=UV;	
{
	float beat = sin(1.2 -0.2+ 3.1415926535 * 1.0 * 57.0 * (ttime+_UV.y*0.25) / 60.0);
	beat *= beat;
	//beat *= beat;

	beat=mod (beat,1.0);
	TheBeat=clamp (1.0-4000.0*beat*beat,0.0,1.0);
	//int BeatID = (-0.3 + ttime) * bpm / 60.0;
}

float TheBeat2=0.0;

{
	float beat = sin(1.3 -0.0+ 3.1415926535 * 1.0 * 57.0 * (ttime+_UV.y*0.02) / 60.0);
	beat *= beat;
	//beat *= beat;

	beat=mod (beat,1.0);
	
	//if (beat>0.8) TheBeat2=1.0;

	TheBeat2=clamp (1.0-10.0*beat*beat,0.0,1.0);
	//int BeatID = (-0.3 + ttime) * bpm / 60.0;
}


float TheBeat3=0.0;

{
	float beat = sin(1.3 -0.0+ 3.1415926535 * 1.0 * 57.0 * (ttime+_UV.y*0.02) / 60.0);
	beat *= beat;
	//beat *= beat;

	beat=mod (beat,1.0);
	
	//if (beat>0.8) TheBeat2=1.0;

	TheBeat3=clamp (1.0-4.0*beat*beat,0.0,1.0);
	//int BeatID = (-0.3 + ttime) * bpm / 60.0;
}

//_UV.x+=TheBeat*0.1;
	
	float distc = length((_UV.xy - vec2(0.5) - vec2(0.0, 0.0)) * vec2(16.0 / 9.0, 1.0));

	gl_FragData[0].xyz = texture(texture2d, _UV.xy).xyz * vec3(1, 1, 1);
	//gl_FragData[0].xyz = Chromatic2(_UV).xyz*3.0;
	gl_FragData[0].xyz = Split(_UV).xyz * fftbeat * 1500.0;
	if (ttime>67.9) 
	gl_FragData[0].xyz = Split(_UV).xyz * fftbeat * 1000.0;

		if (ttime < 33.8)
	gl_FragData[0].xyz*=vec3 (0.0)+vec3 (5.0)*pow (clamp (5.0*sin (-50.0*ttime+distc*1000.0),0.0,1.0),10.0);

		if (ttime >= 33.8)	
			gl_FragData[0].xyz*=vec3 (1.0)+vec3 (1.0)*pow (clamp (5.0*sin (-5.0*ttime+distc*1400.0),0.0,1.0),10.0);




//blur
	float fw=clamp (1.0-(ttime-64.0)*0.2,0.01,1.0);
	fw=0.3;
	if (ttime>50.5)
	fw=0.02;

	float fb=1.0;
	fb+=TheBeat2*1.0;

	fw+=TheBeat*1.0;

	vec3 TheBlur= Smooth2(_UV);

	if (ttime<67.9)
		gl_FragData[0].xyz += (0.1 + fftbeat) * 100.0*fw *TheBlur;
	else
		gl_FragData[0].xyz += (0.1 + fftbeat) * 3.0 * fb* TheBlur;


//	gl_FragData[0].xyz+=vec3 (1.0)*pow (clamp (5.0*sin (-5.0*ttime+distc*100.0),0.0,1.0),10.0);


		//	else
	//	gl_FragData[0].xyz += (0.005 + fftbeat) * 100.0 * Smooth2(_UV);


	gl_FragData[0].xyz = clamp(gl_FragData[0].xyz, vec3(0.0), vec3(1.0));

	//*texture (fft,vec2 (_UV.x,0.0)).x
	float ff = fbm(vec3(_UV.xy * 3.0 * vec2(16.0 / 9.0, 1.0), ttime));

	float fbb = texture(fft, vec2(0.0 + _UV.x * 1.0, 0.0)).x;
	fbb *= fbb * 250.0;
	fbb *= fbb;



	float antistar = clamp(10.0 * Smooth2(_UV).x, 0.0, 1.0);
	float inv = 1.0;

	if (ttime >= 16.850)
		if (_UV.y < 0.5) {
			antistar = 0.0;
			inv = -1.0;
		}

	if (ttime>67.9) 
		antistar=1.0;


	gl_FragData[0].xyz +=
		(1.0 - antistar) *

		clamp((ttime - 0.0) * 0.5, 0.0, 1.0) * 4.0 *
		0.15 * vec3(max(0.0, .2 * Stars(vec3(0, inv * -ttime * 0.09, 0) + vec3(0, 0, 0) +
			vec3(vec2(_UV.x, _UV.y) * 1.0, 0.1) * 2.2 * vec3(16.0 / 9.0, 1.0, 1.0))));


		
	//if (TheBeat>0.001)
	//gl_FragData[0].xyz+=vec3 (1.0*clamp (10.0*sin (_UV.y*500.0),0.0,1.0));

	//_FragData[0].xyz+=vec3 (1.0*(TheBeat)*clamp (10.0*sin (_UV.y*220.0),0.0,1.0));


	if (ttime >= 16.85)
		gl_FragData[0].xyz *= clamp((ttime - 16.85) * 0.5, 0.0, 1.0);

	if (ttime >= 33.8)
		gl_FragData[0].xyz *= clamp((ttime - 33.8) * 0.5, 0.0, 1.0);

	if (ttime >= 50.5)
		gl_FragData[0].xyz *= clamp((ttime - 50.5) * 0.5, 0.0, 1.0);


	if (ttime < 50.5)
		if (ttime > 33.8)
			if ((_UV.x < 0.25)
				|| (_UV.x > 0.75))
				gl_FragData[0].xyz *= 0.0;

	if (ttime < 33.8)
		if (distc > 0.6)
			gl_FragData[0].xyz *= 0.0;

	if (ttime > 28.0)
		if (ttime < 28.4)
			gl_FragData[0].xyz = Chromatic2(_UV).xyz * 13.0;

	if (ttime > 32.0)
		if (ttime < 32.7)
			gl_FragData[0].xyz = Chromatic2(_UV).xyz * 13.0;

if (ttime > 38.0)
		if (ttime < 38.3)
			gl_FragData[0].xyz = Chromatic2(_UV).xyz * 13.0;
	
	{

//		float fc=clamp ((ttime-66.7-distc*0.1)*1.8,0.0,1.0);
	float fc=0.0;
		if (ttime>67.9) { 
		fc=1.0-clamp ((ttime-67.7-distc*0.05-gl_FragData[0].x*1.0)*1.0,0.0,1.0);
		gl_FragData[0].xyz+=(vec3 (1.0)-gl_FragData[0].xyz)*fc;
		}

	}

	vec3 SMV= SmoothRadial(_UV);
	float sz=clamp ((ttime-64.0)*1.0,0.0,1.0);

	float fcol=1.0;
	if (ttime>84.5) fcol=0.1;

	if( ttime>64.8)
		if (ttime<70.0)
	gl_FragData[0].xyz*=100.0*hsv2rgb(vec3(gl_FragData[0].x*5.0+ttime, 1.0,5.0*gl_FragData[0].y));


	if (ttime<102.0) 
		if (ttime>89.1)
		{
		float fz=100-99.0*TheBeat2;
			gl_FragData[0].xyz*=100.0*hsv2rgb(vec3(fftbeat*5.0+gl_FragData[0].x*3.0+2.0*ttime, 1.0,
				TheBeat2*0.0+2.0+2.0*sin (_UV.x*1.0+ttime*5.0)+50.0*gl_FragData[0].y));
		
		}



	


		SMV.z+=fftbeat;
	//gl_FragData[0].xyz=1.0*clamp (gl_FragData[0].xyz,vec3 (0.0),vec3 (1.0));
//	gl_FragData[0].xyz+=sz*TheBeat2*200.0*hsv2rgb(vec3(SMV.x*fcol*20.0, 1.0,SMV.z));
	if (ttime<102.0)
	{
		gl_FragData[0].xyz+=sz*TheBeat2*20.0*hsv2rgb(vec3(sin (distc*0.5-ttime*2.0)+SMV.x*fcol*20.0, 1.0,SMV.z));
	}
	//if (0==1)
	if (ttime<130.3)
	if (ttime>102.0)
	{
		gl_FragData[0].xyz=sz*(0.1+TheBeat2)*80.0*
		hsv2rgb(vec3(sin (distc*3.0-ttime*2.0)+SMV.y*fcol*15.0, 1.0,gl_FragData[0].z));
		if (ttime<110.0)
		gl_FragData[0].xyz=
		hsv2rgb(vec3(TheBeat2,1.0,gl_FragData[0].x));


		if (ttime>118.5)
		gl_FragData[0].xyz=
		hsv2rgb(vec3(distc+TheBeat2*200.0+gl_FragData[0].y*0.05,5.0-TheBeat2*5.0,TheBeat2*0.1+4.0*pow (gl_FragData[0].x,5.0)));

	}

	bool whiteflash=false;

	if (ttime>67.9) if (ttime<73.0) whiteflash=true;
	if (ttime>93.0) whiteflash=true;
	if (ttime> 123.0) whiteflash=false;
	if (ttime> 139.3)
	if (ttime< 140.0)
		whiteflash=true;





	if (whiteflash)
			{
				vec4 OutDist;
				vec2 _UVV=_UV;
				//_UVV=vec2 (ivec2 (_UVV.xy*100.0))/100.0;
			 Distort( OutDist, vec2 (1.0-_UVV.x,_UVV.y));
			 //OutDist=pow (14.5*OutDist,vec4 (10.0));
			 
			 if (length (OutDist.xyz)>0.01) OutDist.xyz=vec3 (1.0); 
			 else
				 OutDist.xyz=vec3 (0.0);
			 if (fftbeat>0.07)
			 gl_FragData[0].xyz=vec3 (1.0)-50.0*OutDist.xyz;
			 if (ttime>100.0)
			 		gl_FragData[0].xyz=		hsv2rgb(vec3(0.5*sin (distc+0.3*ttime)+TheBeat2*200.0+gl_FragData[0].y*0.15,10.0-TheBeat2*10.0,TheBeat2*0.1+4.0*pow (gl_FragData[0].x,5.0)));

			}


	if (0==1)
	if (ttime<119.0)
	if (ttime>110.0)
	{
				vec4 OutDist;
				vec2 _UVV=_UV;
				//_UVV=vec2 (ivec2 (_UVV.xy*100.0))/100.0;
			 Distort2( OutDist, vec2 (_UVV.x,_UVV.y));
			 OutDist.xyz=pow (30.0*OutDist.xxx,vec3 (20.0));
		OutDist.xyz=		hsv2rgb(vec3(0.5*sin (distc+0.3*ttime)+TheBeat2*200.0+OutDist.y*0.015,10.0-TheBeat2*10.0,TheBeat2*0.5+4.0*pow (OutDist.x,5.0)));
		OutDist.xyz=clamp (OutDist.xyz,vec3 (0.0),vec3 (1.0));
		float fa=1.0-clamp ((ttime-130)*0.1,0.0,1.0);
			 //if (fftbeat>0.02)
			 gl_FragData[0].xyz+=fa*100.0*OutDist.xyz;
			
			}



	if (ttime>135.3) 
				if (distc > 0.6)
			gl_FragData[0].xyz *= 0.0;


			gl_FragData[0].xyz *= 1.0-clamp((ttime - 150.0) * 0.3, 0.0, 1.0);

			//gl_FragData[0].xyz += vec3 (k0);


	//gl_FragData[0].xyz+=Chromatic3(_UV).xyz;
	//gl_FragData[0].xyz=Chromatic3(_UV).xyz;

	//if (ttime>67.9) 	gl_FragData[0].xyz += vec3 (TheBeat2); //100.0*Chromatic2(_UV).xyz;
	/*
	if (!(
		(_UV.x>0.3) && (_UV.y>0.3) &&(_UV.x<0.7) &&(_UV.y<0.9)))
		gl_FragData[0].xyz*=0.0;
		*/
		/*
	float fz = fbm (vec3 (vec2 (ivec2 (_UV.xy*130.0))/130.0,ttime));
	if (fz<0.4)
		gl_FragData[0].xyz*=10.0;
		*/
			gl_FragData[0].xyz=clamp (gl_FragData[0].xyz,vec3 (0.0),vec3 (1.0));
			if (ttime<136.0)
			if (ttime>101.3)
			{
				//gl_FragData[0].xyz*=vec3 (1.0)+5.0*vec3 (clamp ((ttime-84.6)*0.3,0.0,1.0)*TheBeat);
				gl_FragData[0].xyz-=vec3 (1.0,1.0,1.0)*115.0*vec3 (clamp ((ttime-84.6)*0.3,0.0,1.0)*TheBeat);
		
				
			}

			if (ttime<65.3)
			if (ttime>68.0)
			{
				//if (ttime<86.9)
				gl_FragData[0].xyz+=vec3 (TheBeat2)*20.0*(TheBlur+vec3 (0.01)); //*vec3( 1,0,0); //5.0*gl_FragData[0].xxx*vec3 (TheBeat2); //*sin (distc*3000.0);
			}

			if (ttime<136.0)
			if (ttime>118.5)
			{
				if (ttime<125.0)
				gl_FragData[0].xyz+=vec3 (TheBeat2)*(2.0-5.0*gl_FragData[0].x);
				else
				gl_FragData[0].xyz+=vec3 (TheBeat2)*(1.0-5.0*gl_FragData[0].x);
				
				if (ttime>125.0)
				gl_FragData[0].xyz=		
			hsv2rgb(vec3(TheBeat+gl_FragData[0].x*1.5-0.1-distc*0.2,1.0-TheBeat2*10.0,gl_FragData[0].y));

			}



			if (ttime<88.7)
			if (ttime>83)
			{
				gl_FragData[0].xyz+=vec3 (TheBeat2)*(2.0-5.0*gl_FragData[0].x);
				
				gl_FragData[0].xyz=		
			hsv2rgb(vec3(TheBeat+gl_FragData[0].x*1.5-0.1-distc*0.2,1.0-TheBeat2*30.0,gl_FragData[0].y));

			}

			if (0==1)
			if (ttime>102.0)
				if (ttime<106.0)
			{
				float holes=10.0-500.0*fftbeat;
				if (sin (holes*UV.x*50.0)<-0.8)
		gl_FragData[0].xyz+=vec3 (1,0,0); //vec3 (1.0); ///0.0;
			}


				if (ttime>83.5)
				if (ttime<84.8)
			{
				float holes=10.0-500.0*fftbeat;
				if (sin (holes*UV.x*50.0)<-0.8)
		gl_FragData[0].xyz+=vec3 (1,0,0); //vec3 (1.0); ///0.0;
			}
				if (ttime<135.5)

				if (ttime>84.0)
				{
					fb = fbm(vec3(0.5, 0.5, 7.0 * ttime));
				if (distc<1.0*fb*(0.7+1.0*fftbeat))
				gl_FragData[0].xyz+=2.0*vec3 (TheBeat2)*vec3 (1,1,1);

				}

				if (TheBeat3>0.001)
				if (ttime<102.0)
				if (ttime>85.0)
				{
					vec4 starfield;
					Starfield ( starfield, UV.xy*vec2 (1920.0,1080.0));
					//if (distc>0.4) starfield*=0.0;
					starfield*=1.0-gl_FragData[0].x*100.0;
					starfield=clamp (starfield,vec4(0.0),vec4(1.0));
					
					gl_FragData[0].xyz+=TheBeat3*starfield.xyz*pow (1.4*distc,30.0);
					//*clamp (sin (						distc*100.0+UV.y+ttime*4.0),0.0,1.0);

				}


				//if (TheBeat>0.1)
				//gl_FragData[0].xyz=vec3(ivec3 (gl_FragData[0].xyz*2.0+vec3 (0.2)))/2.0;
			
			//gl_FragData[0].xyz = texture(texture2d2, UV.xy).xyz;
		
			//gl_FragData[0].xyz*=1.0+10.0*Grain(_UV).x;
		/*
			gl_FragData[0].xyz+=vec3 (1,0.2,0.2)*
			clamp ((ttime-0.0)*0.5,0.0,1.0)*10.2*
		 0.15*vec3(max(0.0, .2 * Stars(vec3(0, -ttime * 0.09, 0) + vec3(0, 0, 0) +
			vec3(vec2(_UV.x, _UV.y) * 1.0, 0.1) * 2.2 * vec3(16.0 / 9.0, 1.0, 1.0))));
			*/

			//gl_FragData[0].xyz*=1.0+(1.0-_UV.y)*fbb*1.0*100.0;

			//gl_FragData[0].xyz=texture (fft, vec2 (_UV.x,0.0)).xxx*10.0;

			//gl_FragData[0].x*=1.0+10.0*pow (beat,14.0);
			//gl_FragData[0].xyz+=SmoothRadial (_UV)*100.0; //pow (beat,14.0);
			//gl_FragData[0].xyz=Split (_UV).xyz*1.0;
		//	gl_FragData[0].xyz = texture(texture2d, _UV.xy).xyz * vec3(1, 1, 1);
			//gl_FragData[0].xyz =vec3 (fb);
			//gl_FragData[0].xyz=vec3 (1.0)*depth; // pow (texture (texture2ddepth,_UV.xy).x,100.0);
}
