#version 330

varying vec2 UV;
varying vec4 Color;
uniform sampler2D texture2d;
uniform sampler2D texture2d2;
uniform sampler2D textureText;
uniform float ttime;
uniform sampler2D Moon;
vec3 FinalNormal;
float fred2 = 0.0;
float RePosX = 0;
float RePosY = 0;
uniform float beat;
uniform float fftbeat;

uniform sampler2D fft;

vec3 hsv2rgb(in vec3 c)
{
	vec3 rgb = clamp(abs(mod(c.x * 6.0 + vec3(0.0, 4.0, 2.0), 6.0) - 3.0) - 1.0, 0.0, 1.0);

	return c.z * mix(vec3(1.0), rgb, c.y);
}


float qttime = ttime * 0.5;
vec2 iResolution = vec2(1920.0, 1080.0);

#define MARCH_DIST      1.5
#define MARCH_COUNT     60
#define SCATTER_DEPTH   10
#define SCATTER_DIST    2.5
#define SPHERE_RADIUS   2.4
#define SPHERE_DENSITY  3.0
//#define LIGHT_POS vec3(1.0 * cos(iTime), 10.0, 15.0)
#define LIGHT_COLOR 1.2 * vec3(0.5, 0.5, 1.0)
#define ABSORPTION_COLOR 0.0028 * vec3(1.0, 0.85, 0.7)
#define VOLUME_COLOR 0.045 * vec3(1.0, 0.75, 0.3)
#define NOISE_SCALE 5.2
#define BG_COLOR 1.3 * vec3(0.15, 0.25, 0.25)
float Speed = -10.0; // Speed : (speed), min=-1000.0, max=1000.0
float Density = 1.0; // Density : (density), min=0.0, max=10.0
float Brightness = 1.0; // Brightness : (brightness) min=0.0, max=10.0
float Seed = 6.5; // Seed : (seed), min=3.0, max=100.0





const float cloudscale = 1.2;
const float speed = 0.0;
const float clouddark = 0.5;
const float cloudlight = 0.3;
float cloudcover = -0.0 + UV.y * 2.0 - ttime * 0.04; //2.0; //clamp (0.0+ 1.0*UV.y,0.0,1.0); //ttime * 0.02;
const float cloudalpha = 10.0;
const float skytint = 0.5;
const vec3 skycolour1 = 0.5 * vec3(1.0, 1.0, 1.0);
const vec3 skycolour2 = 0.5 * vec3(1.0, 1.0, 1.0);

const mat2 m = mat2(1.6, 1.2, -1.2, 1.6);




float iTime = ttime;



#define BIG_NUMBER 1000000.0
#define FOCAL_LENGTH 0.25

vec3 Hash13(in float x) {
	vec3 p = fract(x * vec3(0.1031, 0.103, 0.0973));
	p += dot(p, p.yzx + 33.33);
	return fract((p.xxy + p.yzz) * p.zyx);
}

float Hash11(in float x) {
	x = fract(x * 0.1031);
	x *= x + 33.33;
	x *= x + x;
	return fract(x);
}
float frr = 0.03;

float fakeSphere(in vec2 p, in vec3 o, in float r) {
	float persp = FOCAL_LENGTH / o.z;
	o.xy *= persp;
	r *= persp;

	p -= o.xy;
	float d = length(p);

	//if( d<r-frr)  return BIG_NUMBER;    

	if (d < r) {
		return -cos(asin(d / r)) * r + o.z;
	}

	return BIG_NUMBER;
}

void SpheresmainImage(out vec4 fragColor, in vec2 fragCoord) {
	vec2 uv = (fragCoord - 0.5 * vec2(1920.0, 1080.0)) / 1080.0;
	fragColor = vec4(0.0, 0.0, 0.0, 1.0);
	frr = 0.03;
	float depth = BIG_NUMBER;
	float totLength = 3.0;
	float rmult = 1.0;

	totLength = 0.0;
	if (ttime < 1.0) totLength = 3.0;
	if (ttime > 17.0)
		totLength = 6.5;
	if (ttime > 34.0)
		totLength = 0.5;
	if (ttime > 50.5)
		totLength = 0.0;
	if (ttime > 102.2)
	{
		frr = 100.0;
		iTime *= 3.0;
		totLength = 12.0-clamp ((ttime-136.0)*14.0,0.0,100.0);;
		rmult = 0.6 + 2.0 * fftbeat * fftbeat * 2.0;
		rmult *= clamp((ttime - 102.0) * 0.05, 0.0, 1.0);
	}

	for (float seed = 318.547; seed < 318.547 + totLength; seed++) {
		vec3 o1 = Hash13(seed) * vec3(2.0, 2.0, 1.0) - vec3(1.0, 1.0, 0.0);
		vec3 o2 = Hash13(seed + 1) * vec3(2.0, 2.0, 1.0) - vec3(1.0, 1.0, 0.0);
		o1.x*=0.5+2.0*fftbeat;
		o2.x*=0.5+2.0*fftbeat;
		//o1.x+=sin (5.0*fftbeat+seed);
		vec3 o = mix(o1, o2, fract(0.1 * iTime));
		float r = rmult * (0.1 + 0.4 * Hash11(seed));
		depth = min(depth, fakeSphere(uv, o, r));
	}

	float ordepth=depth;

	if (depth > 0.99)
		depth = 0.0;
	else
		if (ttime > 102.2) {
			depth = 0.5 + 0.4 * sin(depth * 600.0);
		}

	fragColor += depth;

	if (ttime > 135.0) {

		if ((depth > 0.1) && (depth < 0.4))
		{
		}
		else
			fragColor *= 0.0;

	}

	if (ttime < 101.2)
		//if (ttime>17.0) 
	{
		if ((depth > 0.1) && (depth < 0.102))
		{
		}
		else
			fragColor *= 0.0;
	}

	fragColor.xyz=hsv2rgb(vec3 (ordepth*5.0,1.0,fragColor.x));
	//if (ttime>
	//fragColor.xyz*=vec3 (1,0,0);
}












vec2 Qhash(vec2 p) {
	p = vec2(dot(p, vec2(127.1, 311.7)), dot(p, vec2(269.5, 183.3)));
	return -1.0 + 2.0 * fract(sin(p) * 43758.5453123);
}

float Qnoise(in vec2 p) {
	const float K1 = 0.366025404; // (sqrt(3)-1)/2;
	const float K2 = 0.211324865; // (3-sqrt(3))/6;
	vec2 i = floor(p + (p.x + p.y) * K1);
	vec2 a = p - i + (i.x + i.y) * K2;
	vec2 o = (a.x > a.y) ? vec2(1.0, 0.0) : vec2(0.0, 1.0); //vec2 of = 0.5 + 0.5*vec2(sign(a.x-a.y), sign(a.y-a.x));
	vec2 b = a - o + K2;
	vec2 c = a - 1.0 + 2.0 * K2;
	vec3 h = max(0.5 - vec3(dot(a, a), dot(b, b), dot(c, c)), 0.0);
	vec3 n = h * h * h * h * vec3(dot(a, Qhash(i + 0.0)), dot(b, Qhash(i + o)), dot(c, Qhash(i + 1.0)));
	return dot(n, vec3(70.0));
}

float Qfbm(vec2 n) {
	float total = 0.0, amplitude = 0.1;
	for (int i = 0; i < 7; i++) {
		total += Qnoise(n) * amplitude;
		n = m * n;
		amplitude *= 0.4;
	}
	return total;
}


float ddd;

float lookup(vec2 p, float dx, float dy)
{
	vec2 uv = (p.xy + vec2(dx * ddd, dy * ddd)) / vec2(1920.0, 1080.0);
	vec4 c = texture(texture2d, uv.xy);

	// return as luma
	return 0.2126 * c.r + 0.7152 * c.g + 0.0722 * c.b;
}

void Glow(out vec4 fragColor, in vec2 fragCoord)
{
	ddd = sin(ttime * 5.0) * 0.5 + 1.5; // kernel offset
	vec2 p = fragCoord.xy;

	// simple sobel edge detection
	float gx = 0.0;
	gx += -1.0 * lookup(p, -1.0, -1.0);
	gx += -2.0 * lookup(p, -1.0, 0.0);
	gx += -1.0 * lookup(p, -1.0, 1.0);
	gx += 1.0 * lookup(p, 1.0, -1.0);
	gx += 2.0 * lookup(p, 1.0, 0.0);
	gx += 1.0 * lookup(p, 1.0, 1.0);

	float gy = 0.0;
	gy += -1.0 * lookup(p, -1.0, -1.0);
	gy += -2.0 * lookup(p, 0.0, -1.0);
	gy += -1.0 * lookup(p, 1.0, -1.0);
	gy += 1.0 * lookup(p, -1.0, 1.0);
	gy += 2.0 * lookup(p, 0.0, 1.0);
	gy += 1.0 * lookup(p, 1.0, 1.0);

	// hack: use g^2 to conceal noise in the video
	float g = gx * gx + gy * gy;
	float g2 = g * (sin(ttime) / 2.0 + 0.5);

	vec4 col = texture(texture2d, p / vec2(1920.0, 1080.0));
	col += vec4(0.0, g, g2, 1.0);

	fragColor = col;
}



vec4 QmainImage(in vec2 fragCoord) {
	vec4 TheOutput;
	vec2 p = fragCoord.xy / iResolution.xy;
	vec2 uv = p * vec2(iResolution.x / iResolution.y, 1.0);

	float time = ttime * speed;
	float q = Qfbm(uv * cloudscale * 0.5);

	//ridged noise shape
	float r = 0.0;
	uv *= cloudscale;
	uv -= q - time;
	float weight = 0.8;
	for (int i = 0; i < 8; i++) {
		r += abs(weight * Qnoise(uv));
		uv = m * uv + time;
		weight *= 0.7;
	}

	//noise shape
	float f = 0.0;
	uv = p * vec2(iResolution.x / iResolution.y, 1.0);
	uv *= cloudscale;
	uv -= q - time;
	weight = 0.7;
	for (int i = 0; i < 8; i++) {
		f += weight * Qnoise(uv);
		uv = m * uv + time;
		weight *= 0.6;
	}

	f *= r + f;

	//noise colour
	float c = 0.0;
	time = ttime * speed * 2.0;
	uv = p * vec2(iResolution.x / iResolution.y, 1.0);
	uv *= cloudscale * 2.0;
	uv -= q - time;
	weight = 0.4;
	for (int i = 0; i < 7; i++) {
		c += weight * Qnoise(uv);
		uv = m * uv + time;
		weight *= 0.6;
	}

	//noise ridge colour
	float c1 = 0.0;
	time = ttime * speed * 3.0;
	uv = p * vec2(iResolution.x / iResolution.y, 1.0);
	uv *= cloudscale * 3.0;
	uv -= q - time;
	weight = 0.4;
	for (int i = 0; i < 7; i++) {
		c1 += abs(weight * Qnoise(uv));
		uv = m * uv + time;
		weight *= 0.6;
	}

	c += c1;

	vec3 skycolour = mix(skycolour2, skycolour1, p.y);
	vec3 cloudcolour = vec3(1.1, 1.1, 0.9) * clamp((clouddark + cloudlight * c), 0.0, 1.0);

	f = cloudcover + cloudalpha * f * r;

	vec3 result = mix(skycolour, clamp(skytint * skycolour + cloudcolour, 0.0, 1.0), clamp(f + c, 0.0, 1.0));

	TheOutput = vec4(result, 1.0);
	return TheOutput;
}












float hash(float n)
{
	return fract(sin(n) * 43758.5453);
}

float rand(float n) { return fract(sin(n) * 43758.5453123); }

float noise2(float p) {
	float fl = floor(p);
	float fc = fract(p);
	return mix(rand(fl), rand(fl + 1.0), fc);
}


float noise(in vec3 x)
{
	vec3 p = floor(x);
	vec3 f = fract(x);

	f = f * f * (3.0 - 2.0 * f);

	float n = p.x + p.y * 57.0 + 113.0 * p.z;

	float res = mix(mix(mix(hash(n + 0.0), hash(n + 1.0), f.x),
		mix(hash(n + 57.0), hash(n + 58.0), f.x), f.y),
		mix(mix(hash(n + 113.0), hash(n + 114.0), f.x),
			mix(hash(n + 170.0), hash(n + 171.0), f.x), f.y), f.z);
	return res;
}

float fbm(vec3 p)
{
	float f;
	f = 0.5000 * noise(p); p = p * 2.02;
	f += 0.2500 * noise(p); p = p * 2.03;
	f += 0.1250 * noise(p);
	return f;
}


float Star(vec3 p) {
	Brightness = 1.5;
	vec3 pos = p;
	p += vec3(1.35, 1.54, 1.23);
	p *= .3;
	for (int i = 0; i < 18; i++) {
		p.xyz = abs(p.xyz);
		p = p / dot(p, p);
		p = p * 1. - vec3(.9 * Seed * 0.1);
	}
	return 1.0 * clamp(pow(length(p), 1.3 * Brightness) * .004 * (Density + 0.75), 0.0, 10.0);
}

float Stars(vec3 p) {
	float coun = 0.0;
	float f = 0.0;
	for (int x = -1; x < 2; x++)
		for (int y = -1; y < 2; y++)
		{
			coun++;
			f += Star(p + vec3(x, y, 0) * 0.001);
		}
	f /= coun;


	f += (1.0 - UV.y) * 0.4 * fbm(p * 0.7 + vec3(0, 0, 0.1 * ttime));
	//f*=0.0;
	return f;
};


#define DRAG_MULT 4.0


#define wave(uv, emitter, speed, phase, timeshift) pow(1.+3., sin(distance(uv, emitter) * phase - (0.31*3.0*qttime + timeshift) * speed)-1.)

vec2 wavedrag(vec2 uv, vec2 emitter) {
	return normalize(uv - emitter);
}

float getwaves(vec2 position) {
	position *= 0.1;

	float iter = 0.0;
	float phase = 6.0;
	float speed = 2.0;
	float weight = 1.0;
	float w = 0.0;
	float ws = 0.0;
	for (int i = 0; i < 16; i++) {
		vec2 p = vec2(sin(iter), cos(iter)) * 30.0;
		float res = wave(position, p, speed, phase, 0.0);
		float res2 = wave(position, p, speed, phase, 0.006);
		position -= wavedrag(position, p) * (res - res2) * weight * DRAG_MULT;
		w += res * weight;
		iter += 12.0;
		ws += weight;
		weight = mix(weight, 0.0, 0.2);
		phase *= 1.2;
		speed *= 1.02;
	}
	return w / ws;
}
float getwavesHI(vec2 position) {
	position *= 0.1;
	float iter = 0.0;
	float phase = 6.0;
	float speed = 2.0;
	float weight = 1.0;
	float w = 0.0;
	float ws = 0.0;
	for (int i = 0; i < 40; i++) {
		vec2 p = vec2(sin(iter), cos(iter)) * 30.0;
		float res = wave(position, p, speed, phase, 0.0);
		float res2 = wave(position, p, speed, phase, 0.006);
		position -= wavedrag(position, p) * (res - res2) * weight * DRAG_MULT;
		w += res * weight;
		iter += 12.0;
		ws += weight;
		weight = mix(weight, 0.0, 0.2);
		phase *= 1.2;
		speed *= 1.02;
	}

	fred2 = abs(w / ws);
	fred2 = pow(fred2, 3.0);

	return w / ws;
}

vec3 normal(vec2 pos, float e, float depth) {
	vec2 ex = vec2(e, 0);
	float H = getwavesHI(pos.xy) * depth;
	vec3 a = vec3(pos.x, H, pos.y);
	return normalize(cross(normalize(a - vec3(pos.x - e, getwavesHI(pos.xy - ex.xy) * depth, pos.y)),
		normalize(a - vec3(pos.x, getwavesHI(pos.xy + ex.yx) * depth, pos.y + e))));
}

mat3 rotmat(vec3 axis, float angle)
{
	axis = normalize(axis);
	float s = sin(angle);
	float c = cos(angle);
	float oc = 1.0 - c;

	return mat3(oc * axis.x * axis.x + c, oc * axis.x * axis.y - axis.z * s, oc * axis.z * axis.x + axis.y * s,
		oc * axis.x * axis.y + axis.z * s, oc * axis.y * axis.y + c, oc * axis.y * axis.z - axis.x * s,
		oc * axis.z * axis.x - axis.y * s, oc * axis.y * axis.z + axis.x * s, oc * axis.z * axis.z + c);
}
#define mouse vec2 (0.5,0.8)
vec3 getRay(vec2 uv) {
	uv = (uv * 2.0 - 1.0) * vec2(iResolution.x / iResolution.y, 1.0);
	vec3 proj = normalize(vec3(uv.x, uv.y, 1.0) + vec3(uv.x, uv.y, -1.0) * pow(length(uv), 1.0) * 0.05);
	if (iResolution.x < 400.0) return proj;

	vec3 ray = rotmat(vec3(0.0, -1.0, 0.0), mouse.x * 2.0 - 1.0) * rotmat(vec3(1.0, 0.0, 0.0), -0.0 + 0.04 + 0.5 * (mouse.y * 2.0 - 1.0)) * proj;
	return ray;
}
float rand2sTimex(vec2 co) {
	return fract(sin(dot(co.xy * 3.0 * qttime, vec2(12.9898, 78.233))) * 43758.5453);
}

float raymarchwater(vec3 camera, vec3 start, vec3 end, float depth) {
	vec3 pos = start;
	float h = 0.0;
	float hupper = depth;
	float hlower = 0.0;
	vec2 zer = vec2(0.0);
	vec3 dir = normalize(end - start);
	for (int i = 0; i < 318; i++) {
		h = getwaves(pos.xz) * depth - depth;
		if (h + 0.01 > pos.y) {
			return distance(pos, camera);
		}
		pos += dir * (pos.y - h);
	}
	return -1.0;
}
float intersectPlane(vec3 origin, vec3 direction, vec3 point, vec3 normal)
{
	return clamp(dot(point - origin, normal) / dot(direction, normal), -1.0, 9991999.0);
}

vec3 getatm(vec3 ray) {
	float fr = 1.0 - UV.y - 0.7;
	//fr=UV.y-0.0;

	fr = clamp(fr, 0.0, 1.0);

	//fr*=fr;

	fr *= 4.0;
	fr += 0.13;
	//if (ray.y>0.12) fr*=0.3;
	fr *= 1.0 - 4.0 * (ray.y - 0.12);
	fr *= 1.0 - 2.5 * (ray.z);
	return fr * vec3(1.0 - abs(ray.y));
	return mix(vec3(0.0), vec3(0.2, 0.2, 0.2) * 16.0, (abs(ray.y)));

}

float sun(vec3 ray) {
	vec3 sd = normalize(vec3(1.0));
	ray.y = 0.0;
	//ray=normalize(ray);
	return 0.0;
	float sn = dot(ray, sd);
	//sn=pow(sn,5.0);
	sn = 1.0 - 15.0 * length(ray.x - qttime * 10.1 + 1 + ray.y * 11.0);
	sn = clamp(sn, 0.0, 1.0);
	//return 0.0;
	return 101.0 * sn;

	return pow(0.5 + 0.5 * sin(sn * 40.0 - qttime * 0.0), 10) * 3.0;
	return pow(max(0.0, dot(ray, sd)), 128.0) * 110.0;
}
vec3 getColor(vec2 uv) {

	float waterdepth = 1.6;
	//waterdepth-=clamp ((qttime-29.0)*0.35,0.0,1.0)*1.8;
		//if (uv.y>0.45)	waterdepth=6.0;
	//	if (ttime>=28.0)
		//waterdepth+=clamp (uv.y-0.4,0.0,100.0)*15.0;


	//waterdepth*=1.0-clamp (ttime-17.0-uv.x*5.0,0.0,1.0);
	vec3 wfloor = vec3(0.0, -waterdepth, 0.0);
	vec3 wceil = vec3(0.0, 0.0, 0.0);
	float fz = 0.0;
	fz = -0.7;
	//RePosY=0.01*(ttime-14.0);

	vec3 orig = vec3(-qttime * 0 + RePosX * 2000.0, RePosY * 2000.0 + 1.0 - fz * 0.5, 0.0 + fz - 0.7 * qttime + 1.1 * ttime);



	vec3 ray = getRay(uv);
	float hihit = intersectPlane(orig, ray, wceil, vec3(0.0, 1.0, 0.0));
	if (ray.y >= -0.01) {
		vec3 C = getatm(ray) * 2.0 + sun(ray);
		//tonemapping
		C = normalize(C) * sqrt(length(C));
		return C;
	}
	float lohit = intersectPlane(orig, ray, wfloor, vec3(0.0, 1.0, 0.0));
	vec3 hipos = orig + ray * hihit;
	vec3 lopos = orig + ray * lohit;
	float dist = raymarchwater(orig, hipos, lopos, waterdepth);
	vec3 pos = orig + ray * dist;

	vec3 N = normal(pos.xz, 0.01, waterdepth);
	FinalNormal = N;
	vec2 velocity = N.xz * (1.0 - N.y);
	N = mix(vec3(0.0, 1.0, 0.0), N, 1.0 / (dist * dist * 0.01 + 1.0));
	vec3 R = reflect(ray, N);
	float fresnel = (0.04 + (1.0 - 0.04) * (pow(1.0 - max(0.0, dot(-N, ray)), 5.0)));

	vec3 C = fresnel * getatm(R) * 2.0; // + fresnel * sun(R);

	// water sprays, TimoKinnunen comment on 2017-Apr-2
	C += smoothstep(.09, .2, length(velocity));

	//tonemapping
	C = normalize(C) * sqrt(length(C));

	return C;
}

void mainImage(out vec4 fragColor, in vec2 fragCoord)
{

	vec2 uv = fragCoord.xy / iResolution.xy;

	vec3 ray = getRay(uv);
	vec3 C = vec3(0.0);
	vec2 dfx = 1.0 / iResolution.xy;
	float dof = clamp(UV.t - 0.45, 0.0, 1.0);
	dof *= 4.0;


	dof = 1.0;

	//dof = 1.0 + 8.0*clamp(0.4 - UV.t, 0.0, 1.0);


	dof = clamp(dof, 0.0, 1000.0);
	vec2 supersampler = dof * dfx;
	vec2 diff = uv;
	float W = 0.0;
	for (int i = 0; i < 1; i++) {
		C += getColor(uv + vec2(rand2sTimex(diff), rand2sTimex(diff + 100.0)) * supersampler);
		diff += 200.0;
		W += 1.0;
	}
	C /= W;
	fragColor = vec4(C, 1.0);
}



#define CELL_SIZE 7.0*pow(1920.0/1920.,0.35)

#define N(v) (v.yx*vec2(1,-1))
#define Res vec2 (1920.0,1080.0)
#define Res0 vec2 (1920.0,1080.0)
#define Res1 vec2 (1920.0,1080.0)
#define PI2 6.28318530718

vec4 getCol(vec2 pos)
{
	vec2 texc = pos / Res0.xy;
	vec4 c = texture(texture2d, texc);
	//return c;
	//vec4 bg=vec4(.9,1,.5,1);
	vec4 bg = vec4(.8, .9, 1, 1) * 1.;
	c = mix(c, bg, clamp(dot(c.xyz, vec3(-1, 2, -1)), 0., 1.));
	if (texc.x > 1. || texc.x < 0. || texc.y>1. || texc.y < 0.) c = bg;
	return c;
}

float getVal(vec2 pos)
{
	return dot(getCol(pos).xyz, vec3(.333));
}

vec2 getGrad(vec2 pos, float eps)
{
	vec2 d = vec2(eps, 0);
	return
		vec2(getVal(pos + d.xy) - getVal(pos - d.xy),
			getVal(pos + d.yx) - getVal(pos - d.yx)) / eps / 2.;
}

vec2 getGrad(vec2 pos)
{
	return getGrad(pos, .5);
}

vec4 getRand(vec2 pos)
{
	return texture(texture2d, pos / Res1) * 2. - 1.;
}

vec2 getPoint(int x, int y, float cellSize)
{
	vec2 rnd = getRand(vec2(x, y) + .5).xy;
	vec2 offs = vec2(0);

	offs += -.3 * (getGrad(vec2(x, y) * cellSize / Res * Res0, .5));

	//offs = (getCol(vec2(x,y)).yz)*6.;
	offs /= max(pow(dot(offs, offs), 0.25), 0.00001);

	// uncomment one of the bwlow lines if you want hexagonal tiling
	//offs.x+=-.45*.5+.45*mod(float(y),2.);
	offs.y += -0.45 * .5 + .45 * mod(float(x), 2.);
	//offs.y+=(-.25+.5*mod(float(x),2.));
	//offs.x-=(-.05+.1*mod(float(y),2.));

	offs += 0.2 * rnd;

	vec2 v = vec2(x, y);

	return v * cellSize + cellSize * offs * 3.3;
}

float tri01(float x)
{
	float m = mod(x + 1., 2.);
	return (1. - m) * 2. * step(1., m) + m;
}

float fillFunc(float x, float f, float smth)
{
	return clamp((f - tri01(x)) / smth + .33, 0., 1.);
}

vec2 TC(vec2 c)
{
	//all image visible on screen
	float sc = min(Res.x / Res0.x, Res.y / Res0.y);

	//one axis of image fully visible on screen
	//float sc=max(Res.x/Res0.x,Res.y/Res0.y);

	//compromise of the 2 above cases
	//float sc=mix(Res.x/Res0.x,Res.y/Res0.y,.5);

	return (c - Res * .5) / sc + Res0 * .5;
}


vec2 angularQuant(vec2 v, float num)
{
	float ang = floor((atan(v.y, v.x) + 2. * PI2) / (PI2 / num)) * (PI2 / num);
	return vec2(cos(ang), sin(ang));
}



vec3 SkyColor(vec2 UV) {


	vec4 clouds = vec4(0.0);
	vec2 UVV = UV.xy + vec2(0.0, -ttime * 0.00);
	//UVV.x-= (0.5);
	UVV.y = pow(UVV.y * 1.0, 1.0);
	clouds = QmainImage(UVV.xy * iResolution);
	clouds = pow(clouds, vec4(2.0));

	vec3 Col = vec3(1, 0.3, 0.0);
	clouds.xyz *= Col.xyz;
	vec3 cloudscache = clouds.xyz;
	//clouds*=pow (UV.y,2.0);
	//Col*=1.0-UV.y;
	//if (UV.y>0.95) Col*=0.5;
	float sky = fbm(vec3(UV.xy * 1 * vec2(5, 1) * vec2(16.0 / 9.0, 1.0), 0.5 + ttime * 0.1));
	float fbm2 = fbm(vec3(UV.xy * 1.35 * vec2(1, 1) * vec2(16.0 / 9.0, 1.0), 0.5 + ttime * 0.3));
	//fbm2*=fbm2;
	//sky*=sky;
	sky *= pow((1.3 - UV.y), 2.0);
	sky *= pow(1.0 - abs(UV.x - 0.5), 5.0);
	float rise = 0.0 + ttime * 0.017;
	rise = clamp(rise, 0.0, 0.3944);
	float DistCent = 1.0 - length((UV.xy - vec2(0.5) - vec2(0, -0.4 + rise)) * vec2(16.0 / 9.0, 1.0));

	vec3 MyStars = vec3(max(0.0, .2 * Stars(vec3(0, -ttime * 0.0, 0) + vec3(0, 0, 3) +
		vec3(vec2(UV.x, UV.y) * 1.0, 0.1) * 10.2 * vec3(16.0 / 9.0, 1.0, 1.0))));

	vec3 MyStars2 = vec3(max(0.0, 0.4 * Stars(vec3(0, -ttime * 0.0, 0) + vec3(0, 0, 3) +
		vec3(vec2(UV.x, UV.y) * 1.0, 0.1) * 10.2 * vec3(16.0 / 9.0, 1.0, 1.0))));


	MyStars = pow(MyStars, vec3(2.5));
	//MyStars = clamp(MyStars, vec3(0.0), vec3(1.0));


	sky *= pow(DistCent, 5.0);
	vec4 CC = texture(texture2d, UV).xyzw;
	Col *= 1.0 - CC.w;
	Col *= sky;
	clouds.xyz += 7.0 * vec3(1, 0.8, 0.6) * pow(DistCent, 4.0);
	clouds.xyz += fbm2 * 2.0 * vec3(0, 0.0, 1.0) * pow(DistCent, 1.0);
	float fss = clamp((ttime) * 0.15, 0.0, 1.0);

	//float faa=1.0;

	float ccx = CC.x;
	//if (abs (UV.x-0.5)<0.15) ccx=1.0;
	//ccx=1.0;
	//CC.w=0.0;
	Col += clouds.xyz * 0.4 * fss * (1.0 - CC.w * ccx); //*pow (UV.y,5.0);
	Col += MyStars * pow(UV.y, 4.0 + (ttime * 0.5)) * (1.0 - CC.w);




	if (ttime > 21) {

		//Col=vec3 (1,1,1)-Col;
		float blacksun = pow(DistCent, 4.0);
		vec3 BCol;
		BCol = vec3(2) - vec3(blacksun * 4.0); //*(1.0-CC.w);
		BCol -= 0.3 * vec3(cloudscache);
		BCol = clamp(BCol, vec3(0.0), vec3(10.0));
		vec2 PV = (UV - vec2(0.5)) * vec2(16.0 / 9.0, 1.0);
		float fa = atan(PV.x, PV.y);
		fa = 0.2 * sin(fa * 3.14159 * 2.0 * 2.0);
		Col += (BCol - Col) * clamp((ttime - 23.0 + Col.x * 1.0 + 4.0 * CC.w) * 1.0, 0.0, 1.0);
	}
	//Col+=MyStars2*CC.w;
									//Col+=(clouds.xyz-Col)*pow (UV.y,7.0);
	//Col=(clouds.xyz); //-Col)*pow (UV.y,7.0);
	//if (UV.y<0.3) return vec3 (1.0);
	return (Col.xyz);


};





vec3 FindVel() {


	float coun = 0.000001;
	vec3 VelAcc = vec3(0.0);
	for (int qy = -15; qy < 16; qy++)
		for (int qx = -15; qx < 16; qx++)
		{

			vec2 MyUV = vec2(qx, qy) * 0.0008 * vec2(9.0 / 16.0, 1.0) + UV.xy;
			if (texture(texture2d, MyUV).w < 0.999) continue;

			vec3 Vel = texture(texture2d2, MyUV).xyz;
			Vel -= vec3(0.5);
			VelAcc += Vel;
			coun++;
		}

	VelAcc /= coun;
	//VelAcc*=0.0;
	return VelAcc;
};




vec3 FindAO() {


	float coun = 0.000001;
	vec3 VelAcc = vec3(0.0);
	for (int qy = -5; qy < 6; qy++)
		for (int qx = -5; qx < 6; qx++)
		{

			vec2 MyUV = vec2(qx, qy) * 0.0005 * vec2(9.0 / 16.0, 1.0) + UV.xy;
			if (texture(texture2d, MyUV).w < 0.999) continue;

			vec3 Vel = texture(texture2d, MyUV).yyy;
			VelAcc += Vel;
			coun++;
		}

	VelAcc /= coun;
	//VelAcc*=0.0;
	return VelAcc;
};





void main(void)
{



	float TheBeat = 0.0;

	{
		float beat = sin(1.2 + 1.3 + 3.1415926535 * 1.0 * 57.0 * (ttime + UV.y * 0.25) / 60.0);
		beat *= beat;
		//beat *= beat;

		beat = mod(beat, 1.0);
		TheBeat = clamp(1.0 - 4000.0 * beat * beat, 0.0, 1.0);
		//int BeatID = (-0.3 + ttime) * bpm / 60.0;
	}






	vec3 MyVel = FindVel();

	gl_FragData[0].xyz = texture(texture2d, UV.xy).xyz;

	float coun = 0;
	float velSpeed = 0.4; //fftbeat;
	vec3 Acc = vec3(0.0);

	if (ttime > 67.9)
		velSpeed = 5.0 + fftbeat * 80.0;

	if (ttime > 135.3)
		velSpeed = 0.2;
	if (ttime > 101.0)
		if (ttime < 112.0)
			velSpeed = 0.2;

	for (int q = 0; q < 30; q++) {
		float fc = float(q) / 30.0;
		Acc += texture(texture2d, UV.xy + 0.4 * fc * velSpeed * vec2(1, 1) * MyVel.xy).xyz;
		coun++;
	}
	Acc /= coun;

	vec3 FoundAcc = Acc;
	//Acc.xyz = texture(texture2d, UV.xy).xyz;




	//if (length (MyVel)<0.01) gl_FragData[0].xyz*=0.0;//discard;
	float AO = FindAO().x;
	AO = (1.0 - 5.0 * abs(AO - texture(texture2d, UV.xy).y));
	//if (texture(texture2d, UV.xy).w < 0.9) AO = 0.0;
	AO = 1.0;
	float distc = length((UV.xy - vec2(0.5)) * vec2(16.0 / 9.0, 1.0));

	float velv = clamp((ttime - 50) * 0.3, 0.0, 1.0);
	//	Acc = hsv2rgb(vec3(0.5 + length(MyVel) * 7.0+distc, 0.7, texture(texture2d,UV.xy).w*length (MyVel)*5.0+0.0*Acc.x));



	Acc = hsv2rgb(vec3(0.5 + length(MyVel) * 7.0 + distc * 0.15 + 0.2 * UV.y + 0.0 * FoundAcc.x, 0.9,
		fftbeat * 20.0 * texture(texture2d, UV.xy).w * length(MyVel) * 35.0 * velv + 0.5 * FoundAcc.x));
	if (ttime < 135.3)
		if (ttime > 67.9)
			Acc = hsv2rgb(vec3(0.5 + length(MyVel) * 5.0 + distc * 0.35 + 0.0 * UV.y + 5.0 * FoundAcc.x, 0.7,
				fftbeat * 2.0 * texture(texture2d, UV.xy).w * length(MyVel) * 15.0 * velv + 2.0 * FoundAcc.x));
	//Acc = MyVel.xyz; 
	//Acc.xyz = texture(texture2d, UV.xy).xyz;
	gl_FragData[0].xyz = Acc;

	if (ttime > 135.3)
	{
		float ff = fbm(vec3(0.5, 0.5, 2.0 * ttime + 0.2 * UV.y));
		gl_FragData[0].xyz *= 27.0;
		if (ff < 0.5)
			gl_FragData[0].xyz = gl_FragData[0].xxx;



		gl_FragData[0].xyz +=
			clamp((ttime - 0.0) * 0.5, 0.0, 1.0) * 0.3 *
			0.15 * vec3(max(0.0, .6 * Stars(vec3(0, -(ttime - 135.0) * 0.29, 0) + vec3(0, 0, 0) +
				vec3(vec2(UV.x, UV.y) * 1.0, 0.1) * 12.2 * vec3(16.0 / 9.0, 1.0, 1.0))));
	}

	/*
		}
			///if (distc>0.3)


		gl_FragData[0].xyz+=
			clamp ((ttime-0.0)*0.5,0.0,1.0)*0.0*
		 0.15*vec3(max(0.0, .2 * Stars(vec3(0, -ttime * 0.09, 0) + vec3(0, 0, 0) +
			vec3(vec2(UV.x, UV.y) * 1.0, 0.1) * 2.2 * vec3(16.0 / 9.0, 1.0, 1.0))));
	/*
		if (ttime>=16.85)
		gl_FragData[0].xyz+=
		clamp (distc*distc*2.0-0.1,0.0,1.0)*0.0*
			clamp ((ttime-0.0)*0.5,0.0,1.0)*
		 0.15*vec3(max(0.0, .2 * Stars(vec3(0, ttime * 0.1, 0) + vec3(0, 0, 0) +
			vec3((vec2(UV.x, UV.y)-vec2 (0.5)) +vec2 (0.5), 0.1+(ttime-16.0)*0.0+0.0*fftbeat) * 2.2 * vec3(16.0 / 9.0, 1.0, 1.0))));
		*/


	gl_FragData[0].xyz *= clamp((ttime), 0.0, 1.0);
	//if (ttime<67.0)

	if (ttime < 67.0)
		if (fftbeat < 0.007)
			gl_FragData[0].xyz = gl_FragData[0].xxx * 1.5;

	if (ttime > 67.0)
		if (fftbeat > 0.237)
			gl_FragData[0].xyz = gl_FragData[0].xxx;

	if (ttime < 70.0) {
		vec4 Gloww;
		Glow(Gloww, UV * vec2(1920.0, 1080.0));

		if (fftbeat > 0.0075)
			gl_FragData[0].xyz = Gloww.xyz;
	}




	if (ttime > 68.0)
	{
		vec3 MyStars = vec3(max(0.0, .2 * Stars(vec3(0, -ttime * 0.0, 0) + vec3(0, 0, 3) +
			vec3(vec2(UV.x - 0.5, UV.y - 0.5) * 1.0, 0.1) * (1.0 + fftbeat * 1.0) * 15.2 * vec3(16.0 / 9.0, 1.0, 1.0))));


		gl_FragData[0].xyz += 0.03 * MyStars;


	}
	if (ttime < 105.0)
		if (ttime > 84.6)
		{
			vec3 MyStars = vec3(max(0.0, .2 * Stars(vec3(0, -ttime * 0.0, 0) + vec3(0, 0, 0) +
				vec3(vec2(UV.x - 0.5, UV.y - 0.5) * 1.0, 0.1) * (1.0 + fftbeat * 1.0) * 55.2 * vec3(16.0 / 9.0, 1.0, 1.0))));


			gl_FragData[0].xyz += 0.03 * MyStars;


		}
	//	if (ttime<105.0)
	if (ttime > 128.0)
	{
		vec3 MyStars = vec3(max(0.0, .2 * Stars(vec3(0, -ttime * 0.0, 0) + vec3(0, 0, 0) +
			vec3(vec2(UV.x - 0.5, UV.y - 0.5) * 1.0, 0.1) * (1.0 + fftbeat * 1.0) * 55.2 * vec3(16.0 / 9.0, 1.0, 1.0))));


		gl_FragData[0].xyz -= 0.23 * MyStars;


	}


	//gl_FragData[0].xyz=FoundAcc*0.05;
	//gl_FragData[0].xyz *= 1.0+10.0*(fftbeat);

//gl_FragData[0].xyz+=1.0*vec3 (fftbeat);
	//gl_FragData[0].xyz=texture (texture2d, UV.xy).xxx*AO*vec3( 1.0); 

	vec3 Text =
		texture(textureText, vec2(-0.3 + 1.66 * UV.x, -0.2 + 1.0 - UV.y)).xyz; // * vec3(1, 1, 1);
	{
		float fc = clamp((ttime - 6.0 - 0.0 + UV.y * 4.0 - UV.x * 4.0) * 0.2, 0.0, 1.0);

		bool prec = false;
		if (UV.y < 0.74)
			prec = true;

		if (!prec)
			fc -= clamp((ttime - 6.0 - 2.5 + UV.y * 4.0 - UV.x * 4.0) * 0.2, 0.0, 1.0);
		else
			fc -= clamp((ttime - 9.0 - 2.5 + UV.y * 4.0 - UV.x * 4.0) * 0.2, 0.0, 1.0);


		float fb = fbm(vec3(0.5, 0.5, 2.0 * ttime));
		if (fc < 0.5) fc = 0.0; else fc = 1.0;
		float fc2 = clamp((ttime - 0.0 + UV.y * 4.0 - UV.x * 4.0) * 0.03, 0.0, 1.0);
		//if (UV.x<0.5) 		Text*=vec3( 0,1,1)*0.0;

		vec3 Col = vec3(1, 1, 1);
		// ASD
		fb = fbm(vec3(0.5, 0.5, 1.0 * ttime));
		if (fb > 0.5)
			if (UV.x < 0.31)							Col = 0.0 * vec3(0, 1, 1);
		fb = fbm(vec3(0.5, 0.5, 0.5 + 1.0 * ttime));


		if (fb > 0.45)
			if (UV.y > 0.74)
				if (UV.x > 0.31)							Col = 0.0 * vec3(0, 1, 1);
		// violet
		fb = fbm(vec3(0.5, 0.5, 1.0 + 1.0 * ttime));
		if (fb > 0.45)
			if (UV.y < 0.74) Col = 0.0 * vec3(0, 1, 1);

		Text.xyz *= vec3(1.1, 1, 1.0);
		gl_FragData[0].xyz += (vec3(0.1) - 0.1 * Text) * fc * Col; //*fc2*5.0;
	}
	//gl_FragData[0].xyz*=vec3 (1.0)-vec3 (1.05*TheBeat);


	{


		vec4 fragColor;

		SpheresmainImage(fragColor, vec2(UV.x, 1.0 - UV.y) * vec2(1920.0, 1080.0));
		//SpheresmainImage(out vec4 fragColor, in vec2 fragCoord) 

		if (ttime>135.0)
			fragColor*=2.0;
		//if (distc<0.5)
		//if (ttime<135.3)		if (sin(UV.y*200.0+ttime*5.0)<0.0)

		//if (ttime<135.3)	if (ttime>119.0) gl_FragData[0]*=0.0;

		if (length(fragColor.xyz) > 0.02)
		{
			fragColor.xyz = pow(fragColor.xyz, vec3(2.0));
			gl_FragData[0].xyz = fragColor.xyz * vec3(1, 1, 1);
		}
	}


	//_FragData[0].y=0.0;
//gl_FragData[0].xyz = MyVel*30.0+vec3 (0.5); //texture (texture2d2, UV.xy-vec2 (0.2,0.0)).xyz;

//gl_FragData[0].xyz = texture(texture2d2, UV.xy).xyz;

}
