"use strict";

class LoadingContext {
    _promises;
    _spriteManager;
    _shaderManager;

    constructor(promises, spriteManager, shaderManager) {
        this._promises = promises;
        this._spriteManager = spriteManager;
        this._shaderManager = shaderManager;
    }

    loadSprite(name, filename) {
        const promise = this._spriteManager.load(name, `./sprites/${filename}`);
        this._promises.push(promise);
    }

    loadShader(name, vertexFilename, fragmentFilename) {
        const promise = this._shaderManager.load(name, `./shaders/${vertexFilename}`, `./shaders/${fragmentFilename}`)
        this._promises.push(promise);
    }

}