"use strict";

class RenderContext {
    text;   // Single line of text to be shown on the screen

    _renderQueue;
    _z = 0.1;
    _spriteManager;
    _shaderManager;
    _textManager;
    _karaokeManager;
    _width = 240;
    _height = 136;

    constructor(spriteManager, shaderManager, textManager, karaokeManager)
    {
        this._spriteManager = spriteManager;
        this._shaderManager = shaderManager;
        this._textManager = textManager;
        this._karaokeManager = karaokeManager;

        const spriteShader = shaderManager.get("sprite");
        this._renderQueue = new RenderQueue(spriteShader);
    }

    setDimensions(width, height) {
        this._width = width;
        this._height = height;
    }

    // Overloaded: call with either a SpriteItem or with (the limited set of convenience) parameters
    sprite(nameOrItem, x, y, width, angle) {
        
        if (typeof nameOrItem == 'object') {
            if (nameOrItem.shaderName)
                nameOrItem.shader = nameOrItem.shader || this._shaderManager.get(nameOrItem.shaderName);
            if (nameOrItem.name)
                nameOrItem.sprite = nameOrItem.sprite || this._spriteManager.get(nameOrItem.name);
            this._renderQueue.addSprite(nameOrItem);
            return;
        }

        var sprite = this._spriteManager.get(nameOrItem);

        if (!sprite)
            throw `Sprite "${nameOrItem}" not found in sprite manager.`;

        const spriteItem = new SpriteItem();
        spriteItem.sprite = sprite;
        spriteItem.width = width;
        spriteItem.position = { x: x, y: y, z: this._z += 0 };
        spriteItem.rotation = angle;
        this._renderQueue.addSprite(spriteItem);
    }

    backgroundShader(name, parameters) {
        var shader = this._shaderManager.get(name);
        this._renderQueue.setBackgroundShader(shader, parameters);
    }

    postShader(name, parameters) {
        var shader = this._shaderManager.get(name);
        this._renderQueue.setPostShader(shader, parameters);
    }

    getTextRect() {
        return this._textManager.getTextRect(this._width, this._height);
    }

    get renderQueue() {
        return this._renderQueue;
    }

    get karaokeManager() {
        return this._karaokeManager;
    }
}

