class RenderQueue {
    _spriteShader;
    _backgroundShader;
    _backgroundShaderParameters;
    _postShader;
    _postShaderParameters;
    _sprites = [];  // Array of sprite-typed render items

    constructor(spriteShader) {
        this._spriteShader = spriteShader;
    }
    
    setBackgroundShader(shader, parameters) {
        this._backgroundShader = shader;
        this._backgroundShaderParameters = parameters;
    }

    setPostShader(shader, parameters) {
        this._postShader = shader;
        this._postShaderParameters = parameters;
    }
    
    addSprite(spriteItem) {
        this._sprites.push(spriteItem);
    }

    get backgroundShader() {
        return this._backgroundShader;
    }

    get backgroundShaderParameters() {
        return this._backgroundShaderParameters;
    }

    get postShader() {
        return this._postShader;
    }

    get postShaderParameters() {
        return this._postShaderParameters;
    }

    get spriteShader() {
        return this._spriteShader;
    }

    get sprites() {
        return this._sprites;
    }
}