"use strict";

class ComeBackScene extends BaseScene {

    // Load resources here
    load(loadingContext) {
        const ctx = loadingContext;
        ctx.loadShader("sunnySky", "fullscreen.vert", "sunnySky.frag");
        ctx.loadShader("fireEye", "sprite.vert", "fireEye.frag");
        ctx.loadSprite("arm","arm.png");
        ctx.loadSprite("dramaanimal","dramaanimal.png");
    }

    // One-time initialization at start of scene
    initialize() {
    }

    // This is where the magic happens
    update(renderContext, time, globalTime) {
        const ctx = renderContext;
        ctx.backgroundShader("sunnySky", {horizonAngle: 0});
        const bounceTime = time % 1;
        const animalBounce = Math.max(0,Math.sin(Math.sin(bounceTime*Math.PI)*Math.PI/2));
        const animalScale = 40/(time+30);

        ctx.sprite("dramaanimal",time*12+Math.cos(bounceTime*Math.PI)*4+70,40+animalBounce*40,40*animalScale);

        const hoodBounceTime = Math.min(0.6,Math.exp(-Math.pow(time*2-11,2)) +  Math.exp(-Math.pow(time*2-21,2)))/0.6;
        this._drawHoodedOne(globalTime, ctx,40,190-hoodBounceTime*96,0.8);
    }

    _drawHoodedOne(time, ctx, x, y,scale) {
        ctx.sprite("hood", x, y, 128*scale);
        const anger = 0.8 - 0.35 * Math.abs(Math.sin(time / 5));
        const eyeTransparency = this._clamp((time - 16) / 1, 0, 1);
        const eyeAlpha = eyeTransparency * (1.0 - 0.8 * Math.abs(Math.sin(time / 3)));
        ctx.sprite("arm",x+65,y,70*scale);
        this._drawEye(x-17*scale, y-12*scale, anger, eyeAlpha, 0, ctx,scale);
        this._drawEye(x+13*scale, y-12*scale, anger, eyeAlpha, 0.5, ctx, scale);
        ctx.sprite("hoodMask", x, y, 128*scale);
    }


    _drawEye(x, y, anger, alpha, offset, ctx,scale) {
        const item = new SpriteItem();
        item.width = 25*scale;
        item.shaderName = "fireEye";
        item.shaderParameters = {
            anger: -anger,
            alpha: alpha,
            offset: offset
        }
        item.position.x = x;
        item.position.y = y;
        ctx.sprite(item);
   }

}