// Testshader. Mostly copied from 
//  https://www.shadertoy.com/view/4dfGzn

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 q = fragCoord.xy / iResolution.xy;
    vec2 uv = 0.5 + (q-0.5)*(0.9 + 0.1*sin(0.2*iTime));

    vec3 col;

    col.r = texture(iChannel0,vec2(uv.x+0.003,1.0-uv.y)).x;
    col.g = texture(iChannel0,vec2(uv.x+0.000,1.0-uv.y)).y;
    col.b = texture(iChannel0,vec2(uv.x-0.003,1.0-uv.y)).z;

    col = clamp(col*0.5+0.5*col*col*1.2,0.0,1.0);

    col *= 0.5 + 0.5*16.0*uv.x*uv.y*(1.0-uv.x)*(1.0-uv.y);

    col *= vec3(0.95,1.05,0.95);

    col *= 0.9+0.1*sin(10.0*iTime+uv.y*1000.0);

    col *= 0.99+0.01*sin(110.0*iTime);

    // grey with a splash of color
    float dist = distance(q, vec2(0.5, 0.5));
    dist = clamp(dist * dist * 13.0, 0.0, 1.0);
    float grey = dot(col, vec3(0.2126, 0.7152, 0.0722));
    vec3 greyCol = vec3(grey, grey, grey);
    col = mix(col, greyCol, dist);

    fragColor = vec4(col,1.0);
}