; Monotron
; Fastmade 128b entry for Outline 2023 from T$
; runs on MS-DOS / FreeDOS / DosBOX (cycles = max or at least high enough for > 18 fps) 
; note that some windows machines have insufficient pc speaker timing both with XP DOS box or NTVDN,
; use plain DOS for maximum fidelity

org 100h

push word 0a000h
pop es

; optional: set fs explicitly to avoid problems with some memory managers:
push byte 0
pop fs

mov al,13h
int 10h

schleife:

; visuals

mov ax,bp
and ax,63
neg ax
add ax,di
xor dx,dx
mov cx,320
div cx

mov dh,8

mov cx,bp
shr cl,6
shl dh,cl

mov cx,bp
test cl,dh
jnz noinv
 neg cl
noinv:
dec dh
and cl,dh

and al,dh
and dl,dh

mov bx,bp
xor bh,bh

test ch,1
jz nogrid
 xchg bh,bl
nogrid:

cmp al,cl
jc nix
cmp dl,cl
jc nix
 xchg bh,bl
nix:

mov al,bl

stosb

or di,di
jnz schleife

mov bp,[fs:0x46c]

; sound

mov ax,bp

mov cx,bp
shr cx,4
and al,cl

mov cl,ch
and cl,3
add cl,4
shl ax,cl ;5

out 42h,al ; set speaker freq
out 42h,al
not al
out 61h,al ; enable speaker

; ui

in al,60h
; optional: check with dec instead of das for better dosbox compatibility:
dec al       ;das
jnz schleife ;jp schleife
ret

db "MONOTRON"