layout (location = 0) in vec2 v_depth_map_uv;
layout (location = 1) in vec3 v_ray_eye;
layout (location = 2) in vec3 v_ray_direction;

layout (location = 0) out vec4 f_color;

layout (set = 1, binding = 1) uniform sampler2D depth_buffer;
layout (set = 1, binding = 2) uniform sampler2D noise_texture;

layout (set = 1, binding = 0) uniform Uniforms {
    mat4 g_projection_from_camera;
    mat4 g_camera_from_world;
    float g_z_near;
    float g_app_time;

    vec3 col1;
    vec3 col2;
    vec3 col3;

    vec4 movement;
    vec4 cloud_zoom;
    vec4 cloud1;
    vec4 cloud2;
    vec4 quality;
    float far100;

    vec4 foo;
};

//float noise(float t) {
//    vec2 size = textureSize(noise_texture, 0);
//    return textureLod(noise_texture, vec2(t, .0) * foo.y / 256, 0.0).x;
//}

float moy = 0.;

float noise(in vec3 p)
{
    vec2 size = textureSize(noise_texture, 0);

    vec3 ip = floor(p);
    vec3 fp = fract(p);
    fp = fp * fp * (3.0 - 2.0 * fp);
    vec2 tap = (ip.xy + foo.zw * ip.z) + fp.xy;
    vec2 rz = textureLod(noise_texture, (p.xz) * foo.x + p.y * foo.y, 0.0).yx;
    return mix(rz.x, rz.y, fp.z);
}

float fbm(in vec3 x)
{
    float rz = 0.;
    float a = .35;
    for (int i = 0; i < 2; i++) {
        rz += noise(x) * a;
        a *= .35;
        x *= 4.;
    }
    return rz;
}

float path(in float x) { return sin(x * 0.01 - 3.1415) * 28. + 6.5; }
float density_map(vec3 p) {
    return (foo.z-p.y*foo.w) * 0.07 + (fbm(p * 0.3) - 0.1) + sin(p.x * cloud1.w + sin(p.z * cloud1.z) * cloud1.y) * cloud1.x + 0.15 + sin(p.z * cloud2.y) * cloud2.x;
}

float density_map_2(vec3 p) {
    vec3 scale = vec3(cloud_zoom.y, cloud_zoom.w*100, cloud_zoom.y);
    return density_map(p) - density_map(p * scale) * cloud_zoom.z * 0.01;
}

vec4 trace_cloud(vec3 eye, vec3 dir, float buffer_depth) {
    vec3 col = vec3(0.1, 0.2, 0.55);
    vec3 bgc = col;
    float far = min(buffer_depth, far100 * 100);

    // Find the cloud
    float precis = .3;
    float dist = g_z_near;
    for (int i = 0; i < 50; i++)
    {
        vec3 pos = eye + dir * dist;
        float h = density_map(pos);
        dist += h;
        if (abs(h) > 0.001 || dist > far) break;
    }

    float alpha = 0;
    vec4 result = vec4(0);
    for (int i = 0; i < 150; i++)
    {
        if (result.a > (1- movement.w * 0.01) || dist > far) break;
        vec3 pos = eye + dist * dir;
        vec3 sample_pos = pos * vec3(cloud_zoom.x, 1, cloud_zoom.x);
        float dens = density_map_2(sample_pos);
//        den = clamp(-den, 0, 1);

        vec4 col = vec4(mix(col1, vec3(.0), dens), dens);
//        col.xyz *= mix(bgc * bgc * 2.5, mix(col2, col3, moy * 0.4), clamp(-(dens * 40. + 0.) * pos.y * .03 - moy * 0.5, 0., 1.));
        col.rgb += clamp((1. - dens * 6.) + pos.y * 0.13 + .55, 0., 1.) * 0.35 * mix(bgc, vec3(1), 0.7); //Fringes
        col += clamp(dens * pos.y * .15, -.02, .0); //Depth occlusion
        col *= smoothstep(0.2 + moy * 0.05, .0, density_map_2(sample_pos)) * .85 + 0.15; //Shadows
//
//        col.a *= .95;

//        return col;

//        return vec4(den, den, den, 1.0);
        float alpha = clamp(dens * cloud2.w, 0, cloud2.z);
//        den = clamp(den, 0, 1);

        result.rgb += col.rgb * (1 - result.a) * alpha;
        result.a += (1 - result.a) * alpha;

//        col.rgb *= col.a;
//        result = result + col * (1.0 - result.a);

        dist += max(quality.x, (quality.y - dens * quality.z) * dist * quality.w * 0.01);
    }

    return result;

    return vec4(dist * foo.x, 0, 0, 0.5);


    return vec4(col, 0.5);
}



void main() {
    float depth_sample = texture(depth_buffer, v_depth_map_uv).r;
    float buffer_z = depth_sample_to_z(g_z_near, depth_sample);
    vec3 eye = v_ray_eye;
    vec3 dir = normalize(v_ray_direction);
    float buffer_depth = buffer_z / length(v_ray_direction);

    eye.xz += movement.xy *g_app_time * 10;

    //    dir.z *= -1;
    f_color = trace_cloud(eye, dir, buffer_depth);
}
